/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.spatial.GeometryExpression;
import com.querydsl.spatial.GeometryExpressions;
import com.querydsl.spatial.PointExpression;
import com.querydsl.spatial.SpatialOps;
import javax.annotation.Nullable;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Point;

public abstract class CurveExpression<T extends Geometry>
extends GeometryExpression<T> {
    private static final long serialVersionUID = 6139188586728676033L;
    @Nullable
    private volatile transient NumberExpression<Double> length;
    @Nullable
    private volatile transient PointExpression<Point> startPoint;
    @Nullable
    private volatile transient PointExpression<Point> endPoint;
    @Nullable
    private volatile transient BooleanExpression closed;
    @Nullable
    private volatile transient BooleanExpression ring;

    public CurveExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Double> length() {
        if (this.length == null) {
            this.length = Expressions.numberOperation(Double.class, (Operator)SpatialOps.LENGTH, (Expression[])new Expression[]{this.mixin});
        }
        return this.length;
    }

    public PointExpression<Point> startPoint() {
        if (this.startPoint == null) {
            this.startPoint = GeometryExpressions.pointOperation(SpatialOps.START_POINT, this.mixin);
        }
        return this.startPoint;
    }

    public PointExpression<Point> endPoint() {
        if (this.endPoint == null) {
            this.endPoint = GeometryExpressions.pointOperation(SpatialOps.END_POINT, this.mixin);
        }
        return this.endPoint;
    }

    public BooleanExpression isClosed() {
        if (this.closed == null) {
            this.closed = Expressions.booleanOperation((Operator)SpatialOps.IS_CLOSED, (Expression[])new Expression[]{this.mixin});
        }
        return this.closed;
    }

    public BooleanExpression isRing() {
        if (this.ring == null) {
            this.ring = Expressions.booleanOperation((Operator)SpatialOps.IS_RING, (Expression[])new Expression[]{this.mixin});
        }
        return this.ring;
    }
}

