/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.lucene5;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.lucene5.IgnoreCaseUnsupportedException;
import com.querydsl.lucene5.LuceneOps;
import com.querydsl.lucene5.PhraseElement;
import com.querydsl.lucene5.TermElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

public class LuceneSerializer {
    private static final Map<Class<?>, SortField.Type> sortFields = new HashMap();
    private static final Splitter WS_SPLITTER;
    public static final LuceneSerializer DEFAULT;
    private final boolean lowerCase;
    private final boolean splitTerms;
    private final Locale sortLocale;

    public LuceneSerializer(boolean lowerCase, boolean splitTerms) {
        this(lowerCase, splitTerms, Locale.getDefault());
    }

    public LuceneSerializer(boolean lowerCase, boolean splitTerms, Locale sortLocale) {
        this.lowerCase = lowerCase;
        this.splitTerms = splitTerms;
        this.sortLocale = sortLocale;
    }

    private Query toQuery(Operation<?> operation, QueryMetadata metadata) {
        Operator op = operation.getOperator();
        if (op == Ops.OR) {
            return this.toTwoHandSidedQuery(operation, BooleanClause.Occur.SHOULD, metadata);
        }
        if (op == Ops.AND) {
            return this.toTwoHandSidedQuery(operation, BooleanClause.Occur.MUST, metadata);
        }
        if (op == Ops.NOT) {
            BooleanQuery bq = new BooleanQuery();
            bq.add(new BooleanClause(this.toQuery(operation.getArg(0), metadata), BooleanClause.Occur.MUST_NOT));
            bq.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
            return bq;
        }
        if (op == Ops.LIKE) {
            return this.like(operation, metadata);
        }
        if (op == Ops.EQ) {
            return this.eq(operation, metadata, false);
        }
        if (op == Ops.EQ_IGNORE_CASE) {
            throw new IgnoreCaseUnsupportedException();
        }
        if (op == Ops.NE) {
            return this.ne(operation, metadata, false);
        }
        if (op == Ops.STARTS_WITH) {
            return this.startsWith(metadata, operation, false);
        }
        if (op == Ops.STARTS_WITH_IC) {
            throw new IgnoreCaseUnsupportedException();
        }
        if (op == Ops.ENDS_WITH) {
            return this.endsWith(operation, metadata, false);
        }
        if (op == Ops.ENDS_WITH_IC) {
            throw new IgnoreCaseUnsupportedException();
        }
        if (op == Ops.STRING_CONTAINS) {
            return this.stringContains(operation, metadata, false);
        }
        if (op == Ops.STRING_CONTAINS_IC) {
            throw new IgnoreCaseUnsupportedException();
        }
        if (op == Ops.BETWEEN) {
            return this.between(operation, metadata);
        }
        if (op == Ops.IN) {
            return this.in(operation, metadata, false);
        }
        if (op == Ops.NOT_IN) {
            return this.notIn(operation, metadata, false);
        }
        if (op == Ops.LT) {
            return this.lt(operation, metadata);
        }
        if (op == Ops.GT) {
            return this.gt(operation, metadata);
        }
        if (op == Ops.LOE) {
            return this.le(operation, metadata);
        }
        if (op == Ops.GOE) {
            return this.ge(operation, metadata);
        }
        if (op == LuceneOps.LUCENE_QUERY) {
            Constant expectedConstant = (Constant)operation.getArg(0);
            return (Query)expectedConstant.getConstant();
        }
        throw new UnsupportedOperationException("Illegal operation " + operation);
    }

    private Query toTwoHandSidedQuery(Operation<?> operation, BooleanClause.Occur occur, QueryMetadata metadata) {
        Query lhs = this.toQuery(operation.getArg(0), metadata);
        Query rhs = this.toQuery(operation.getArg(1), metadata);
        BooleanQuery bq = new BooleanQuery();
        bq.add(this.createBooleanClause(lhs, occur));
        bq.add(this.createBooleanClause(rhs, occur));
        return bq;
    }

    private BooleanClause createBooleanClause(Query query, BooleanClause.Occur occur) {
        BooleanClause[] clauses;
        if (query instanceof BooleanQuery && (clauses = ((BooleanQuery)query).getClauses()).length == 1 && clauses[0].getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
            return clauses[0];
        }
        return new BooleanClause(query, occur);
    }

    protected Query like(Operation<?> operation, QueryMetadata metadata) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        String field = this.toField(path);
        String[] terms = this.convert(path, operation.getArg(1));
        if (terms.length > 1) {
            BooleanQuery bq = new BooleanQuery();
            for (String s : terms) {
                bq.add((Query)new WildcardQuery(new Term(field, "*" + s + "*")), BooleanClause.Occur.MUST);
            }
            return bq;
        }
        return new WildcardQuery(new Term(field, terms[0]));
    }

    protected Query eq(Operation<?> operation, QueryMetadata metadata, boolean ignoreCase) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        String field = this.toField(path);
        if (Number.class.isAssignableFrom(operation.getArg(1).getType())) {
            Constant rightArg = (Constant)operation.getArg(1);
            return new TermQuery(new Term(field, this.convertNumber((Number)rightArg.getConstant())));
        }
        return this.eq(field, this.convert(path, operation.getArg(1), metadata), ignoreCase);
    }

    private BytesRef convertNumber(Number number) {
        if (Integer.class.isInstance(number) || Byte.class.isInstance(number) || Short.class.isInstance(number)) {
            BytesRefBuilder ref = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)number.intValue(), (int)0, (BytesRefBuilder)ref);
            return ref.get();
        }
        if (Double.class.isInstance(number) || BigDecimal.class.isInstance(number)) {
            BytesRefBuilder ref = new BytesRefBuilder();
            long l = NumericUtils.doubleToSortableLong((double)number.doubleValue());
            NumericUtils.longToPrefixCoded((long)l, (int)0, (BytesRefBuilder)ref);
            return ref.get();
        }
        if (Long.class.isInstance(number) || BigInteger.class.isInstance(number)) {
            BytesRefBuilder ref = new BytesRefBuilder();
            NumericUtils.longToPrefixCoded((long)number.longValue(), (int)0, (BytesRefBuilder)ref);
            return ref.get();
        }
        if (Float.class.isInstance(number)) {
            BytesRefBuilder ref = new BytesRefBuilder();
            int i = NumericUtils.floatToSortableInt((float)number.floatValue());
            NumericUtils.intToPrefixCoded((int)i, (int)0, (BytesRefBuilder)ref);
            return ref.get();
        }
        throw new IllegalArgumentException("Unsupported numeric type " + number.getClass().getName());
    }

    protected Query eq(String field, String[] terms, boolean ignoreCase) {
        if (terms.length > 1) {
            PhraseQuery pq = new PhraseQuery();
            for (String s : terms) {
                pq.add(new Term(field, s));
            }
            return pq;
        }
        return new TermQuery(new Term(field, terms[0]));
    }

    protected Query in(Operation<?> operation, QueryMetadata metadata, boolean ignoreCase) {
        Path<?> path = this.getPath(operation.getArg(0));
        String field = this.toField(path);
        Constant expectedConstant = (Constant)operation.getArg(1);
        Collection values = (Collection)expectedConstant.getConstant();
        BooleanQuery bq = new BooleanQuery();
        if (Number.class.isAssignableFrom(path.getType())) {
            for (Object value : values) {
                TermQuery eq = new TermQuery(new Term(field, this.convertNumber((Number)value)));
                bq.add((Query)eq, BooleanClause.Occur.SHOULD);
            }
        } else {
            for (Object value : values) {
                String[] str = this.convert(path, value);
                bq.add(this.eq(field, str, ignoreCase), BooleanClause.Occur.SHOULD);
            }
        }
        return bq;
    }

    protected Query notIn(Operation<?> operation, QueryMetadata metadata, boolean ignoreCase) {
        BooleanQuery bq = new BooleanQuery();
        bq.add(new BooleanClause(this.in(operation, metadata, false), BooleanClause.Occur.MUST_NOT));
        bq.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
        return bq;
    }

    protected Query ne(Operation<?> operation, QueryMetadata metadata, boolean ignoreCase) {
        BooleanQuery bq = new BooleanQuery();
        bq.add(new BooleanClause(this.eq(operation, metadata, ignoreCase), BooleanClause.Occur.MUST_NOT));
        bq.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
        return bq;
    }

    protected Query startsWith(QueryMetadata metadata, Operation<?> operation, boolean ignoreCase) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        String field = this.toField(path);
        String[] terms = this.convertEscaped(path, operation.getArg(1), metadata);
        if (terms.length > 1) {
            BooleanQuery bq = new BooleanQuery();
            for (int i = 0; i < terms.length; ++i) {
                String s = i == 0 ? terms[i] + "*" : "*" + terms[i] + "*";
                bq.add((Query)new WildcardQuery(new Term(field, s)), BooleanClause.Occur.MUST);
            }
            return bq;
        }
        return new PrefixQuery(new Term(field, terms[0]));
    }

    protected Query stringContains(Operation<?> operation, QueryMetadata metadata, boolean ignoreCase) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        String field = this.toField(path);
        String[] terms = this.convertEscaped(path, operation.getArg(1), metadata);
        if (terms.length > 1) {
            BooleanQuery bq = new BooleanQuery();
            for (String s : terms) {
                bq.add((Query)new WildcardQuery(new Term(field, "*" + s + "*")), BooleanClause.Occur.MUST);
            }
            return bq;
        }
        return new WildcardQuery(new Term(field, "*" + terms[0] + "*"));
    }

    protected Query endsWith(Operation<?> operation, QueryMetadata metadata, boolean ignoreCase) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        String field = this.toField(path);
        String[] terms = this.convertEscaped(path, operation.getArg(1), metadata);
        if (terms.length > 1) {
            BooleanQuery bq = new BooleanQuery();
            for (int i = 0; i < terms.length; ++i) {
                String s = i == terms.length - 1 ? "*" + terms[i] : "*" + terms[i] + "*";
                bq.add((Query)new WildcardQuery(new Term(field, s)), BooleanClause.Occur.MUST);
            }
            return bq;
        }
        return new WildcardQuery(new Term(field, "*" + terms[0]));
    }

    protected Query between(Operation<?> operation, QueryMetadata metadata) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        return this.range(path, this.toField(path), operation.getArg(1), operation.getArg(2), true, true, metadata);
    }

    protected Query lt(Operation<?> operation, QueryMetadata metadata) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        return this.range(path, this.toField(path), null, operation.getArg(1), false, false, metadata);
    }

    protected Query gt(Operation<?> operation, QueryMetadata metadata) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        return this.range(path, this.toField(path), operation.getArg(1), null, false, false, metadata);
    }

    protected Query le(Operation<?> operation, QueryMetadata metadata) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        return this.range(path, this.toField(path), null, operation.getArg(1), true, true, metadata);
    }

    protected Query ge(Operation<?> operation, QueryMetadata metadata) {
        this.verifyArguments(operation);
        Path<?> path = this.getPath(operation.getArg(0));
        return this.range(path, this.toField(path), operation.getArg(1), null, true, true, metadata);
    }

    protected Query range(Path<?> leftHandSide, String field, @Nullable Expression<?> min, @Nullable Expression<?> max, boolean minInc, boolean maxInc, QueryMetadata metadata) {
        if (min != null && Number.class.isAssignableFrom(min.getType()) || max != null && Number.class.isAssignableFrom(max.getType())) {
            Class numType;
            Constant minConstant = (Constant)min;
            Constant maxConstant = (Constant)max;
            Class unboundedNumType = numType = minConstant != null ? minConstant.getType() : maxConstant.getType();
            return this.numericRange(unboundedNumType, field, minConstant == null ? (Number)null : (Number)((Number)minConstant.getConstant()), maxConstant == null ? (Number)null : (Number)((Number)maxConstant.getConstant()), minInc, maxInc);
        }
        return this.stringRange(leftHandSide, field, min, max, minInc, maxInc, metadata);
    }

    protected <N extends Number> NumericRangeQuery<?> numericRange(Class<N> clazz, String field, @Nullable N min, @Nullable N max, boolean minInc, boolean maxInc) {
        if (clazz.equals(Integer.class)) {
            return NumericRangeQuery.newIntRange((String)field, (Integer)((Integer)min), (Integer)((Integer)max), (boolean)minInc, (boolean)maxInc);
        }
        if (clazz.equals(Double.class)) {
            return NumericRangeQuery.newDoubleRange((String)field, (Double)((Double)min), (Double)((Double)max), (boolean)minInc, (boolean)minInc);
        }
        if (clazz.equals(Float.class)) {
            return NumericRangeQuery.newFloatRange((String)field, (Float)((Float)min), (Float)((Float)max), (boolean)minInc, (boolean)minInc);
        }
        if (clazz.equals(Long.class)) {
            return NumericRangeQuery.newLongRange((String)field, (Long)((Long)min), (Long)((Long)max), (boolean)minInc, (boolean)minInc);
        }
        if (clazz.equals(Byte.class) || clazz.equals(Short.class)) {
            return NumericRangeQuery.newIntRange((String)field, (Integer)(min != null ? Integer.valueOf(min.intValue()) : null), (Integer)(max != null ? Integer.valueOf(max.intValue()) : null), (boolean)minInc, (boolean)maxInc);
        }
        throw new IllegalArgumentException("Unsupported numeric type " + clazz.getName());
    }

    protected Query stringRange(Path<?> leftHandSide, String field, @Nullable Expression<?> min, @Nullable Expression<?> max, boolean minInc, boolean maxInc, QueryMetadata metadata) {
        if (min == null) {
            return TermRangeQuery.newStringRange((String)field, null, (String)this.convert(leftHandSide, max, metadata)[0], (boolean)minInc, (boolean)maxInc);
        }
        if (max == null) {
            return TermRangeQuery.newStringRange((String)field, (String)this.convert(leftHandSide, min, metadata)[0], null, (boolean)minInc, (boolean)maxInc);
        }
        return TermRangeQuery.newStringRange((String)field, (String)this.convert(leftHandSide, min, metadata)[0], (String)this.convert(leftHandSide, max, metadata)[0], (boolean)minInc, (boolean)maxInc);
    }

    private Path<?> getPath(Expression<?> leftHandSide) {
        Operation operation;
        if (leftHandSide instanceof Path) {
            return (Path)leftHandSide;
        }
        if (leftHandSide instanceof Operation && ((operation = (Operation)leftHandSide).getOperator() == Ops.LOWER || operation.getOperator() == Ops.UPPER)) {
            return (Path)operation.getArg(0);
        }
        throw new IllegalArgumentException("Unable to transform " + leftHandSide + " to path");
    }

    protected String toField(Path<?> path) {
        Path parent;
        PathMetadata md = path.getMetadata();
        if (md.getPathType() == PathType.COLLECTION_ANY) {
            return this.toField(md.getParent());
        }
        String rv = md.getName();
        if (md.getParent() != null && (parent = md.getParent()).getMetadata().getPathType() != PathType.VARIABLE) {
            rv = this.toField(parent) + "." + rv;
        }
        return rv;
    }

    private void verifyArguments(Operation<?> operation) {
        List arguments = operation.getArgs();
        for (int i = 1; i < arguments.size(); ++i) {
            if (arguments.get(i) instanceof Constant || arguments.get(i) instanceof ParamExpression || arguments.get(i) instanceof PhraseElement || arguments.get(i) instanceof TermElement) continue;
            throw new IllegalArgumentException("operand was of unsupported type " + ((Expression)arguments.get(i)).getClass().getName());
        }
    }

    protected String[] convert(Path<?> leftHandSide, Expression<?> rightHandSide, QueryMetadata metadata) {
        if (rightHandSide instanceof Operation) {
            Operation operation = (Operation)rightHandSide;
            if (operation.getOperator() == LuceneOps.PHRASE) {
                return (String[])Iterables.toArray((Iterable)WS_SPLITTER.split((CharSequence)operation.getArg(0).toString()), String.class);
            }
            if (operation.getOperator() == LuceneOps.TERM) {
                return new String[]{operation.getArg(0).toString()};
            }
            throw new IllegalArgumentException(rightHandSide.toString());
        }
        if (rightHandSide instanceof ParamExpression) {
            Object value = metadata.getParams().get(rightHandSide);
            if (value == null) {
                throw new ParamNotSetException((ParamExpression)rightHandSide);
            }
            return this.convert(leftHandSide, value);
        }
        if (rightHandSide instanceof Constant) {
            return this.convert(leftHandSide, ((Constant)rightHandSide).getConstant());
        }
        throw new IllegalArgumentException(rightHandSide.toString());
    }

    protected String[] convert(Path<?> leftHandSide, Object rightHandSide) {
        String str = rightHandSide.toString();
        if (this.lowerCase) {
            str = str.toLowerCase();
        }
        if (this.splitTerms) {
            if (str.equals("")) {
                return new String[]{str};
            }
            return (String[])Iterables.toArray((Iterable)WS_SPLITTER.split((CharSequence)str), String.class);
        }
        return new String[]{str};
    }

    private String[] convertEscaped(Path<?> leftHandSide, Expression<?> rightHandSide, QueryMetadata metadata) {
        String[] str = this.convert(leftHandSide, rightHandSide, metadata);
        for (int i = 0; i < str.length; ++i) {
            str[i] = QueryParser.escape((String)str[i]);
        }
        return str;
    }

    public Query toQuery(Expression<?> expr, QueryMetadata metadata) {
        if (expr instanceof Operation) {
            return this.toQuery((Operation)expr, metadata);
        }
        return this.toQuery(ExpressionUtils.extract(expr), metadata);
    }

    public Sort toSort(List<? extends OrderSpecifier<?>> orderBys) {
        ArrayList<Object> sorts = new ArrayList<Object>(orderBys.size());
        for (OrderSpecifier<?> order : orderBys) {
            if (!(order.getTarget() instanceof Path)) {
                throw new IllegalArgumentException("argument was not of type Path.");
            }
            Class type = order.getTarget().getType();
            boolean reverse = !order.isAscending();
            Path<?> path = this.getPath(order.getTarget());
            if (Number.class.isAssignableFrom(type)) {
                sorts.add(new SortedNumericSortField(this.toField(path), sortFields.get(type), reverse));
                continue;
            }
            sorts.add(new SortField(this.toField(path), SortField.Type.STRING, reverse));
        }
        Sort sort = new Sort();
        sort.setSort(sorts.toArray(new SortField[sorts.size()]));
        return sort;
    }

    static {
        sortFields.put(Integer.class, SortField.Type.INT);
        sortFields.put(Float.class, SortField.Type.FLOAT);
        sortFields.put(Long.class, SortField.Type.LONG);
        sortFields.put(Double.class, SortField.Type.DOUBLE);
        sortFields.put(BigDecimal.class, SortField.Type.DOUBLE);
        sortFields.put(BigInteger.class, SortField.Type.LONG);
        WS_SPLITTER = Splitter.on((Pattern)Pattern.compile("\\s+"));
        DEFAULT = new LuceneSerializer(false, true);
    }
}

