/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.lucene5;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.EmptyCloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.Fetchable;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.SimpleQuery;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.lucene5.LuceneSerializer;
import com.querydsl.lucene5.ResultIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.sandbox.queries.DuplicateFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;

public abstract class AbstractLuceneQuery<T, Q extends AbstractLuceneQuery<T, Q>>
implements SimpleQuery<Q>,
Fetchable<T> {
    private final QueryMixin<Q> queryMixin;
    private final IndexSearcher searcher;
    private final LuceneSerializer serializer;
    private final Function<Document, T> transformer;
    @Nullable
    private Set<String> fieldsToLoad;
    private List<Filter> filters = ImmutableList.of();
    @Nullable
    private Filter filter;
    @Nullable
    private Sort querySort;

    public AbstractLuceneQuery(LuceneSerializer serializer, IndexSearcher searcher, Function<Document, T> transformer) {
        this.queryMixin = new QueryMixin((Object)this, (QueryMetadata)new DefaultQueryMetadata());
        this.serializer = serializer;
        this.searcher = searcher;
        this.transformer = transformer;
    }

    public AbstractLuceneQuery(IndexSearcher searcher, Function<Document, T> transformer) {
        this(LuceneSerializer.DEFAULT, searcher, transformer);
    }

    private long innerCount() {
        try {
            int maxDoc = this.searcher.getIndexReader().maxDoc();
            if (maxDoc == 0) {
                return 0L;
            }
            return this.searcher.search((Query)this.createQuery(), (int)maxDoc, (Sort)Sort.INDEXORDER, (boolean)false, (boolean)false).totalHits;
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public long fetchCount() {
        return this.innerCount();
    }

    protected Query createQuery() {
        MatchAllDocsQuery returnedQuery = null;
        Object originalQuery = null;
        originalQuery = this.queryMixin.getMetadata().getWhere() == null ? new MatchAllDocsQuery() : this.serializer.toQuery((Expression<?>)this.queryMixin.getMetadata().getWhere(), this.queryMixin.getMetadata());
        Filter filter = this.getFilter();
        if (filter != null) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)originalQuery, BooleanClause.Occur.MUST);
            booleanQuery.add((Query)filter, BooleanClause.Occur.FILTER);
            returnedQuery = booleanQuery;
        } else {
            returnedQuery = originalQuery;
        }
        return returnedQuery;
    }

    public Filter asFilter() {
        return new QueryWrapperFilter(this.createQuery());
    }

    public Q distinct() {
        throw new UnsupportedOperationException("use distinct(path) instead");
    }

    public Q distinct(Path<?> property) {
        return this.filter((Filter)new DuplicateFilter(this.serializer.toField(property)));
    }

    public Q filter(Filter filter) {
        if (this.filters.isEmpty()) {
            this.filter = filter;
            this.filters = ImmutableList.of((Object)filter);
        } else {
            this.filter = null;
            if (this.filters.size() == 1) {
                this.filters = new ArrayList<Filter>();
            }
            this.filters.add(filter);
        }
        return (Q)this;
    }

    private Filter getFilter() {
        if (this.filter == null && !this.filters.isEmpty()) {
            BooleanQuery filterQuery = new BooleanQuery();
            for (Filter filter : this.filters) {
                filterQuery.add((Query)filter, BooleanClause.Occur.SHOULD);
            }
            this.filter = new QueryWrapperFilter((Query)filterQuery);
        }
        return this.filter;
    }

    public Q limit(long limit) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.limit(limit));
    }

    public CloseableIterator<T> iterate() {
        int limit;
        QueryMetadata metadata = this.queryMixin.getMetadata();
        List orderBys = metadata.getOrderBy();
        Integer queryLimit = metadata.getModifiers().getLimitAsInteger();
        Integer queryOffset = metadata.getModifiers().getOffsetAsInteger();
        Sort sort = this.querySort;
        int offset = queryOffset != null ? queryOffset : 0;
        try {
            limit = this.maxDoc();
            if (limit == 0) {
                return new EmptyCloseableIterator();
            }
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new QueryException((Throwable)e);
        }
        if (queryLimit != null && queryLimit < limit) {
            limit = queryLimit;
        }
        if (sort == null && !orderBys.isEmpty()) {
            sort = this.serializer.toSort(orderBys);
        }
        try {
            int sumOfLimitAndOffset = limit + offset;
            if (sumOfLimitAndOffset < 1) {
                throw new QueryException("The given limit (" + limit + ") and offset (" + offset + ") cause an integer overflow.");
            }
            ScoreDoc[] scoreDocs = sort != null ? this.searcher.search((Query)this.createQuery(), (int)sumOfLimitAndOffset, (Sort)sort, (boolean)false, (boolean)false).scoreDocs : this.searcher.search((Query)this.createQuery(), (int)sumOfLimitAndOffset, (Sort)Sort.INDEXORDER, (boolean)false, (boolean)false).scoreDocs;
            if (offset < scoreDocs.length) {
                return new ResultIterator<T>(scoreDocs, offset, this.searcher, this.fieldsToLoad, this.transformer);
            }
            return new EmptyCloseableIterator();
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
    }

    private List<T> innerList() {
        return new IteratorAdapter(this.iterate()).asList();
    }

    public List<T> fetch() {
        return this.innerList();
    }

    public Q load(Set<String> fieldsToLoad) {
        this.fieldsToLoad = fieldsToLoad;
        return (Q)this;
    }

    public Q load(Path<?> ... paths) {
        HashSet<String> fields = new HashSet<String>();
        for (Path<?> path : paths) {
            fields.add(this.serializer.toField(path));
        }
        this.fieldsToLoad = fields;
        return (Q)this;
    }

    public QueryResults<T> fetchResults() {
        List<T> documents = this.innerList();
        return new QueryResults(documents, this.queryMixin.getMetadata().getModifiers(), this.innerCount());
    }

    public Q offset(long offset) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.offset(offset));
    }

    public Q orderBy(OrderSpecifier<?> o) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.orderBy(o));
    }

    public Q orderBy(OrderSpecifier<?> ... o) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.orderBy(o));
    }

    public Q restrict(QueryModifiers modifiers) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.restrict(modifiers));
    }

    public <P> Q set(ParamExpression<P> param, P value) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.set(param, value));
    }

    public Q sort(Sort sort) {
        this.querySort = sort;
        return (Q)this;
    }

    @Nullable
    private T oneResult(boolean unique) {
        try {
            int maxDoc = this.maxDoc();
            if (maxDoc == 0) {
                return null;
            }
            ScoreDoc[] scoreDocs = this.searcher.search((Query)this.createQuery(), (int)maxDoc, (Sort)Sort.INDEXORDER, (boolean)false, (boolean)false).scoreDocs;
            int index = 0;
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            Long offset = modifiers.getOffset();
            if (offset != null) {
                index = offset.intValue();
            }
            Long limit = modifiers.getLimit();
            if (unique && (limit == null ? scoreDocs.length - index > 1 : limit > 1L && scoreDocs.length > 1)) {
                throw new NonUniqueResultException("Unique result requested, but " + scoreDocs.length + " found.");
            }
            if (scoreDocs.length > index) {
                Document document = this.fieldsToLoad != null ? this.searcher.doc(scoreDocs[index].doc, this.fieldsToLoad) : this.searcher.doc(scoreDocs[index].doc);
                return (T)this.transformer.apply((Object)document);
            }
            return null;
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public T fetchFirst() {
        return this.oneResult(false);
    }

    public T fetchOne() {
        return this.oneResult(true);
    }

    public Q where(Predicate e) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.where(e));
    }

    public Q where(Predicate ... e) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.where(e));
    }

    public String toString() {
        return this.createQuery().toString();
    }

    private int maxDoc() throws IOException {
        return this.searcher.getIndexReader().maxDoc();
    }
}

