/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.testutil;

import com.google.common.base.Verify;
import com.querydsl.jpa.JPATest;
import com.querydsl.jpa.Mode;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JPATestRunner
extends BlockJUnit4ClassRunner {
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private boolean isDerby;

    public JPATestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected List<MethodRule> rules(Object test) {
        Verify.verify((boolean)(test instanceof JPATest), (String)"In order to use the %s for %s, it should (directly or indirectly) implement %s", (Object[])new Object[]{JPATestRunner.class.getSimpleName(), test.getClass(), JPATest.class});
        List rules = super.rules(test);
        rules.add(new MethodRule(){

            public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        ((JPATest)target).setEntityManager(JPATestRunner.this.entityManager);
                        base.evaluate();
                    }
                };
            }
        });
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            this.start();
            super.run(notifier);
        }
        catch (Exception e) {
            e.printStackTrace();
            Failure failure = new Failure(Description.createSuiteDescription((Class)this.getTestClass().getJavaClass()), (Throwable)e);
            notifier.fireTestFailure(failure);
        }
        finally {
            this.shutdown();
        }
    }

    private void start() throws Exception {
        String mode = Mode.mode.get();
        if (mode == null) {
            mode = "h2perf";
        }
        System.out.println(mode);
        this.isDerby = mode.contains("derby");
        if (this.isDerby) {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)mode);
        this.entityManager = this.entityManagerFactory.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    private void shutdown() {
        block11: {
            if (this.entityManager != null) {
                try {
                    if (this.entityManager.getTransaction().isActive()) {
                        this.entityManager.getTransaction().rollback();
                    }
                }
                finally {
                    this.entityManager.close();
                    this.entityManager = null;
                }
            }
            if (this.entityManagerFactory != null) {
                if (this.entityManagerFactory.getCache() != null) {
                    this.entityManagerFactory.getCache().evictAll();
                }
                this.entityManagerFactory.close();
                this.entityManagerFactory = null;
            }
            if (this.isDerby) {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException e) {
                    if (e.getMessage().equals("Derby system shutdown.")) break block11;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

