/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.testutil;

import com.google.common.base.Verify;
import com.querydsl.jpa.HibernateTest;
import com.querydsl.jpa.Mode;
import com.querydsl.jpa.domain.Domain;
import java.io.InputStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class HibernateTestRunner
extends BlockJUnit4ClassRunner {
    private SessionFactory sessionFactory;
    private Session session;
    private boolean isDerby = false;

    public HibernateTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected List<MethodRule> rules(Object test) {
        Verify.verify((boolean)(test instanceof HibernateTest), (String)"In order to use the %s for %s, it should (directly or indirectly) implement %s", (Object[])new Object[]{HibernateTestRunner.class.getSimpleName(), test.getClass(), HibernateTest.class});
        List rules = super.rules(test);
        rules.add(new MethodRule(){

            public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        ((HibernateTest)target).setSession(HibernateTestRunner.this.session);
                        base.evaluate();
                    }
                };
            }
        });
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            this.start();
            super.run(notifier);
        }
        catch (Exception e) {
            e.printStackTrace();
            Failure failure = new Failure(Description.createSuiteDescription((Class)this.getTestClass().getJavaClass()), (Throwable)e);
            notifier.fireTestFailure(failure);
        }
        finally {
            this.shutdown();
        }
    }

    private void start() throws Exception {
        Configuration cfg = new Configuration();
        for (Class<?> cl : Domain.classes) {
            cfg.addAnnotatedClass(cl);
        }
        String mode = Mode.mode.get() + ".properties";
        this.isDerby = mode.contains("derby");
        if (this.isDerby) {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        Properties props = new Properties();
        InputStream is = HibernateTestRunner.class.getResourceAsStream(mode);
        if (is == null) {
            throw new IllegalArgumentException("No configuration available at classpath:" + mode);
        }
        props.load(is);
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)props).build();
        cfg.setProperties(props);
        this.sessionFactory = cfg.buildSessionFactory((ServiceRegistry)serviceRegistry);
        this.session = this.sessionFactory.openSession();
        this.session.beginTransaction();
    }

    private void shutdown() {
        block9: {
            if (this.session != null) {
                try {
                    this.session.getTransaction().rollback();
                }
                finally {
                    this.session.close();
                    this.session = null;
                }
            }
            if (this.sessionFactory != null) {
                this.sessionFactory.getCache().evictEntityRegions();
                this.sessionFactory.close();
                this.sessionFactory = null;
            }
            if (this.isDerby) {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException e) {
                    if (e.getMessage().equals("Derby system shutdown.")) break block9;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

