/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.support;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class TeradataDialect
extends Dialect {
    public TeradataDialect() {
        this.registerColumnType(2, "NUMERIC($p,$s)");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(-5, "NUMERIC(18,0)");
        this.registerColumnType(-7, "BYTEINT");
        this.registerColumnType(-6, "BYTEINT");
        this.registerColumnType(-3, "VARBYTE($l)");
        this.registerColumnType(-2, "BYTEINT");
        this.registerColumnType(-1, "LONG VARCHAR");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(3, "DECIMAL");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(16, "BYTEINT");
        this.registerColumnType(2004, "BLOB");
        this.registerColumnType(2005, "CLOB");
        this.registerFunction("year", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "extract(year from ?1)"));
        this.registerFunction("length", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "character_length(?1)"));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "(", "||", ")"));
        this.registerFunction("substring", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "substring(?1 from ?2 for ?3)"));
        this.registerFunction("locate", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "position(?1 in ?2)"));
        this.registerFunction("mod", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "?1 mod ?2"));
        this.registerFunction("str", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "cast(?1 as varchar(255))"));
        this.registerFunction("bit_length", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "octet_length(cast(?1 as char))*4"));
        this.registerFunction("current_timestamp", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.TIMESTAMP, "current_timestamp"));
        this.registerFunction("current_time", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.TIME, "current_time"));
        this.registerFunction("current_date", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.DATE, "current_date"));
        this.registerKeyword("account");
        this.registerKeyword("alias");
        this.registerKeyword("class");
        this.registerKeyword("column");
        this.registerKeyword("first");
        this.registerKeyword("map");
        this.registerKeyword("month");
        this.registerKeyword("password");
        this.registerKeyword("role");
        this.registerKeyword("summary");
        this.registerKeyword("title");
        this.registerKeyword("type");
        this.registerKeyword("value");
        this.registerKeyword("year");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsSequences() {
        return false;
    }

    public String getAddColumnString() {
        return "Add";
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return " on commit preserve rows";
    }

    public Boolean performTemporaryTableDDLInIsolation() {
        return Boolean.TRUE;
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        int p;
        float f = precision > 0 ? (float)scale / (float)precision : 0.0f;
        int n = p = precision > 18 ? 18 : precision;
        int s = precision > 18 ? (int)(18.0 * (double)f) : (scale > 18 ? 18 : scale);
        return super.getTypeName(code, (long)length, p, s);
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public String getSelectClauseNullString(int sqlType) {
        String v = "null";
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                v = "cast(null as decimal)";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                v = "cast(null as varchar(255))";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                v = "cast(null as timestamp)";
                break;
            }
        }
        return v;
    }

    public String getCreateMultisetTableString() {
        return "create multiset table ";
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public boolean supportsBindAsCallableArgument() {
        return false;
    }

    public boolean supportsNotNullUnique() {
        return false;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public boolean supportsDropPreProcess() {
        return true;
    }

    public String performDropPreProcess(Statement stmt, String dropSql) throws SQLException {
        String alterStr = "alter";
        String tableStr = "table";
        String dropStr = "drop";
        String constraintStr = "constraint";
        StringTokenizer st = new StringTokenizer(dropSql);
        if (alterStr.equalsIgnoreCase(st.nextToken()) && tableStr.equalsIgnoreCase(st.nextToken())) {
            String tableName = st.nextToken();
            if (tableName.startsWith("\"") && !tableName.endsWith("\"")) {
                String next = null;
                do {
                    next = st.nextToken();
                    tableName = tableName + " " + next;
                } while (next.endsWith("\\\"") || !next.endsWith("\""));
            }
            if (dropStr.equalsIgnoreCase(st.nextToken()) && constraintStr.equalsIgnoreCase(st.nextToken())) {
                int idxEnd;
                String constraintName = st.nextToken();
                int idxStart = dropSql.indexOf(tableStr, 0) + 5;
                tableName = dropSql.substring(idxStart, idxEnd = dropSql.lastIndexOf(dropStr)).trim();
                if (tableName.startsWith("\"") && tableName.endsWith("\"")) {
                    tableName = tableName.substring(1, tableName.length() - 1);
                }
                String arrStr = null;
                String queryStr = "sel IndexId, ChildTable, IndexName from dbc.RI_Distinct_ChildrenV where IndexName = '" + constraintName + "'";
                ResultSet rs = stmt.executeQuery(queryStr);
                if (rs.next()) {
                    arrStr = "drop table \"" + tableName + "_" + rs.getString(1) + "\"";
                    rs.close();
                    return arrStr;
                }
            }
        }
        return null;
    }

    public void performDropPostProcess(Statement stmt, String dropSql) throws SQLException {
        if (dropSql == null) {
            return;
        }
        stmt.executeUpdate(dropSql);
    }
}

