/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.QueryMetadata;
import com.querydsl.core.testutil.Serialization;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.JPATest;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.testutil.JPATestRunner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.EntityManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JPATestRunner.class)
public class SerializationBase
implements JPATest {
    private QCat cat = QCat.cat;
    private EntityManager entityManager;

    @Test
    public void test() throws IOException, ClassNotFoundException {
        JPAQuery<?> query = this.query();
        ((JPAQuery)((JPAQuery)query.from((EntityPath)this.cat)).where((Predicate)this.cat.name.eq((Object)"Kate"))).select((Expression)this.cat).fetch();
        QueryMetadata metadata = query.getMetadata();
        Assert.assertFalse((boolean)metadata.getJoins().isEmpty());
        Assert.assertTrue((metadata.getWhere() != null ? 1 : 0) != 0);
        Assert.assertTrue((metadata.getProjection() != null ? 1 : 0) != 0);
        QueryMetadata metadata2 = (QueryMetadata)Serialization.serialize((Object)metadata);
        Assert.assertEquals((Object)metadata.getJoins(), (Object)metadata2.getJoins());
        Assert.assertEquals((Object)metadata.getWhere(), (Object)metadata2.getWhere());
        Assert.assertEquals((Object)metadata.getProjection(), (Object)metadata2.getProjection());
        JPAQuery query2 = new JPAQuery(this.entityManager, metadata2);
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\nwhere cat.name = ?1", (Object)query2.toString());
        query2.select((Expression)this.cat).fetch();
    }

    @Test
    public void any_serialized() throws Exception {
        BooleanExpression where = ((QCat)this.cat.kittens.any()).name.eq((Object)"Ruth234");
        Predicate where2 = (Predicate)Serialization.serialize((Object)where);
        Assert.assertEquals((long)0L, (long)((JPAQuery)((JPAQuery)this.query().from((EntityPath)this.cat)).where((Predicate)where)).fetchCount());
        Assert.assertEquals((long)0L, (long)((JPAQuery)((JPAQuery)this.query().from((EntityPath)this.cat)).where(where2)).fetchCount());
    }

    @Test
    public void any_serialized2() throws Exception {
        BooleanExpression where = ((QCat)this.cat.kittens.any()).name.eq((Object)"Ruth234");
        File file = new File("target", "predicate.ser");
        if (!file.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream out = new ObjectOutputStream(fileOutputStream);
            out.writeObject(where);
            out.close();
            Assert.assertEquals((long)0L, (long)((JPAQuery)((JPAQuery)this.query().from((EntityPath)this.cat)).where((Predicate)where)).fetchCount());
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream in = new ObjectInputStream(fileInputStream);
            Predicate where2 = (Predicate)in.readObject();
            in.close();
            Assert.assertEquals((long)0L, (long)((JPAQuery)((JPAQuery)this.query().from((EntityPath)this.cat)).where(where2)).fetchCount());
        }
    }

    private JPAQuery<?> query() {
        return new JPAQuery(this.entityManager);
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

