/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.Target;
import com.querydsl.core.Tuple;
import com.querydsl.core.testutil.Performance;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.JPATest;
import com.querydsl.jpa.Mode;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.testutil.JPATestRunner;
import javax.persistence.EntityManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=JPATestRunner.class)
@Ignore
@Category(value={Performance.class})
public class QueryPerformanceTest
implements JPATest {
    private static final int iterations = 1000;
    private EntityManager entityManager;

    @BeforeClass
    public static void setUpClass() {
        Mode.mode.set("h2perf");
        Mode.target.set(Target.H2);
    }

    @AfterClass
    public static void tearDownClass() {
        Mode.mode.remove();
        Mode.target.remove();
    }

    private JPAQuery<?> query() {
        return new JPAQuery(this.entityManager);
    }

    @Before
    public void setUp() {
        if (((JPAQuery)this.query().from((EntityPath)QCat.cat)).fetchCount() == 0L) {
            for (int i = 0; i < 1000; ++i) {
                this.entityManager.persist((Object)new Cat(String.valueOf(i), i + 100));
            }
            this.entityManager.flush();
        }
    }

    @Test
    public void byId_raw() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            Cat cat = (Cat)this.entityManager.createQuery("select cat from Cat cat where id = ?").setParameter(1, (Object)(i + 100)).getSingleResult();
            Assert.assertNotNull((Object)cat);
        }
        System.err.println("by id - raw" + (System.currentTimeMillis() - start));
    }

    @Test
    public void byId_qdsl() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            QCat cat = QCat.cat;
            Cat c = (Cat)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).where((Predicate)cat.id.eq((Object)(i + 100)))).select((Expression)cat).fetchOne();
            Assert.assertNotNull((Object)c);
        }
        System.err.println("by id - dsl" + (System.currentTimeMillis() - start));
    }

    @Test
    public void byId_twoCols_raw() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            Object[] row = (Object[])this.entityManager.createQuery("select cat.id, cat.name from Cat cat where id = ?").setParameter(1, (Object)(i + 100)).getSingleResult();
            Assert.assertNotNull((Object)row);
        }
        System.err.println("by id - 2 cols - raw" + (System.currentTimeMillis() - start));
    }

    @Test
    public void byId_twoCols_qdsl() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            QCat cat = QCat.cat;
            Tuple row = (Tuple)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).where((Predicate)cat.id.eq((Object)(i + 100)))).select(new Expression[]{cat.id, cat.name}).fetchOne();
            Assert.assertNotNull((Object)row);
        }
        System.err.println("by id - 2 cols - dsl" + (System.currentTimeMillis() - start));
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

