/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.OrderHelper;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class OrderHelperTest {
    @Test
    public void order() {
        PathBuilder entity = new PathBuilder(Object.class, "project");
        ArrayList order = Lists.newArrayList();
        order.add("customer.name");
        order.add("department.superior.name");
        order.add("customer.company.name");
        order.add("previousProject.customer.company.name");
        order.add("department.name");
        JPQLQuery query = JPAExpressions.select((Expression)entity);
        query.from(new EntityPath[]{entity});
        OrderHelper.orderBy(query, entity, order);
        Assert.assertEquals((Object)"select project\nfrom Object project\n  left join project.customer as customer\n  left join project.department as department\n  left join department.superior as department_superior\n  left join customer.company as customer_company\n  left join project.previousProject as previousProject\n  left join previousProject.customer as previousProject_customer\n  left join previousProject_customer.company as previousProject_customer_company\norder by customer.name asc, department_superior.name asc, customer_company.name asc, previousProject_customer_company.name asc, department.name asc", (Object)query.toString());
    }
}

