/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Maps;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPQLQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class OrderHelper {
    private static final Pattern DOT = Pattern.compile("\\.");

    private OrderHelper() {
    }

    public static PathBuilder<?> join(JPQLQuery<?> query, PathBuilder<?> builder, Map<String, PathBuilder<?>> joins, String path) {
        PathBuilder rv = joins.get(path);
        if (rv == null) {
            if (path.contains(".")) {
                Object[] tokens = DOT.split(path);
                Object[] parent = new String[tokens.length - 1];
                System.arraycopy(tokens, 0, parent, 0, tokens.length - 1);
                String parentKey = StringUtils.join((Object[])parent, (String)".");
                builder = OrderHelper.join(query, builder, joins, parentKey);
                rv = new PathBuilder(Object.class, StringUtils.join((Object[])tokens, (String)"_"));
                query.leftJoin((EntityPath)builder.get((String)tokens[tokens.length - 1]), (Path)rv);
            } else {
                rv = new PathBuilder(Object.class, path);
                query.leftJoin((EntityPath)builder.get(path), (Path)rv);
            }
            joins.put(path, rv);
        }
        return rv;
    }

    public static void orderBy(JPQLQuery<?> query, EntityPath<?> entity, List<String> order) {
        PathBuilder builder = new PathBuilder(entity.getType(), entity.getMetadata());
        HashMap joins = Maps.newHashMap();
        for (String entry : order) {
            String[] tokens = DOT.split(entry);
            if (tokens.length > 1) {
                Object[] parent = new String[tokens.length - 1];
                System.arraycopy(tokens, 0, parent, 0, tokens.length - 1);
                PathBuilder<?> parentAlias = OrderHelper.join(query, builder, joins, StringUtils.join((Object[])parent, (String)"."));
                query.orderBy(new OrderSpecifier[]{parentAlias.getString(tokens[tokens.length - 1]).asc()});
                continue;
            }
            query.orderBy(new OrderSpecifier[]{builder.getString(tokens[0]).asc()});
        }
    }
}

