/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.AbstractQueryTest;
import com.querydsl.jpa.Constants;
import com.querydsl.jpa.domain.QCat;
import org.junit.Test;

public class MathTest
extends AbstractQueryTest {
    @Test
    public void test() {
        NumberPath<Double> path = QCat.cat.bodyWeight;
        MathTest.assertToString("(cat.bodyWeight - sum(cat.bodyWeight)) * cat.bodyWeight", path.subtract((Expression)path.sum()).multiply(path));
    }

    @Test
    public void add() {
        MathTest.assertToString("cat.bodyWeight + ?1", Constants.cat.bodyWeight.add((Number)10));
    }

    @Test
    public void subtract() {
        MathTest.assertToString("cat.bodyWeight - ?1", Constants.cat.bodyWeight.subtract((Number)10));
    }

    @Test
    public void multiply() {
        MathTest.assertToString("cat.bodyWeight * ?1", Constants.cat.bodyWeight.multiply((Number)10));
    }

    @Test
    public void divide() {
        MathTest.assertToString("cat.bodyWeight / ?1", Constants.cat.bodyWeight.divide((Number)10));
    }

    @Test
    public void add_and_compare() {
        MathTest.assertToString("cat.bodyWeight + ?1 < ?1", Constants.cat.bodyWeight.add((Number)10.0).lt((Number)10.0));
    }

    @Test
    public void subtract_and_compare() {
        MathTest.assertToString("cat.bodyWeight - ?1 < ?1", Constants.cat.bodyWeight.subtract((Number)10.0).lt((Number)10.0));
    }

    @Test
    public void multiply_and_compare() {
        MathTest.assertToString("cat.bodyWeight * ?1 < ?1", Constants.cat.bodyWeight.multiply((Number)10.0).lt((Number)10.0));
    }

    @Test
    public void divide_and_compare() {
        MathTest.assertToString("cat.bodyWeight / ?1 < ?2", Constants.cat.bodyWeight.divide((Number)10.0).lt((Number)20.0));
    }

    @Test
    public void add_and_multiply() {
        MathTest.assertToString("(cat.bodyWeight + ?1) * ?2", Constants.cat.bodyWeight.add((Number)10).multiply((Number)20));
    }

    @Test
    public void subtract_and_multiply() {
        MathTest.assertToString("(cat.bodyWeight - ?1) * ?2", Constants.cat.bodyWeight.subtract((Number)10).multiply((Number)20));
    }

    @Test
    public void multiply_and_add() {
        MathTest.assertToString("cat.bodyWeight * ?1 + ?2", Constants.cat.bodyWeight.multiply((Number)10).add((Number)20));
    }

    @Test
    public void multiply_and_subtract() {
        MathTest.assertToString("cat.bodyWeight * ?1 - ?2", Constants.cat.bodyWeight.multiply((Number)10).subtract((Number)20));
    }

    @Test
    public void arithmetic_and_arithmetic2() {
        QCat c1 = new QCat("c1");
        QCat c2 = new QCat("c2");
        QCat c3 = new QCat("c3");
        MathTest.assertToString("c1.id + c2.id * c3.id", c1.id.add((Expression)c2.id.multiply(c3.id)));
        MathTest.assertToString("c1.id * (c2.id + c3.id)", c1.id.multiply((Expression)c2.id.add(c3.id)));
        MathTest.assertToString("(c1.id + c2.id) * c3.id", c1.id.add(c2.id).multiply(c3.id));
    }

    @Test
    public void mathematicalOperations() {
        Constants.cat.bodyWeight.add(Constants.kitten.bodyWeight);
        Constants.cat.bodyWeight.subtract(Constants.kitten.bodyWeight);
        Constants.cat.bodyWeight.multiply(Constants.kitten.bodyWeight);
        Constants.cat.bodyWeight.divide(Constants.kitten.bodyWeight);
    }
}

