/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.TemplatesTestUtils;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPQLOps;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.OpenJPATemplates;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JPQLTemplatesTest {
    @Test
    public void escape() {
        List<Templates> templates = Arrays.asList(new JPQLTemplates(), new HQLTemplates(), new EclipseLinkTemplates(), new OpenJPATemplates());
        for (Templates t : templates) {
            Assert.assertEquals((Object)"{0} like {1} escape '!'", (Object)t.getTemplate((Operator)Ops.LIKE).toString());
        }
    }

    @Test
    public void custom_escape() {
        List<Templates> templates = Arrays.asList(new JPQLTemplates('X'), new HQLTemplates('X'), new EclipseLinkTemplates('X'), new OpenJPATemplates('X'));
        for (Templates t : templates) {
            Assert.assertEquals((Object)"{0} like {1} escape 'X'", (Object)t.getTemplate((Operator)Ops.LIKE).toString());
        }
    }

    @Test
    public void precedence() {
        int p1 = this.getPrecedence(new Operator[]{Ops.NEGATE});
        int p2 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV});
        int p3 = this.getPrecedence(new Operator[]{Ops.ADD, Ops.SUB});
        int p4 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.GT, Ops.GOE, Ops.LT, Ops.LOE, Ops.NE, Ops.BETWEEN, Ops.LIKE, Ops.LIKE_ESCAPE, Ops.IN, Ops.IS_NULL, Ops.IS_NOT_NULL, JPQLOps.MEMBER_OF, JPQLOps.NOT_MEMBER_OF});
        int p5 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p6 = this.getPrecedence(new Operator[]{Ops.AND});
        int p7 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
    }

    protected int getPrecedence(Operator ... ops) {
        int precedence = JPQLTemplates.DEFAULT.getPrecedence(ops[0]);
        for (int i = 1; i < ops.length; ++i) {
            Assert.assertEquals((String)ops[i].name(), (long)precedence, (long)JPQLTemplates.DEFAULT.getPrecedence(ops[i]));
        }
        return precedence;
    }

    @Test
    public void generic_precedence() {
        for (JPQLTemplates templates : ImmutableList.of((Object)JPQLTemplates.DEFAULT, (Object)HQLTemplates.DEFAULT, (Object)EclipseLinkTemplates.DEFAULT)) {
            TemplatesTestUtils.testPrecedence((Templates)templates);
        }
    }
}

