/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.jpa.AbstractSQLTest;
import com.querydsl.jpa.JPAProviderRule;
import com.querydsl.jpa.JPATest;
import com.querydsl.jpa.Mode;
import com.querydsl.jpa.TargetRule;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.Color;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.sql.SAnimal;
import com.querydsl.jpa.sql.JPASQLQuery;
import com.querydsl.jpa.testutil.JPATestRunner;
import com.querydsl.sql.SQLTemplates;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=JPATestRunner.class)
public class JPASQLBase
extends AbstractSQLTest
implements JPATest {
    @Rule
    @ClassRule
    public static TestRule targetRule = new TargetRule();
    @Rule
    @ClassRule
    public static TestRule hibernateOnly = new JPAProviderRule();
    private final SQLTemplates templates = Mode.getSQLTemplates();
    private EntityManager entityManager;

    protected JPASQLQuery<?> query() {
        return new JPASQLQuery(this.entityManager, this.templates);
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Before
    public void setUp() {
        if (((JPASQLQuery)this.query().from((Expression)cat)).fetchCount() == 0L) {
            this.entityManager.persist((Object)new Cat("Beck", 1, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Kate", 2, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Kitty", 3, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Bobby", 4, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Harold", 5, Color.BLACK));
            this.entityManager.persist((Object)new Cat("Tim", 6, Color.BLACK));
            this.entityManager.flush();
        }
    }

    @Test
    public void entityQueries_createQuery() {
        SAnimal cat = new SAnimal("cat");
        QCat catEntity = QCat.cat;
        Query query = ((JPASQLQuery)this.query().from((Expression)cat)).select((Expression)catEntity).createQuery();
        Assert.assertEquals((long)6L, (long)query.getResultList().size());
    }

    @Test
    @ExcludeIn(value={Target.MYSQL})
    public void entityQueries_createQuery2() {
        SAnimal cat = new SAnimal("CAT");
        QCat catEntity = QCat.cat;
        Query query = ((JPASQLQuery)this.query().from((Expression)cat)).select((Expression)catEntity).createQuery();
        Assert.assertEquals((long)6L, (long)query.getResultList().size());
    }
}

