/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Maps;
import com.querydsl.core.dml.UpdateClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.JPQLQueryFactory;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.domain.QAnimal;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Date;
import java.util.Map;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JPAQueryFactoryTest {
    private EntityManagerFactory factoryMock;
    private EntityManager mock;
    private JPAQueryFactory queryFactory;
    private JPQLQueryFactory queryFactory2;
    private JPAQueryFactory queryFactory3;
    private Map<String, Object> properties = Maps.newHashMap();

    @Before
    public void setUp() {
        this.factoryMock = (EntityManagerFactory)EasyMock.createMock(EntityManagerFactory.class);
        this.mock = (EntityManager)EasyMock.createMock(EntityManager.class);
        Provider<EntityManager> provider = new Provider<EntityManager>(){

            public EntityManager get() {
                return JPAQueryFactoryTest.this.mock;
            }
        };
        this.queryFactory = new JPAQueryFactory(JPQLTemplates.DEFAULT, (Provider)provider);
        this.queryFactory2 = this.queryFactory;
        this.queryFactory3 = new JPAQueryFactory((Provider)provider);
    }

    @Test
    public void query() {
        Assert.assertNotNull((Object)this.queryFactory.query());
    }

    @Test
    public void query2() {
        ((JPQLQuery)this.queryFactory2.query()).from(new EntityPath[]{QAnimal.animal});
    }

    @Test
    public void query3() {
        EasyMock.expect((Object)this.mock.getEntityManagerFactory()).andReturn((Object)this.factoryMock);
        EasyMock.expect((Object)this.factoryMock.getProperties()).andReturn(this.properties);
        EasyMock.expect((Object)this.mock.getDelegate()).andReturn((Object)this.mock).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mock, this.factoryMock});
        this.queryFactory3.query().from((EntityPath)QAnimal.animal);
        EasyMock.verify((Object[])new Object[]{this.mock, this.factoryMock});
    }

    @Test
    public void from() {
        Assert.assertNotNull((Object)this.queryFactory.from((EntityPath)QAnimal.animal));
    }

    @Test
    public void delete() {
        Assert.assertNotNull((Object)this.queryFactory.delete((EntityPath)QAnimal.animal));
    }

    @Test
    public void delete2() {
        this.queryFactory2.delete((EntityPath)QAnimal.animal).where(new Predicate[]{QAnimal.animal.bodyWeight.gt((Number)0)});
    }

    @Test
    public void delete3() {
        EasyMock.expect((Object)this.mock.getEntityManagerFactory()).andReturn((Object)this.factoryMock);
        EasyMock.expect((Object)this.factoryMock.getProperties()).andReturn(this.properties);
        EasyMock.expect((Object)this.mock.getDelegate()).andReturn((Object)this.mock).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mock, this.factoryMock});
        Assert.assertNotNull((Object)this.queryFactory3.delete((EntityPath)QAnimal.animal));
        EasyMock.verify((Object[])new Object[]{this.mock, this.factoryMock});
    }

    @Test
    public void update() {
        Assert.assertNotNull((Object)this.queryFactory.update((EntityPath)QAnimal.animal));
    }

    @Test
    public void update2() {
        ((UpdateClause)this.queryFactory2.update((EntityPath)QAnimal.animal).set(QAnimal.animal.birthdate, (Object)new Date())).where(new Predicate[]{QAnimal.animal.birthdate.isNull()});
    }

    @Test
    public void update3() {
        EasyMock.expect((Object)this.mock.getEntityManagerFactory()).andReturn((Object)this.factoryMock);
        EasyMock.expect((Object)this.factoryMock.getProperties()).andReturn(this.properties);
        EasyMock.expect((Object)this.mock.getDelegate()).andReturn((Object)this.mock).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.mock, this.factoryMock});
        Assert.assertNotNull((Object)this.queryFactory3.update((EntityPath)QAnimal.animal));
        EasyMock.verify((Object[])new Object[]{this.mock, this.factoryMock});
    }
}

