/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.ImmutableSet;
import com.querydsl.core.Target;
import com.querydsl.core.testutil.EmptyStatement;
import com.querydsl.jpa.Mode;
import com.querydsl.jpa.NoBatooJPA;
import com.querydsl.jpa.NoEclipseLink;
import com.querydsl.jpa.NoHibernate;
import com.querydsl.jpa.NoOpenJPA;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JPAProviderRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        NoEclipseLink noEclipseLink = (NoEclipseLink)description.getAnnotation(NoEclipseLink.class);
        NoOpenJPA noOpenJPA = (NoOpenJPA)description.getAnnotation(NoOpenJPA.class);
        NoBatooJPA noBatooJPA = (NoBatooJPA)description.getAnnotation(NoBatooJPA.class);
        NoHibernate noHibernate = (NoHibernate)description.getAnnotation(NoHibernate.class);
        String mode = Mode.mode.get();
        if (mode == null) {
            return base;
        }
        if (noEclipseLink != null && this.applies(noEclipseLink.value()) && mode.contains("-eclipselink")) {
            return EmptyStatement.DEFAULT;
        }
        if (noOpenJPA != null && this.applies(noOpenJPA.value()) && mode.contains("-openjpa")) {
            return EmptyStatement.DEFAULT;
        }
        if (noBatooJPA != null && this.applies(noBatooJPA.value()) && mode.contains("-batoo")) {
            return EmptyStatement.DEFAULT;
        }
        if (noHibernate != null && this.applies(noHibernate.value()) && !mode.contains("-")) {
            return EmptyStatement.DEFAULT;
        }
        return base;
    }

    private boolean applies(Target[] targets) {
        return targets.length == 0 || ImmutableSet.copyOf((Object[])targets).contains((Object)Mode.target.get());
    }
}

