/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.support.Context;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPACollectionAnyVisitor;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.QCompany;
import com.querydsl.jpa.domain.QDepartment;
import com.querydsl.jpa.domain.QDomesticCat;
import com.querydsl.jpa.domain.QEmployee;
import org.junit.Assert;
import org.junit.Test;

public class JPACollectionAnyVisitorTest {
    private QCat cat = QCat.cat;

    @Test
    public void path() {
        Assert.assertEquals((Object)"cat_kittens_0", (Object)this.serialize((Expression<?>)this.cat.kittens.any()));
    }

    @Test
    public void longer_path() {
        Assert.assertEquals((Object)"cat_kittens_0.name", (Object)this.serialize((Expression<?>)((QCat)this.cat.kittens.any()).name));
    }

    @Test
    public void nested_any_booleanOperation() {
        QCompany company = QCompany.company;
        BooleanExpression predicate = ((QEmployee)((QDepartment)company.departments.any()).employees.any()).firstName.eq((Object)"Bob");
        Assert.assertEquals((Object)"exists (select 1\nfrom company.departments as company_departments_0\n  inner join company_departments_0.employees as company_departments_0_employees_1\nwhere company_departments_0_employees_1.firstName = ?1)", (Object)this.serialize((Expression<?>)predicate));
    }

    @Test
    public void simple_booleanOperation() {
        BooleanExpression predicate = ((QCat)this.cat.kittens.any()).name.eq((Object)"Ruth123");
        Assert.assertEquals((Object)"exists (select 1\nfrom cat.kittens as cat_kittens_0\nwhere cat_kittens_0.name = ?1)", (Object)this.serialize((Expression<?>)predicate));
    }

    @Test
    public void simple_booleanOperation_longPath() {
        BooleanExpression predicate = ((QCat)((QCat)this.cat.kittens.any()).kittens.any()).name.eq((Object)"Ruth123");
        Assert.assertEquals((Object)"exists (select 1\nfrom cat.kittens as cat_kittens_0\n  inner join cat_kittens_0.kittens as cat_kittens_0_kittens_1\nwhere cat_kittens_0_kittens_1.name = ?1)", (Object)this.serialize((Expression<?>)predicate));
    }

    @Test
    public void simple_booleanOperation_elementCollection() {
        QEmployee employee = QEmployee.employee;
        BooleanExpression predicate = ((EnumPath)employee.jobFunctions.any()).stringValue().eq((Object)"CODER");
        Assert.assertEquals((Object)"exists (select 1\nfrom Employee employee_1463394548\n  inner join employee_1463394548.jobFunctions as employee_jobFunctions_0\nwhere employee_1463394548 = employee and str(employee_jobFunctions_0) = ?1)", (Object)this.serialize((Expression<?>)predicate));
    }

    @Test
    public void simple_stringOperation() {
        BooleanExpression predicate = ((QCat)this.cat.kittens.any()).name.substring(1).eq((Object)"uth123");
        Assert.assertEquals((Object)"exists (select 1\nfrom cat.kittens as cat_kittens_0\nwhere substring(cat_kittens_0.name,2) = ?1)", (Object)this.serialize((Expression<?>)predicate));
    }

    @Test
    public void and_operation() {
        BooleanExpression predicate = ((QCat)this.cat.kittens.any()).name.eq((Object)"Ruth123").and((Predicate)((QCat)this.cat.kittens.any()).bodyWeight.gt((Number)10.0));
        Assert.assertEquals((Object)"exists (select 1\nfrom cat.kittens as cat_kittens_0\nwhere cat_kittens_0.name = ?1) and exists (select 1\nfrom cat.kittens as cat_kittens_1\nwhere cat_kittens_1.bodyWeight > ?2)", (Object)this.serialize((Expression<?>)predicate));
    }

    @Test
    public void template() {
        TemplateExpression templateExpr = ExpressionUtils.template(Boolean.class, (String)"{0} = {1}", (Object[])new Object[]{((QCat)this.cat.kittens.any()).name, ConstantImpl.create((Object)"Ruth123")});
        Assert.assertEquals((Object)"exists (select 1\nfrom cat.kittens as cat_kittens_0\nwhere cat_kittens_0.name = ?1)", (Object)this.serialize((Expression<?>)templateExpr));
    }

    @Test
    public void cast() {
        QDomesticCat anyCat = (QDomesticCat)((QCat)QCat.cat.kittens.any()).as(QDomesticCat.class);
        BooleanExpression predicate = anyCat.name.eq((Object)"X");
        Assert.assertEquals((Object)"exists (select 1\nfrom cat.kittens as cat_kittens_0\nwhere cat_kittens_0.name = ?1)", (Object)this.serialize((Expression<?>)predicate));
    }

    private String serialize(Expression<?> expression) {
        Expression transformed = (Expression)expression.accept((Visitor)new JPACollectionAnyVisitor(), (Object)new Context());
        JPQLSerializer serializer = new JPQLSerializer((JPQLTemplates)HQLTemplates.DEFAULT, null);
        serializer.handle(transformed);
        return serializer.toString();
    }
}

