/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.AbstractJPATest;
import com.querydsl.jpa.CustomFinder;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPAProviderRule;
import com.querydsl.jpa.JPATest;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.NoBatooJPA;
import com.querydsl.jpa.NoEclipseLink;
import com.querydsl.jpa.NoHibernate;
import com.querydsl.jpa.NoOpenJPA;
import com.querydsl.jpa.TargetRule;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.QCatSummary;
import com.querydsl.jpa.domain.QChild;
import com.querydsl.jpa.domain.QGroup;
import com.querydsl.jpa.domain.QParent;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.testutil.JPATestRunner;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=JPATestRunner.class)
public class JPABase
extends AbstractJPATest
implements JPATest {
    private static final QCat cat = QCat.cat;
    @Rule
    @ClassRule
    public static TestRule targetRule = new TargetRule();
    @Rule
    @ClassRule
    public static TestRule jpaProviderRule = new JPAProviderRule();
    private EntityManager entityManager;

    protected JPAQuery<?> query() {
        return new JPAQuery(this.entityManager);
    }

    protected JPADeleteClause delete(EntityPath<?> path) {
        return new JPADeleteClause(this.entityManager, path);
    }

    protected JPAQuery<?> testQuery() {
        return new JPAQuery(this.entityManager, (QueryMetadata)new DefaultQueryMetadata());
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    protected void save(Object entity) {
        this.entityManager.persist(entity);
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @NoHibernate
    public void connection_access() {
        Assert.assertNotNull((Object)((JPAQuery)this.query().from((EntityPath)cat)).select((Expression)cat).createQuery().unwrap(Connection.class));
    }

    @Test
    @Ignore
    public void delete() {
        this.delete((EntityPath<?>)cat).execute();
    }

    @Test
    public void delete2() {
        Assert.assertEquals((long)0L, (long)this.delete((EntityPath<?>)QGroup.group).execute());
    }

    @Test
    @NoBatooJPA
    public void delete_where() {
        this.delete((EntityPath<?>)cat).where(new Predicate[]{JPABase.cat.name.eq((Object)"XXX")}).execute();
    }

    @Test
    @ExcludeIn(value={Target.MYSQL})
    public void delete_where_any() {
        this.delete((EntityPath<?>)cat).where(new Predicate[]{((QCat)JPABase.cat.kittens.any()).name.eq((Object)"XXX")}).execute();
    }

    @Test
    @NoBatooJPA
    @ExcludeIn(value={Target.MYSQL})
    public void delete_where_subQuery_exists() {
        QCat parent = cat;
        QCat child = new QCat("kitten");
        this.delete((EntityPath<?>)child).where(new Predicate[]{child.id.eq((Object)-100), ((JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{parent}).where(new Predicate[]{parent.id.eq((Object)-200), child.in((CollectionExpression)parent.kittens)})).exists()}).execute();
    }

    @Test
    @NoBatooJPA
    public void delete_where_subQuery2() {
        QChild child = QChild.child;
        QParent parent = QParent.parent;
        JPQLQuery subQuery = (JPQLQuery)JPAExpressions.selectFrom((EntityPath)parent).where(new Predicate[]{parent.id.eq((Object)2), child.parent.eq((Expression)parent)});
        this.delete((EntityPath<?>)child).where(new Predicate[]{child.id.eq((Object)1), subQuery.exists()}).execute();
    }

    @Test
    public void finder() {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("name", "Bob123");
        List<Cat> cats = CustomFinder.findCustom(this.entityManager, Cat.class, conditions, "name");
        Assert.assertEquals((long)1L, (long)cats.size());
        Assert.assertEquals((Object)"Bob123", (Object)cats.get(0).getName());
    }

    @Test
    public void flushMode() {
        Assert.assertFalse((boolean)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).setFlushMode(FlushModeType.AUTO)).select((Expression)cat).fetch().isEmpty());
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    public void hint() {
        Query query = ((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).setHint("org.hibernate.cacheable", (Object)true)).select((Expression)cat).createQuery();
        Assert.assertNotNull((Object)query);
        Assert.assertTrue((boolean)query.getHints().containsKey("org.hibernate.cacheable"));
        Assert.assertFalse((boolean)query.getResultList().isEmpty());
    }

    @Test
    public void hint2() {
        Assert.assertFalse((boolean)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).setHint("org.hibernate.cacheable", (Object)true)).select((Expression)cat).fetch().isEmpty());
    }

    @Test
    @Ignore
    @NoHibernate
    @NoOpenJPA
    @NoBatooJPA
    public void hint3() {
        Query query = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).setHint("eclipselink.batch.type", (Object)"IN")).setHint("eclipselink.batch", (Object)"person.workAddress")).setHint("eclipselink.batch", (Object)"person.homeAddress")).select((Expression)cat).createQuery();
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"person.homeAddress", query.getHints().get("eclipselink.batch"));
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void iterate() {
        CloseableIterator cats = ((JPAQuery)this.query().from((EntityPath)cat)).select((Expression)cat).iterate();
        while (cats.hasNext()) {
            Cat cat = (Cat)cats.next();
            Assert.assertNotNull((Object)cat);
        }
        cats.close();
    }

    @Test
    public void limit1_uniqueResult() {
        Assert.assertNotNull((Object)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).limit(1L)).select((Expression)cat).fetchOne());
    }

    @Test
    public void lockMode() {
        Query query = ((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).setLockMode(LockModeType.PESSIMISTIC_READ)).select((Expression)cat).createQuery();
        Assert.assertEquals((Object)query.getLockMode(), (Object)LockModeType.PESSIMISTIC_READ);
        Assert.assertFalse((boolean)query.getResultList().isEmpty());
    }

    @Test
    public void lockMode2() {
        Assert.assertFalse((boolean)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).setLockMode(LockModeType.PESSIMISTIC_READ)).select((Expression)cat).fetch().isEmpty());
    }

    @Test
    public void queryExposure() {
        List results = ((JPAQuery)this.query().from((EntityPath)cat)).select((Expression)cat).createQuery().getResultList();
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((boolean)results.isEmpty());
    }

    @Test
    @Ignore
    public void subquery_uniqueResult() {
        QCat cat2 = new QCat("cat2");
        BooleanExpression exists = ((JPQLQuery)JPAExpressions.selectOne().from(new EntityPath[]{cat2}).where(new Predicate[]{cat2.eyecolor.isNotNull()})).exists();
        Assert.assertNotNull((Object)((JPAQuery)((JPAQuery)this.query().from((EntityPath)cat)).where((Predicate)JPABase.cat.breed.eq((Object)0).not())).select((Expression)new QCatSummary((Expression<Long>)JPABase.cat.breed.count(), (Expression<Boolean>)exists)).fetchOne());
    }

    @Test
    @NoEclipseLink
    @NoBatooJPA
    public void createQuery() {
        List rows = ((JPAQuery)this.query().from((EntityPath)cat)).select(new Expression[]{JPABase.cat.id, JPABase.cat.name}).createQuery().getResultList();
        for (Object[] row : rows) {
            Assert.assertEquals((long)2L, (long)row.length);
        }
    }

    @Test
    @NoEclipseLink
    @NoBatooJPA
    public void createQuery2() {
        List rows = ((JPAQuery)this.query().from((EntityPath)cat)).select(new Expression[]{JPABase.cat.id, JPABase.cat.name}).createQuery().getResultList();
        for (Object[] row : rows) {
            Assert.assertEquals((long)2L, (long)row.length);
        }
    }

    @Test
    public void createQuery3() {
        List rows = ((JPAQuery)this.query().from((EntityPath)cat)).select((Expression)JPABase.cat.name).createQuery().getResultList();
        for (String row : rows) {
            Assert.assertNotNull((Object)row);
        }
    }
}

