/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.jpa.AbstractJPATest;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.HibernateTest;
import com.querydsl.jpa.JPAProviderRule;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.ScrollableResultsIterator;
import com.querydsl.jpa.TargetRule;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.QGroup;
import com.querydsl.jpa.hibernate.DefaultSessionHolder;
import com.querydsl.jpa.hibernate.HibernateDeleteClause;
import com.querydsl.jpa.hibernate.HibernateQuery;
import com.querydsl.jpa.hibernate.SessionHolder;
import com.querydsl.jpa.testutil.HibernateTestRunner;
import java.io.IOException;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=HibernateTestRunner.class)
public class HibernateBase
extends AbstractJPATest
implements HibernateTest {
    private static final QCat cat = QCat.cat;
    @Rule
    @ClassRule
    public static TestRule jpaProviderRule = new JPAProviderRule();
    @Rule
    @ClassRule
    public static TestRule targetRule = new TargetRule();
    private Session session;

    protected HibernateQuery<?> query() {
        return new HibernateQuery(this.session, this.getTemplates());
    }

    protected HibernateDeleteClause delete(EntityPath<?> path) {
        return new HibernateDeleteClause(this.session, path);
    }

    protected HibernateQuery<?> testQuery() {
        return new HibernateQuery((SessionHolder)new DefaultSessionHolder(this.session), this.getTemplates(), (QueryMetadata)new DefaultQueryMetadata());
    }

    protected JPQLTemplates getTemplates() {
        return HQLTemplates.DEFAULT;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    protected void save(Object entity) {
        this.session.save(entity);
    }

    @Test
    public void query_exposure() {
        List results = ((HibernateQuery)this.query().from((EntityPath)cat)).select((Expression)cat).createQuery().list();
        Assert.assertNotNull((Object)results);
        Assert.assertFalse((boolean)results.isEmpty());
    }

    @Test
    public void delete() {
        Assert.assertEquals((long)0L, (long)this.delete((EntityPath<?>)QGroup.group).execute());
    }

    @Test
    public void with_comment() {
        ((HibernateQuery)((HibernateQuery)this.query().from((EntityPath)cat)).setComment("my comment")).select((Expression)cat).fetch();
    }

    @Test
    public void lockMode() {
        ((HibernateQuery)((HibernateQuery)this.query().from((EntityPath)cat)).setLockMode((Path)cat, LockMode.PESSIMISTIC_WRITE)).select((Expression)cat).fetch();
    }

    @Test
    public void flushMode() {
        ((HibernateQuery)((HibernateQuery)this.query().from((EntityPath)cat)).setFlushMode(FlushMode.AUTO)).select((Expression)cat).fetch();
    }

    @Test
    public void scroll() throws IOException {
        ScrollableResultsIterator cats = new ScrollableResultsIterator(((HibernateQuery)this.query().from((EntityPath)cat)).select((Expression)cat).createQuery().scroll());
        Assert.assertTrue((boolean)cats.hasNext());
        while (cats.hasNext()) {
            Assert.assertNotNull((Object)cats.next());
        }
        cats.close();
    }

    @Test
    public void scrollTuple() throws IOException {
        ScrollableResultsIterator rows = new ScrollableResultsIterator(((HibernateQuery)this.query().from((EntityPath)cat)).select(new Expression[]{HibernateBase.cat.name, HibernateBase.cat.birthdate}).createQuery().scroll());
        Assert.assertTrue((boolean)rows.hasNext());
        while (rows.hasNext()) {
            Tuple row = (Tuple)rows.next();
            Assert.assertEquals((long)2L, (long)row.size());
        }
        rows.close();
    }

    @Test
    public void createQuery() {
        List rows = ((HibernateQuery)this.query().from((EntityPath)cat)).select(new Expression[]{HibernateBase.cat.id, HibernateBase.cat.name}).createQuery().list();
        for (Tuple row : rows) {
            Assert.assertEquals((long)2L, (long)row.size());
        }
    }

    @Test
    public void createQuery2() {
        List rows = ((HibernateQuery)this.query().from((EntityPath)cat)).select(new Expression[]{HibernateBase.cat.id, HibernateBase.cat.name}).createQuery().list();
        for (Tuple row : rows) {
            Assert.assertEquals((long)2L, (long)row.size());
        }
    }

    @Test
    public void createQuery3() {
        List rows = ((HibernateQuery)this.query().from((EntityPath)cat)).select((Expression)HibernateBase.cat.name).createQuery().list();
        for (String row : rows) {
            Assert.assertTrue((boolean)(row instanceof String));
        }
    }
}

