/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.AbstractQueryTest;
import com.querydsl.jpa.Constants;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import org.junit.Assert;
import org.junit.Test;

public class BooleanOperationsTest
extends AbstractQueryTest {
    @Test
    public void booleanOperations_or() {
        BooleanOperationsTest.assertToString("cust is null or cat is null", Constants.cust.isNull().or((Predicate)Constants.cat.isNull()));
    }

    @Test
    public void booleanOperations_and() {
        BooleanOperationsTest.assertToString("cust is null and cat is null", Constants.cust.isNull().and((Predicate)Constants.cat.isNull()));
    }

    @Test
    public void booleanOperations_not() {
        BooleanOperationsTest.assertToString("not cust is null", Constants.cust.isNull().not());
    }

    @Test
    public void booleanOperations2_and() {
        Constants.cat.name.eq((Expression)Constants.cust.name.firstName).and((Predicate)Constants.cat.bodyWeight.eq(Constants.kitten.bodyWeight));
    }

    @Test
    public void booleanOperations2_or() {
        Constants.cat.name.eq((Expression)Constants.cust.name.firstName).or((Predicate)Constants.cat.bodyWeight.eq(Constants.kitten.bodyWeight));
    }

    @Test
    public void logicalOperations_or() {
        BooleanOperationsTest.assertToString("cat = kitten or kitten = cat", Constants.cat.eq((Expression)Constants.kitten).or((Predicate)Constants.kitten.eq((Expression)Constants.cat)));
    }

    @Test
    public void logicalOperations_and() {
        BooleanOperationsTest.assertToString("cat = kitten and kitten = cat", Constants.cat.eq((Expression)Constants.kitten).and((Predicate)Constants.kitten.eq((Expression)Constants.cat)));
    }

    @Test
    public void logicalOperations_and2() {
        BooleanOperationsTest.assertToString("cat is null and (kitten is null or kitten.bodyWeight > ?1)", Constants.cat.isNull().and((Predicate)Constants.kitten.isNull().or((Predicate)Constants.kitten.bodyWeight.gt((Number)10))));
    }

    @Test
    public void booleanBuilder1() {
        BooleanBuilder bb1 = new BooleanBuilder();
        bb1.and((Predicate)Constants.cat.eq((Expression)Constants.cat));
        BooleanBuilder bb2 = new BooleanBuilder();
        bb2.or((Predicate)Constants.cat.eq((Expression)Constants.cat));
        bb2.or((Predicate)Constants.cat.eq((Expression)Constants.cat));
        BooleanOperationsTest.assertToString("cat = cat and (cat = cat or cat = cat)", bb1.and((Predicate)bb2));
    }

    @Test
    public void booleanBuilder2() {
        BooleanBuilder bb1 = new BooleanBuilder();
        bb1.and((Predicate)Constants.cat.eq((Expression)Constants.cat));
        BooleanBuilder bb2 = new BooleanBuilder();
        bb2.or((Predicate)Constants.cat.eq((Expression)Constants.cat));
        bb2.or((Predicate)Constants.cat.eq((Expression)Constants.cat));
        BooleanOperationsTest.assertToString("cat = cat and (cat = cat or cat = cat)", bb1.and(bb2.getValue()));
    }

    @Test
    public void booleanBuilder_with_null_in_where() {
        Assert.assertEquals((Object)"select cat\nfrom Cat cat", (Object)((JPQLQuery)JPAExpressions.selectFrom((EntityPath)Constants.cat).where(new Predicate[]{new BooleanBuilder()})).toString());
    }

    @Test
    public void booleanBuilder_with_null_in_having() {
        Assert.assertEquals((Object)"select cat\nfrom Cat cat\ngroup by cat.name", (Object)((JPQLQuery)((JPQLQuery)JPAExpressions.selectFrom((EntityPath)Constants.cat).groupBy(new Expression[]{Constants.cat.name})).having(new Predicate[]{new BooleanBuilder()})).toString());
    }
}

