/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.QueryResults;
import com.querydsl.core.Target;
import com.querydsl.core.Tuple;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.jpa.AbstractSQLQuery;
import com.querydsl.jpa.NoBatooJPA;
import com.querydsl.jpa.NoEclipseLink;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.Color;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.QCompany;
import com.querydsl.jpa.domain.sql.SAnimal;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractSQLTest {
    protected static final SAnimal cat = new SAnimal("cat");

    protected abstract AbstractSQLQuery<?, ?> query();

    @Test
    public void count() {
        Assert.assertEquals((long)6L, (long)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).fetchCount());
    }

    @Test
    public void count_via_unique() {
        Assert.assertEquals((Object)6L, (Object)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).select((Expression)AbstractSQLTest.cat.id.count()).fetchFirst());
    }

    @Test
    public void countDistinct() {
        Assert.assertEquals((long)6L, (long)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).distinct()).fetchCount());
    }

    @Test
    public void enum_binding() {
        List cats = ((AbstractSQLQuery)this.query().from((Expression)cat)).select((Expression)Projections.bean(Cat.class, (Expression[])new Expression[]{QCat.cat.color})).fetch();
        Assert.assertFalse((boolean)cats.isEmpty());
        for (Cat cat : cats) {
            Assert.assertEquals((Object)((Object)Color.BLACK), (Object)((Object)cat.getColor()));
        }
    }

    @Test
    @Ignore
    public void entityProjections() {
        List cats = ((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.name.asc())).select((Expression)Projections.constructor(Cat.class, (Expression[])new Expression[]{AbstractSQLTest.cat.name, AbstractSQLTest.cat.id})).fetch();
        Assert.assertEquals((long)6L, (long)cats.size());
        for (Cat c : cats) {
            Assert.assertNotNull((Object)c.getName());
            Assert.assertTrue((c.getId() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void entityQueries() {
        QCat catEntity = QCat.cat;
        List cats = ((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.name.asc())).select((Expression)catEntity).fetch();
        Assert.assertEquals((long)6L, (long)cats.size());
        for (Cat c : cats) {
            Assert.assertNotNull((Object)c.getName());
        }
    }

    @Test
    public void entityQueries2() {
        SAnimal mate = new SAnimal("mate");
        QCat catEntity = QCat.cat;
        List cats = ((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).innerJoin((EntityPath)mate)).on((Predicate)AbstractSQLTest.cat.mateId.eq(mate.id))).where(new Predicate[]{AbstractSQLTest.cat.dtype.eq((Object)"C"), mate.dtype.eq((Object)"C")})).select((Expression)catEntity).fetch();
        Assert.assertTrue((boolean)cats.isEmpty());
    }

    @Test
    public void entityQueries3() {
        QCat catEntity = new QCat("animal_");
        Assert.assertEquals((long)0L, (long)((Integer)((AbstractSQLQuery)this.query().from((Expression)catEntity)).select((Expression)catEntity.toes.max()).fetchFirst()).intValue());
    }

    @Test
    @NoBatooJPA
    @NoEclipseLink
    public void entityQueries4() {
        QCat catEntity = QCat.cat;
        List cats = ((AbstractSQLQuery)this.query().from((Expression)cat)).select(new Expression[]{catEntity, AbstractSQLTest.cat.name, AbstractSQLTest.cat.id}).fetch();
        Assert.assertEquals((long)6L, (long)cats.size());
        for (Tuple tuple : cats) {
            Assert.assertTrue((boolean)(tuple.get((Expression)catEntity) instanceof Cat));
            Assert.assertTrue((boolean)(tuple.get((Expression)AbstractSQLTest.cat.name) instanceof String));
            Assert.assertTrue((boolean)(tuple.get(AbstractSQLTest.cat.id) instanceof Integer));
        }
    }

    @Test
    @NoBatooJPA
    @NoEclipseLink
    public void entityQueries5() {
        QCat catEntity = QCat.cat;
        SAnimal otherCat = new SAnimal("otherCat");
        QCat otherCatEntity = new QCat("otherCat");
        List cats = ((AbstractSQLQuery)this.query().from(new Expression[]{cat, otherCat})).select(new Expression[]{catEntity, otherCatEntity}).fetch();
        Assert.assertEquals((long)36L, (long)cats.size());
        for (Tuple tuple : cats) {
            Assert.assertTrue((boolean)(tuple.get((Expression)catEntity) instanceof Cat));
            Assert.assertTrue((boolean)(tuple.get((Expression)otherCatEntity) instanceof Cat));
        }
    }

    @Test
    @NoBatooJPA
    @NoEclipseLink
    public void entityQueries6() {
        QCat catEntity = QCat.cat;
        List results = ((AbstractSQLQuery)this.query().from((Expression)cat)).select((Expression)Projections.constructor(CatDTO.class, (Expression[])new Expression[]{catEntity})).fetch();
        Assert.assertEquals((long)6L, (long)results.size());
        for (CatDTO cat : results) {
            Assert.assertTrue((boolean)(cat.cat instanceof Cat));
        }
    }

    @Test
    public void entityQueries7() {
        QCompany company = QCompany.company;
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((AbstractSQLQuery)this.query().from((Expression)company)).select((Expression)company.officialName).fetch());
    }

    @Test
    public void in() {
        Assert.assertEquals((long)6L, (long)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.in((Object[])new String[]{"C", "CX"}))).fetchCount());
    }

    @Test
    public void limit_offset() {
        Assert.assertEquals((long)2L, (long)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).limit(2L)).offset(2L)).select(new Expression[]{AbstractSQLTest.cat.id, AbstractSQLTest.cat.name}).fetch().size());
    }

    @Test
    public void list() {
        Assert.assertEquals((long)6L, (long)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).select(AbstractSQLTest.cat.id).fetch().size());
    }

    @Test
    public void list_limit_and_offset() {
        Assert.assertEquals((long)3L, (long)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).offset(3L)).limit(3L)).select(AbstractSQLTest.cat.id).fetch().size());
    }

    @Test
    public void list_limit_and_offset2() {
        List tuples = ((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).offset(3L)).limit(3L)).select(new Expression[]{AbstractSQLTest.cat.id, AbstractSQLTest.cat.name}).fetch();
        Assert.assertEquals((long)3L, (long)tuples.size());
        Assert.assertEquals((long)2L, (long)((Tuple)tuples.get(0)).size());
    }

    @Test
    public void list_limit_and_offset3() {
        List tuples = ((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).offset(3L)).limit(3L)).select((Expression)Projections.tuple((Expression[])new Expression[]{AbstractSQLTest.cat.id, AbstractSQLTest.cat.name})).fetch();
        Assert.assertEquals((long)3L, (long)tuples.size());
        Assert.assertEquals((long)2L, (long)((Tuple)tuples.get(0)).size());
    }

    @Test
    public void list_multiple() {
        this.print(((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).select(new Expression[]{AbstractSQLTest.cat.id, AbstractSQLTest.cat.name, AbstractSQLTest.cat.bodyWeight}).fetch());
    }

    @Test
    public void list_non_path() {
        Assert.assertEquals((long)6L, (long)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).select(new Expression[]{AbstractSQLTest.cat.birthdate.year(), AbstractSQLTest.cat.birthdate.month(), AbstractSQLTest.cat.birthdate.dayOfMonth()}).fetch().size());
    }

    @Test
    public void list_results() {
        QueryResults results = ((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).limit(3L)).orderBy(AbstractSQLTest.cat.name.asc())).select((Expression)AbstractSQLTest.cat.name).fetchResults();
        Assert.assertEquals(Arrays.asList("Beck", "Bobby", "Harold"), (Object)results.getResults());
        Assert.assertEquals((long)6L, (long)results.getTotal());
    }

    @Test
    @ExcludeIn(value={Target.H2})
    public void list_wildcard() {
        Assert.assertEquals((long)6L, (long)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).select(Wildcard.all).fetch().size());
    }

    @Test
    public void list_with_count() {
        this.print(((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.dtype.eq((Object)"C"))).groupBy((Expression)AbstractSQLTest.cat.name)).select(new Expression[]{AbstractSQLTest.cat.name, AbstractSQLTest.cat.id.count()}).fetch());
    }

    @Test
    public void list_with_limit() {
        Assert.assertEquals((long)3L, (long)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).limit(3L)).select(AbstractSQLTest.cat.id).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.H2, Target.MYSQL})
    public void list_with_offset() {
        Assert.assertEquals((long)3L, (long)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).offset(3L)).select(AbstractSQLTest.cat.id).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.HSQLDB})
    public void no_from() {
        Assert.assertNotNull((Object)this.query().select((Expression)DateExpression.currentDate()).fetchFirst());
    }

    @Test
    public void null_as_uniqueResult() {
        Assert.assertNull((Object)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.name.eq((Object)UUID.randomUUID().toString()))).select((Expression)AbstractSQLTest.cat.name).fetchOne());
    }

    private void print(Iterable<Tuple> rows) {
        for (Tuple row : rows) {
            System.out.println(row);
        }
    }

    @Test
    public void projections_duplicateColumns() {
        SAnimal cat = new SAnimal("cat");
        Assert.assertEquals((long)1L, (long)((AbstractSQLQuery)this.query().from((Expression)cat)).select((Expression)Projections.list((Expression[])new Expression[]{cat.count(), cat.count()})).fetch().size());
    }

    @Test
    public void single_result() {
        ((AbstractSQLQuery)this.query().from((Expression)cat)).select(AbstractSQLTest.cat.id).fetchFirst();
    }

    @Test
    public void single_result_multiple() {
        Assert.assertEquals((long)1L, (long)((Integer)((Tuple)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).select(new Expression[]{AbstractSQLTest.cat.id}).fetchFirst()).get(AbstractSQLTest.cat.id)).intValue());
    }

    @Test
    public void union() throws SQLException {
        ProjectableSQLQuery sq1 = SQLExpressions.select((Expression)AbstractSQLTest.cat.id.max()).from((Expression)cat);
        ProjectableSQLQuery sq2 = SQLExpressions.select((Expression)AbstractSQLTest.cat.id.min()).from((Expression)cat);
        List list = this.query().union(new SubQueryExpression[]{sq1, sq2}).list();
        Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    public void union_all() {
        ProjectableSQLQuery sq1 = SQLExpressions.select((Expression)AbstractSQLTest.cat.id.max()).from((Expression)cat);
        ProjectableSQLQuery sq2 = SQLExpressions.select((Expression)AbstractSQLTest.cat.id.min()).from((Expression)cat);
        List list = this.query().unionAll(new SubQueryExpression[]{sq1, sq2}).list();
        Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.POSTGRESQL})
    @Ignore
    public void union2() {
        List rows = this.query().union(new SubQueryExpression[]{(SubQueryExpression)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.name, AbstractSQLTest.cat.id}).from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.name.eq((Object)"Beck"))).distinct(), (SubQueryExpression)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.name, null}).from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.name.eq((Object)"Kate"))).distinct()}).list();
        Assert.assertEquals((long)2L, (long)rows.size());
        for (Tuple row : rows) {
            System.err.println(row);
        }
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    @Ignore
    public void union3() {
        SAnimal cat2 = new SAnimal("cat2");
        List rows = this.query().union(new SubQueryExpression[]{((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.id, cat2.id}).from((Expression)cat)).innerJoin((EntityPath)cat2)).on((Predicate)cat2.id.eq(AbstractSQLTest.cat.id)), SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.id, null}).from((Expression)cat)}).list();
        Assert.assertEquals((long)12L, (long)rows.size());
        int nulls = 0;
        for (Tuple row : rows) {
            System.err.println(Arrays.asList(row));
            if (row.get(1, Object.class) != null) continue;
            ++nulls;
        }
        Assert.assertEquals((long)6L, (long)nulls);
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.POSTGRESQL})
    @Ignore
    public void union4() {
        ((AbstractSQLQuery)this.query().union((Path)cat, new SubQueryExpression[]{(SubQueryExpression)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.name, AbstractSQLTest.cat.id}).from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.name.eq((Object)"Beck"))).distinct(), (SubQueryExpression)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.name, null}).from((Expression)cat)).where((Predicate)AbstractSQLTest.cat.name.eq((Object)"Kate"))).distinct()})).select(new Expression[]{AbstractSQLTest.cat.name, AbstractSQLTest.cat.id}).fetch();
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.ORACLE})
    public void union5() {
        SAnimal cat2 = new SAnimal("cat2");
        List rows = this.query().union(new SubQueryExpression[]{((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.id, cat2.id}).from((Expression)cat)).join((EntityPath)cat2)).on((Predicate)cat2.id.eq((Expression)AbstractSQLTest.cat.id.add((Number)1))), ((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{AbstractSQLTest.cat.id, cat2.id}).from((Expression)cat)).join((EntityPath)cat2)).on((Predicate)cat2.id.eq((Expression)AbstractSQLTest.cat.id.add((Number)1)))}).list();
        Assert.assertEquals((long)5L, (long)rows.size());
        for (Tuple row : rows) {
            int first = (Integer)row.get(AbstractSQLTest.cat.id);
            int second = (Integer)row.get(cat2.id);
            Assert.assertEquals((long)(first + 1), (long)second);
        }
    }

    @Test
    public void unique_result() {
        Assert.assertEquals((long)1L, (long)((Integer)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).limit(1L)).select(AbstractSQLTest.cat.id).fetchOne()).intValue());
    }

    @Test
    public void unique_result_multiple() {
        Assert.assertEquals((long)1L, (long)((Integer)((Tuple)((AbstractSQLQuery)((AbstractSQLQuery)((AbstractSQLQuery)this.query().from((Expression)cat)).orderBy(AbstractSQLTest.cat.id.asc())).limit(1L)).select(new Expression[]{AbstractSQLTest.cat.id}).fetchOne()).get(AbstractSQLTest.cat.id)).intValue());
    }

    @Test
    @ExcludeIn(value={Target.H2})
    public void wildcard() {
        List rows = ((AbstractSQLQuery)this.query().from((Expression)cat)).select((Expression[])cat.all()).fetch();
        Assert.assertEquals((long)6L, (long)rows.size());
        this.print(rows);
    }

    public static class CatDTO {
        Cat cat;

        public CatDTO(Cat cat) {
            this.cat = cat;
        }
    }
}

