/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.Fetchable;
import com.querydsl.core.FilterFactory;
import com.querydsl.core.MatchingFiltersFactory;
import com.querydsl.core.Module;
import com.querydsl.core.ProjectionsFactory;
import com.querydsl.core.QueryExecution;
import com.querydsl.core.QueryResults;
import com.querydsl.core.Target;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.group.MockTuple;
import com.querydsl.core.group.QPair;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.ArrayConstructorExpression;
import com.querydsl.core.types.Concatenation;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.ListExpression;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.Mode;
import com.querydsl.jpa.NoBatooJPA;
import com.querydsl.jpa.NoEclipseLink;
import com.querydsl.jpa.NoHibernate;
import com.querydsl.jpa.NoOpenJPA;
import com.querydsl.jpa.Projection;
import com.querydsl.jpa.QProjection;
import com.querydsl.jpa.domain.Animal;
import com.querydsl.jpa.domain.Author;
import com.querydsl.jpa.domain.Book;
import com.querydsl.jpa.domain.Cat;
import com.querydsl.jpa.domain.Color;
import com.querydsl.jpa.domain.Company;
import com.querydsl.jpa.domain.DomesticCat;
import com.querydsl.jpa.domain.DoubleProjection;
import com.querydsl.jpa.domain.Employee;
import com.querydsl.jpa.domain.Entity1;
import com.querydsl.jpa.domain.Entity2;
import com.querydsl.jpa.domain.FloatProjection;
import com.querydsl.jpa.domain.Foo;
import com.querydsl.jpa.domain.JobFunction;
import com.querydsl.jpa.domain.Numeric;
import com.querydsl.jpa.domain.QAnimal;
import com.querydsl.jpa.domain.QAuthor;
import com.querydsl.jpa.domain.QBook;
import com.querydsl.jpa.domain.QCat;
import com.querydsl.jpa.domain.QCompany;
import com.querydsl.jpa.domain.QDomesticCat;
import com.querydsl.jpa.domain.QDoubleProjection;
import com.querydsl.jpa.domain.QEmployee;
import com.querydsl.jpa.domain.QEntity1;
import com.querydsl.jpa.domain.QFamily;
import com.querydsl.jpa.domain.QFloatProjection;
import com.querydsl.jpa.domain.QFoo;
import com.querydsl.jpa.domain.QHuman;
import com.querydsl.jpa.domain.QMammal;
import com.querydsl.jpa.domain.QNumeric;
import com.querydsl.jpa.domain.QShow;
import com.querydsl.jpa.domain.QSimpleTypes;
import com.querydsl.jpa.domain.QUser;
import com.querydsl.jpa.domain.QWorld;
import com.querydsl.jpa.domain.Show;
import com.querydsl.jpa.domain4.QBookMark;
import com.querydsl.jpa.domain4.QBookVersion;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractJPATest {
    private static final Expression<?>[] NO_EXPRESSIONS = new Expression[0];
    private static final QCompany company = QCompany.company;
    private static final QAnimal animal = QAnimal.animal;
    private static final QCat cat = QCat.cat;
    private static final QCat otherCat = new QCat("otherCat");
    private static final BooleanExpression cond1 = AbstractJPATest.cat.name.length().gt((Number)0);
    private static final BooleanExpression cond2 = AbstractJPATest.otherCat.name.length().gt((Number)0);
    private static final Predicate condition = ExpressionUtils.and((Predicate)((Predicate)ExpressionUtils.extract((Expression)cond1)), (Predicate)((Predicate)ExpressionUtils.extract((Expression)cond2)));
    private static final Date birthDate;
    private static final java.sql.Date date;
    private static final Time time;
    private final List<Cat> savedCats = new ArrayList<Cat>();

    protected Target getTarget() {
        return Mode.target.get();
    }

    protected abstract JPQLQuery<?> query();

    protected abstract JPQLQuery<?> testQuery();

    protected abstract void save(Object var1);

    @Before
    public void setUp() {
        Cat cat2;
        if (this.query().from(new EntityPath[]{AbstractJPATest.cat}).fetchCount() > 0L) {
            this.savedCats.addAll(((JPQLQuery)this.query().from(new EntityPath[]{AbstractJPATest.cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.asc()})).select((Expression)AbstractJPATest.cat).fetch());
            return;
        }
        Cat prev = null;
        for (Cat cat2 : Arrays.asList(new Cat("Bob123", 1, 1.0), new Cat("Ruth123", 2, 2.0), new Cat("Felix123", 3, 3.0), new Cat("Allen123", 4, 4.0), new Cat("Mary_123", 5, 5.0))) {
            if (prev != null) {
                cat2.addKitten(prev);
            }
            cat2.setBirthdate(birthDate);
            cat2.setDateField(date);
            cat2.setTimeField(time);
            cat2.setColor(Color.BLACK);
            cat2.setMate(prev);
            this.save(cat2);
            this.savedCats.add(cat2);
            prev = cat2;
        }
        Animal animal = new Animal(10);
        animal.setBodyWeight(10.5);
        this.save(animal);
        cat2 = new Cat("Some", 6, 6.0);
        cat2.setBirthdate(birthDate);
        this.save(cat2);
        this.savedCats.add(cat2);
        Show show = new Show(1);
        show.acts = new HashMap<String, String>();
        show.acts.put("a", "A");
        show.acts.put("b", "B");
        this.save(show);
        Company company = new Company();
        company.name = "1234567890123456789012345678901234567890";
        company.id = 1;
        company.ratingOrdinal = Company.Rating.A;
        company.ratingString = Company.Rating.AA;
        this.save(company);
        Employee employee = new Employee();
        employee.id = 1;
        employee.lastName = "Smith";
        employee.jobFunctions.add(JobFunction.CODER);
        this.save(employee);
        Employee employee2 = new Employee();
        employee2.id = 2;
        employee2.lastName = "Doe";
        employee2.jobFunctions.add(JobFunction.CODER);
        employee2.jobFunctions.add(JobFunction.CONSULTANT);
        employee2.jobFunctions.add(JobFunction.CONTROLLER);
        this.save(employee2);
        this.save(new Entity1(1));
        this.save(new Entity1(2));
        this.save(new Entity2(3));
        Foo foo = new Foo();
        foo.id = 1;
        foo.names = Arrays.asList("a", "b");
        foo.bar = "M\u00fcnchen";
        this.save(foo);
        Numeric numeric = new Numeric();
        numeric.setValue(BigDecimal.valueOf(26.9));
        this.save(numeric);
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void add_bigDecimal() {
        QSimpleTypes entity = new QSimpleTypes("entity1");
        QSimpleTypes entity2 = new QSimpleTypes("entity2");
        NumberPath<BigDecimal> bigd1 = entity.bigDecimal;
        NumberPath<BigDecimal> bigd2 = entity2.bigDecimal;
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{bigd1.add(bigd2).loe((Number)new BigDecimal("1.00"))})).select((Expression)entity).fetch());
    }

    @Test
    public void aggregates_list_max() {
        Assert.assertEquals((Object)6, (Object)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.id.max()).fetchFirst());
    }

    @Test
    public void aggregates_list_min() {
        Assert.assertEquals((Object)1, (Object)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.id.min()).fetchFirst());
    }

    @Test
    public void aggregates_uniqueResult_max() {
        Assert.assertEquals((Object)6, (Object)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.id.max()).fetchFirst());
    }

    @Test
    public void aggregates_uniqueResult_min() {
        Assert.assertEquals((Object)1, (Object)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.id.min()).fetchFirst());
    }

    @Test
    public void alias() {
        Assert.assertEquals((long)6L, (long)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.id.as(AbstractJPATest.cat.id)).fetch().size());
    }

    @Test
    public void any_and_gt() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)AbstractJPATest.cat.kittens.any()).name.eq((Object)"Ruth123"), ((QCat)AbstractJPATest.cat.kittens.any()).bodyWeight.gt((Number)10.0)})).fetchCount());
    }

    @Test
    public void any_and_lt() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)AbstractJPATest.cat.kittens.any()).name.eq((Object)"Ruth123"), ((QCat)AbstractJPATest.cat.kittens.any()).bodyWeight.lt((Number)10.0)})).fetchCount());
    }

    @Test
    public void any_in_order() {
        Assert.assertFalse((boolean)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{((QCat)AbstractJPATest.cat.kittens.any()).name.asc()})).select((Expression)cat).fetch().isEmpty());
    }

    @Test
    public void any_in_projection() {
        Assert.assertFalse((boolean)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.kittens.any()).fetch().isEmpty());
    }

    @Test
    public void any_in_projection2() {
        Assert.assertFalse((boolean)this.query().from(new EntityPath[]{cat}).select((Expression)((QCat)AbstractJPATest.cat.kittens.any()).name).fetch().isEmpty());
    }

    @Test
    public void any_in_projection3() {
        Assert.assertFalse((boolean)this.query().from(new EntityPath[]{cat}).select(new Expression[]{((QCat)AbstractJPATest.cat.kittens.any()).name, ((QCat)AbstractJPATest.cat.kittens.any()).bodyWeight}).fetch().isEmpty());
    }

    @Test
    public void any_in1() {
        Assert.assertFalse((boolean)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)AbstractJPATest.cat.kittens.any()).in(this.savedCats)})).select((Expression)cat).fetch().isEmpty());
    }

    @Test
    public void any_in11() {
        ArrayList ids = Lists.newArrayList();
        for (Cat cat : this.savedCats) {
            ids.add(cat.getId());
        }
        Assert.assertFalse((boolean)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)AbstractJPATest.cat.kittens.any()).id.in((Collection)ids)})).select((Expression)cat).fetch().isEmpty());
    }

    @Test
    public void any_in2() {
        Assert.assertFalse((boolean)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)AbstractJPATest.cat.kittens.any()).in(this.savedCats), ((QCat)AbstractJPATest.cat.kittens.any()).in(this.savedCats.subList(0, 1)).not()})).select((Expression)cat).fetch().isEmpty());
    }

    @Test
    @NoBatooJPA
    public void any_in3() {
        QEmployee employee = QEmployee.employee;
        Assert.assertFalse((boolean)((JPQLQuery)this.query().from(new EntityPath[]{employee}).where(new Predicate[]{((EnumPath)employee.jobFunctions.any()).in((Object[])new JobFunction[]{JobFunction.CODER, JobFunction.CONSULTANT})})).select((Expression)employee).fetch().isEmpty());
    }

    @Test
    public void any_simple() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)AbstractJPATest.cat.kittens.any()).name.eq((Object)"Ruth123")})).fetchCount());
    }

    @Test
    public void any_any() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)((QCat)AbstractJPATest.cat.kittens.any()).kittens.any()).name.eq((Object)"Ruth123")})).fetchCount());
    }

    @Test
    public void arrayProjection() {
        List results = this.query().from(new EntityPath[]{cat}).select((Expression)new ArrayConstructorExpression(String[].class, new Expression[]{AbstractJPATest.cat.name})).fetch();
        Assert.assertFalse((boolean)results.isEmpty());
        for (String[] result : results) {
            Assert.assertNotNull((Object)result[0]);
        }
    }

    @Test
    public void as() {
        Assert.assertTrue((this.query().from(new EntityPath[]{(EntityPath)QAnimal.animal.as(QCat.class)}).fetchCount() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void between() {
        Assert.assertEquals((Object)ImmutableList.of((Object)2, (Object)3, (Object)4, (Object)5), (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.id.between((Number)2, (Number)5)})).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.asc()})).select(AbstractJPATest.cat.id).fetch());
    }

    @Test
    @NoBatooJPA
    public void case1() {
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)2, (Object)2, (Object)2, (Object)2), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.asc()})).select(AbstractJPATest.cat.name.when((Object)"Bob123").then((Number)1).otherwise((Object)2)).fetch());
    }

    @Test
    @NoBatooJPA
    public void case1_long() {
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)2L, (Object)2L, (Object)2L, (Object)2L), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.asc()})).select(AbstractJPATest.cat.name.when((Object)"Bob123").then((Number)1L).otherwise((Object)2L)).fetch());
        List rv = this.query().from(new EntityPath[]{cat}).select(AbstractJPATest.cat.name.when((Object)"Bob").then((Number)1).otherwise((Object)2)).fetch();
        AbstractJPATest.assertInstancesOf(Integer.class, rv);
    }

    @Test
    @NoEclipseLink
    @NoHibernate
    public void case1_date() {
        List rv = this.query().from(new EntityPath[]{cat}).select(AbstractJPATest.cat.name.when((Object)"Bob").then((Comparable)new LocalDate()).otherwise((Object)new LocalDate().plusDays(1))).fetch();
        AbstractJPATest.assertInstancesOf(LocalDate.class, rv);
    }

    @Test
    @NoHibernate
    @NoEclipseLink(value={Target.MYSQL, Target.POSTGRESQL})
    public void case1_date2() {
        List rv = this.query().from(new EntityPath[]{cat}).select(AbstractJPATest.cat.name.when((Object)"Bob").then(new java.sql.Date(0L)).otherwise((Object)new java.sql.Date(0L))).fetch();
        AbstractJPATest.assertInstancesOf(java.sql.Date.class, rv);
    }

    @Test
    @NoEclipseLink
    @NoHibernate
    public void case1_time() {
        List rv = this.query().from(new EntityPath[]{cat}).select(AbstractJPATest.cat.name.when((Object)"Bob").then((Comparable)new LocalTime()).otherwise((Object)new LocalTime().plusHours(1))).fetch();
        AbstractJPATest.assertInstancesOf(LocalTime.class, rv);
    }

    @Test
    @NoHibernate
    @NoEclipseLink(value={Target.MYSQL, Target.POSTGRESQL})
    public void case1_time2() {
        List rv = this.query().from(new EntityPath[]{cat}).select(AbstractJPATest.cat.name.when((Object)"Bob").then(new Time(0L)).otherwise((Object)new Time(0L))).fetch();
        AbstractJPATest.assertInstancesOf(Time.class, rv);
    }

    @Test
    @NoEclipseLink
    @NoHibernate
    public void case1_timestamp() {
        List rv = this.query().from(new EntityPath[]{cat}).select(AbstractJPATest.cat.name.when((Object)"Bob").then((Comparable)new DateTime()).otherwise((Object)new DateTime().plusHours(1))).fetch();
        AbstractJPATest.assertInstancesOf(DateTime.class, rv);
    }

    @Test
    @NoHibernate
    @NoEclipseLink(value={Target.MYSQL, Target.POSTGRESQL})
    public void case1_timestamp2() {
        List rv = this.query().from(new EntityPath[]{cat}).select(AbstractJPATest.cat.name.when((Object)"Bob").then(new Timestamp(0L)).otherwise((Object)new Timestamp(0L))).fetch();
        AbstractJPATest.assertInstancesOf(Timestamp.class, rv);
    }

    @Test
    public void case2() {
        Assert.assertEquals((Object)ImmutableList.of((Object)4, (Object)4, (Object)4, (Object)4, (Object)4, (Object)4), (Object)this.query().from(new EntityPath[]{cat}).select(Expressions.cases().when((Predicate)AbstractJPATest.cat.toes.eq((Object)2)).then(AbstractJPATest.cat.id.multiply((Number)2)).when((Predicate)AbstractJPATest.cat.toes.eq((Object)3)).then((Expression)AbstractJPATest.cat.id.multiply((Number)3)).otherwise((Object)4)).fetch());
    }

    @Test
    public void case3() {
        Assert.assertEquals((Object)ImmutableList.of((Object)4, (Object)4, (Object)4, (Object)4, (Object)4, (Object)4), (Object)this.query().from(new EntityPath[]{cat}).select(Expressions.cases().when((Predicate)AbstractJPATest.cat.toes.in((Object[])new Integer[]{2, 3})).then(AbstractJPATest.cat.id.multiply(AbstractJPATest.cat.toes)).otherwise((Object)4)).fetch());
    }

    @Test
    @ExcludeIn(value={Target.MYSQL})
    public void case4() {
        NumberExpression numExpression = AbstractJPATest.cat.bodyWeight.floatValue().divide((Expression)AbstractJPATest.otherCat.bodyWeight.floatValue()).multiply((Number)100);
        NumberExpression numExpression2 = (NumberExpression)AbstractJPATest.cat.id.when((Object)0).then((Number)Float.valueOf(0.0f)).otherwise((Expression)numExpression);
        Assert.assertEquals((Object)ImmutableList.of((Object)200, (Object)150, (Object)133, (Object)125, (Object)120), (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat, otherCat}).where(new Predicate[]{AbstractJPATest.cat.id.eq((Expression)AbstractJPATest.otherCat.id.add((Number)1))})).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.asc(), AbstractJPATest.otherCat.id.asc()})).select((Expression)numExpression2.intValue()).fetch());
    }

    @Test
    public void case5() {
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)0, (Object)1, (Object)1, (Object)1, (Object)1), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.asc()})).select(AbstractJPATest.cat.mate.when(this.savedCats.get(0)).then((Number)0).otherwise((Object)1)).fetch());
    }

    private static <T> void assertInstancesOf(Class<T> clazz, Iterable<T> rows) {
        for (T row : rows) {
            Assert.assertEquals((String)row.toString(), clazz, row.getClass());
        }
    }

    @Test
    public void caseBuilder() {
        QCat cat2 = new QCat("cat2");
        NumberExpression casex = (NumberExpression)new CaseBuilder().when((Predicate)AbstractJPATest.cat.weight.isNull().and((Predicate)AbstractJPATest.cat.weight.isNull())).then((Number)0).when((Predicate)AbstractJPATest.cat.weight.isNull()).then(cat2.weight).when((Predicate)cat2.weight.isNull()).then(AbstractJPATest.cat.weight).otherwise((Expression)AbstractJPATest.cat.weight.add(cat2.weight));
        ((JPQLQuery)this.query().from(new EntityPath[]{cat, cat2}).orderBy(new OrderSpecifier[]{casex.asc()})).select(new Expression[]{AbstractJPATest.cat.id, cat2.id}).fetch();
        ((JPQLQuery)this.query().from(new EntityPath[]{cat, cat2}).orderBy(new OrderSpecifier[]{casex.desc()})).select(new Expression[]{AbstractJPATest.cat.id, cat2.id}).fetch();
    }

    @Test
    public void cast() {
        List cats = this.query().from(new EntityPath[]{cat}).select((Expression)cat).fetch();
        List weights = this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.bodyWeight.castToNum(Integer.class)).fetch();
        for (int i = 0; i < cats.size(); ++i) {
            Assert.assertEquals((Object)((int)((Cat)cats.get(i)).getBodyWeight()), weights.get(i));
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLSERVER})
    public void cast_toString() {
        for (Tuple tuple : this.query().from(new EntityPath[]{cat}).select(new Expression[]{AbstractJPATest.cat.breed, AbstractJPATest.cat.breed.stringValue()}).fetch()) {
            Assert.assertEquals((Object)((Integer)tuple.get(AbstractJPATest.cat.breed)).toString(), (Object)tuple.get((Expression)AbstractJPATest.cat.breed.stringValue()));
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLSERVER})
    public void cast_toString_append() {
        for (Tuple tuple : this.query().from(new EntityPath[]{cat}).select(new Expression[]{AbstractJPATest.cat.breed, AbstractJPATest.cat.breed.stringValue().append("test")}).fetch()) {
            Assert.assertEquals((Object)(((Integer)tuple.get(AbstractJPATest.cat.breed)).toString() + "test"), (Object)tuple.get((Expression)AbstractJPATest.cat.breed.stringValue().append("test")));
        }
    }

    @Test
    public void collection_predicates() {
        ListPath<Cat, QCat> path = AbstractJPATest.cat.kittens;
        List<Predicate> predicates = Arrays.asList(new Predicate[0]);
        for (Predicate pred : predicates) {
            System.err.println(pred);
            ((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{pred})).select((Expression)cat).fetch();
        }
    }

    @Test
    public void collection_projections() {
        ListPath<Cat, QCat> path = AbstractJPATest.cat.kittens;
        List<Expression> projections = Arrays.asList(new Expression[0]);
        for (Expression proj : projections) {
            System.err.println(proj);
            this.query().from(new EntityPath[]{cat}).select(proj).fetch();
        }
    }

    @Test
    public void constant() {
        List cats = this.query().from(new EntityPath[]{cat}).select((Expression)cat).fetch();
        StringPath path = Expressions.stringPath((String)"const");
        List tuples = this.query().from(new EntityPath[]{cat}).select(new Expression[]{AbstractJPATest.cat.id, Expressions.constantAs((Object)"abc", (Path)path)}).fetch();
        for (int i = 0; i < cats.size(); ++i) {
            Assert.assertEquals((Object)((Cat)cats.get(i)).getId(), (Object)((Tuple)tuples.get(i)).get(AbstractJPATest.cat.id));
            Assert.assertEquals((Object)"abc", (Object)((Tuple)tuples.get(i)).get((Expression)path));
        }
    }

    @Test
    public void constant2() {
        Assert.assertFalse((boolean)this.query().from(new EntityPath[]{cat}).select(new Expression[]{AbstractJPATest.cat.id, Expressions.constant((Object)"name")}).fetch().isEmpty());
    }

    @Test
    public void constructorProjection() {
        List projections = this.query().from(new EntityPath[]{cat}).select((Expression)Projections.constructor(Projection.class, (Expression[])new Expression[]{AbstractJPATest.cat.name, cat})).fetch();
        Assert.assertFalse((boolean)projections.isEmpty());
        for (Projection projection : projections) {
            Assert.assertNotNull((Object)projection);
        }
    }

    @Test
    public void constructorProjection2() {
        List projections = this.query().from(new EntityPath[]{cat}).select((Expression)new QProjection((StringExpression)AbstractJPATest.cat.name, cat)).fetch();
        Assert.assertFalse((boolean)projections.isEmpty());
        for (Projection projection : projections) {
            Assert.assertNotNull((Object)projection);
        }
    }

    @Test
    public void constructorProjection3() {
        List projections = this.query().from(new EntityPath[]{cat}).select((Expression)new QProjection((NumberExpression<Integer>)AbstractJPATest.cat.id, Expressions.FALSE)).fetch();
        Assert.assertFalse((boolean)projections.isEmpty());
        for (Projection projection : projections) {
            Assert.assertNotNull((Object)projection);
        }
    }

    @Test
    public void contains_ic() {
        QFoo foo = QFoo.foo;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{foo}).where(new Predicate[]{foo.bar.containsIgnoreCase("M\u00fcnchen")})).fetchCount());
    }

    @Test
    public void contains1() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.contains("eli")})).fetchCount());
    }

    @Test
    public void contains2() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.kittens.contains((Object)this.savedCats.get(0))})).fetchCount());
    }

    @Test
    public void contains3() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.contains("_")})).fetchCount());
    }

    @Test
    public void contains4() {
        QEmployee employee = QEmployee.employee;
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{employee}).where(new Predicate[]{employee.jobFunctions.contains((Object)JobFunction.CODER), employee.jobFunctions.contains((Object)JobFunction.CONSULTANT), employee.jobFunctions.size().eq((Object)2)})).select((Expression)employee).fetch());
    }

    @Test
    public void count() {
        QShow show = QShow.show;
        Assert.assertTrue((this.query().from(new EntityPath[]{show}).fetchCount() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void count_distinct() {
        QCat cat = QCat.cat;
        ((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{cat.id})).select(new Expression[]{cat.id, cat.breed.countDistinct()}).fetch();
    }

    @Test
    @NoBatooJPA
    @NoHibernate
    public void count_distinct2() {
        QCat cat = QCat.cat;
        ((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{cat.id})).select(new Expression[]{cat.id, cat.birthdate.dayOfMonth().countDistinct()}).fetch();
    }

    @Test
    @NoEclipseLink
    public void distinct_orderBy() {
        QCat cat = QCat.cat;
        List result = ((JPQLQuery)((JPQLQuery)this.query().select(new Expression[]{cat.id, cat.mate.id}).distinct()).from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{cat.mate.id.asc().nullsFirst(), cat.id.asc().nullsFirst()})).fetch();
        Assert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new Tuple[]{new MockTuple(new Object[]{1, null}), new MockTuple(new Object[]{6, null}), new MockTuple(new Object[]{2, 1}), new MockTuple(new Object[]{3, 2}), new MockTuple(new Object[]{4, 3}), new MockTuple(new Object[]{5, 4})}));
    }

    @Test
    @NoHibernate
    @ExcludeIn(value={Target.MYSQL})
    public void distinct_orderBy2() {
        QCat cat = QCat.cat;
        List result = ((JPQLQuery)((JPQLQuery)this.query().select(new Expression[]{cat.id, cat.mate.id}).distinct()).from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{cat.mate.id.asc().nullsFirst()})).fetch();
        Assert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new Tuple[]{new MockTuple(new Object[]{2, 1}), new MockTuple(new Object[]{3, 2}), new MockTuple(new Object[]{4, 3}), new MockTuple(new Object[]{5, 4})}));
    }

    @Test
    @NoEclipseLink(value={Target.HSQLDB})
    public void count_distinct3() {
        QCat kitten = new QCat("kitten");
        Assert.assertEquals((long)4L, (long)((Long)this.query().from(new EntityPath[]{cat}).leftJoin(AbstractJPATest.cat.kittens, (Path)kitten).select((Expression)kitten.countDistinct()).fetchOne()).intValue());
        Assert.assertEquals((long)6L, (long)this.query().from(new EntityPath[]{cat}).leftJoin(AbstractJPATest.cat.kittens, (Path)kitten).select((Expression)kitten.countDistinct()).fetchCount());
    }

    @Test
    public void distinctResults() {
        System.out.println("-- fetch results");
        QueryResults res = ((JPQLQuery)this.query().from(new EntityPath[]{cat}).limit(2L)).select(AbstractJPATest.cat.birthdate).fetchResults();
        Assert.assertEquals((long)2L, (long)res.getResults().size());
        Assert.assertEquals((long)6L, (long)res.getTotal());
        System.out.println();
        System.out.println("-- fetch distinct results");
        res = ((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).limit(2L)).distinct()).select(AbstractJPATest.cat.birthdate).fetchResults();
        Assert.assertEquals((long)1L, (long)res.getResults().size());
        Assert.assertEquals((long)1L, (long)res.getTotal());
        System.out.println();
        System.out.println("-- fetch distinct");
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).distinct()).select(AbstractJPATest.cat.birthdate).fetch().size());
    }

    @Test
    public void date() {
        Assert.assertEquals((long)2000L, (long)((Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.year()).fetchFirst()).intValue());
        Assert.assertEquals((long)200002L, (long)((Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.yearMonth()).fetchFirst()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.month()).fetchFirst()).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.dayOfMonth()).fetchFirst()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.hour()).fetchFirst()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.minute()).fetchFirst()).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.second()).fetchFirst()).intValue());
    }

    @Test
    @NoEclipseLink(value={Target.DERBY, Target.HSQLDB})
    @NoHibernate(value={Target.DERBY, Target.POSTGRESQL, Target.SQLSERVER})
    public void date_yearWeek() {
        int value = (Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.yearWeek()).fetchFirst();
        Assert.assertTrue((value == 200006 || value == 200005 ? 1 : 0) != 0);
    }

    @Test
    @NoEclipseLink(value={Target.DERBY, Target.HSQLDB})
    @NoHibernate(value={Target.DERBY, Target.POSTGRESQL, Target.SQLSERVER})
    public void date_week() {
        int value = (Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.birthdate.week()).fetchFirst();
        Assert.assertTrue((value == 6 || value == 5 ? 1 : 0) != 0);
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void divide() {
        QSimpleTypes entity = new QSimpleTypes("entity1");
        QSimpleTypes entity2 = new QSimpleTypes("entity2");
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{entity.ddouble.divide(entity2.ddouble).loe((Number)2.0)})).select((Expression)entity).fetch());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{entity.ddouble.divide(entity2.iint).loe((Number)2.0)})).select((Expression)entity).fetch());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{entity.iint.divide(entity2.ddouble).loe((Number)2.0)})).select((Expression)entity).fetch());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{entity.iint.divide(entity2.iint).loe((Number)2)})).select((Expression)entity).fetch());
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void divide_bigDecimal() {
        QSimpleTypes entity = new QSimpleTypes("entity1");
        QSimpleTypes entity2 = new QSimpleTypes("entity2");
        NumberPath<BigDecimal> bigd1 = entity.bigDecimal;
        NumberPath<BigDecimal> bigd2 = entity2.bigDecimal;
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{bigd1.divide(bigd2).loe((Number)new BigDecimal("1.00"))})).select((Expression)entity).fetch());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{entity.ddouble.divide(bigd2).loe((Number)new BigDecimal("1.00"))})).select((Expression)entity).fetch());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{bigd1.divide(entity.ddouble).loe((Number)new BigDecimal("1.00"))})).select((Expression)entity).fetch());
    }

    @Test
    public void endsWith() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.endsWith("h123")})).fetchCount());
    }

    @Test
    public void endsWith_ignoreCase() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.endsWithIgnoreCase("H123")})).fetchCount());
    }

    @Test
    public void endsWith2() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.endsWith("X")})).fetchCount());
    }

    @Test
    public void endsWith3() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.endsWith("_123")})).fetchCount());
    }

    @Test
    @NoBatooJPA
    public void enum_eq() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{company}).where(new Predicate[]{AbstractJPATest.company.ratingOrdinal.eq((Object)Company.Rating.A)})).fetchCount());
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{company}).where(new Predicate[]{AbstractJPATest.company.ratingString.eq((Object)Company.Rating.AA)})).fetchCount());
    }

    @Test
    @NoBatooJPA
    public void enum_in() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{company}).where(new Predicate[]{AbstractJPATest.company.ratingOrdinal.in((Object[])new Company.Rating[]{Company.Rating.A, Company.Rating.AA})})).fetchCount());
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{company}).where(new Predicate[]{AbstractJPATest.company.ratingString.in((Object[])new Company.Rating[]{Company.Rating.A, Company.Rating.AA})})).fetchCount());
    }

    @Test
    @NoBatooJPA
    public void enum_in2() {
        QEmployee employee = QEmployee.employee;
        JPQLQuery<?> query = this.query();
        query.from(new EntityPath[]{employee}).where(new Predicate[]{employee.lastName.eq((Object)"Smith"), employee.jobFunctions.contains((Object)JobFunction.CODER)});
        Assert.assertEquals((long)1L, (long)query.fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.SQLSERVER})
    public void enum_startsWith() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{company}).where(new Predicate[]{AbstractJPATest.company.ratingString.stringValue().startsWith("A")})).fetchCount());
    }

    @Test
    @NoEclipseLink(value={Target.HSQLDB})
    public void factoryExpressions() {
        QCat cat = QCat.cat;
        QCat cat2 = new QCat("cat2");
        QCat kitten = new QCat("kitten");
        JPQLQuery query = this.query().from(new EntityPath[]{cat}).leftJoin((EntityPath)cat.mate, (Path)cat2).leftJoin(cat2.kittens, (Path)kitten).select((Expression)Projections.tuple((Expression[])new Expression[]{cat.id, new QFamily((Expression<? extends Cat>)cat, (Expression<? extends Cat>)cat2, (Expression<? extends Cat>)kitten).skipNulls()}));
        Assert.assertEquals((long)6L, (long)query.fetch().size());
        Assert.assertNotNull((Object)((JPQLQuery)query.limit(1L)).fetchOne());
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @NoBatooJPA
    public void fetch() {
        QMammal mammal = QMammal.mammal;
        QHuman human = new QHuman("mammal");
        this.query().from(new EntityPath[]{mammal}).leftJoin(human.hairs).fetchJoin().select((Expression)mammal).fetch();
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @NoBatooJPA
    public void fetch2() {
        QWorld world = QWorld.world;
        QMammal mammal = QMammal.mammal;
        QHuman human = new QHuman("mammal");
        this.query().from(new EntityPath[]{world}).leftJoin(world.mammals, (Path)mammal).fetchJoin().leftJoin(human.hairs).fetchJoin().select((Expression)world).fetch();
    }

    @Test
    @ExcludeIn(value={Target.MYSQL, Target.DERBY})
    @NoBatooJPA
    public void groupBy() {
        QAuthor author = QAuthor.author;
        QBook book = QBook.book;
        for (int i = 0; i < 10; ++i) {
            Author a = new Author();
            a.setName(String.valueOf(i));
            this.save(a);
            for (int j = 0; j < 2; ++j) {
                Book b = new Book();
                b.setTitle(String.valueOf(i) + " " + String.valueOf(j));
                b.setAuthor(a);
                this.save(b);
            }
        }
        Map map = (Map)this.query().from(new EntityPath[]{author}).join(author.books, (Path)book).transform(GroupBy.groupBy(author.id).as((Expression)GroupBy.list((Expression)QPair.create(book.id, (Expression)book.title))));
        for (Map.Entry entry : map.entrySet()) {
            System.out.println("author = " + entry.getKey());
            for (Pair pair : (List)entry.getValue()) {
                System.out.println("  book = " + pair.getFirst() + "," + (String)pair.getSecond());
            }
        }
    }

    @Test
    public void groupBy2() {
        ((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.bodyWeight.gt((Number)0)})).groupBy(new Expression[]{AbstractJPATest.cat.name, AbstractJPATest.cat.breed})).select(new Expression[]{AbstractJPATest.cat.name, AbstractJPATest.cat.breed, AbstractJPATest.cat.bodyWeight.sum()}).fetch();
    }

    @Test
    @NoEclipseLink
    public void groupBy_yearMonth() {
        ((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.birthdate.yearMonth()})).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.birthdate.yearMonth().asc()})).select((Expression)AbstractJPATest.cat.id.count()).fetch();
    }

    @Test
    @Ignore
    public void groupBy_count() {
        List ids = ((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.id})).select(AbstractJPATest.cat.id).fetch();
        long count = ((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.id})).fetchCount();
        QueryResults results = ((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.id})).limit(1L)).select(AbstractJPATest.cat.id).fetchResults();
        long catCount = this.query().from(new EntityPath[]{cat}).fetchCount();
        Assert.assertEquals((long)catCount, (long)ids.size());
        Assert.assertEquals((long)catCount, (long)count);
        Assert.assertEquals((long)catCount, (long)results.getResults().size());
        Assert.assertEquals((long)catCount, (long)results.getTotal());
    }

    @Test
    @Ignore
    public void groupBy_distinct_count() {
        List ids = ((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.id})).distinct()).select((Expression)Expressions.ONE).fetch();
        QueryResults results = ((JPQLQuery)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.id})).limit(1L)).distinct()).select((Expression)Expressions.ONE).fetchResults();
        Assert.assertEquals((long)1L, (long)ids.size());
        Assert.assertEquals((long)1L, (long)results.getResults().size());
        Assert.assertEquals((long)1L, (long)results.getTotal());
    }

    @Test
    @NoHibernate
    public void groupBy_select() {
        NumberPath length = Expressions.numberPath(Integer.class, (String)"len");
        Assert.assertEquals((Object)ImmutableList.of((Object)4, (Object)6, (Object)7, (Object)8), (Object)((JPQLQuery)((JPQLQuery)this.query().select((Expression)AbstractJPATest.cat.name.length().as((Path)length)).from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{length.asc()})).groupBy(new Expression[]{length})).fetch());
    }

    @Test
    public void groupBy_results() {
        QueryResults results = ((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.id})).select(AbstractJPATest.cat.id).fetchResults();
        Assert.assertEquals((long)6L, (long)results.getTotal());
        Assert.assertEquals((long)6L, (long)results.getResults().size());
    }

    @Test
    public void groupBy_results2() {
        QueryResults results = ((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.birthdate})).select((Expression)AbstractJPATest.cat.id.max()).fetchResults();
        Assert.assertEquals((long)1L, (long)results.getTotal());
        Assert.assertEquals((long)1L, (long)results.getResults().size());
    }

    @Test
    public void in() {
        Assert.assertEquals((long)3L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.in((Object[])new String[]{"Bob123", "Ruth123", "Felix123"})})).fetchCount());
        Assert.assertEquals((long)3L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.id.in(Arrays.asList(1, 2, 3))})).fetchCount());
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.in(Arrays.asList("A", "B", "C"))})).fetchCount());
    }

    @Test
    public void in2() {
        Assert.assertEquals((long)3L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.id.in((Object[])new Integer[]{1, 2, 3})})).fetchCount());
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.in((Object[])new String[]{"A", "B", "C"})})).fetchCount());
    }

    @Test
    public void in3() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.in((Object[])"A,B,C".split(","))})).fetchCount());
    }

    @Test
    public void in4() {
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.id.eq((Object)1), ((QCat)AbstractJPATest.cat.kittens.any()).id.in((Object[])new Integer[]{1, 2, 3})})).select((Expression)cat).fetch());
    }

    @Test
    public void in5() {
        Assert.assertEquals((long)4L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.mate.in(this.savedCats)})).fetchCount());
    }

    @Test
    @Ignore
    public void in6() {
    }

    @Test
    public void in7() {
        Assert.assertEquals((long)4L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((QCat)AbstractJPATest.cat.kittens.any()).in(this.savedCats)})).fetchCount());
    }

    @Test
    public void in_empty() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.in((Collection)ImmutableList.of())})).fetchCount());
    }

    @Test
    @NoOpenJPA
    public void indexOf() {
        Assert.assertEquals((Object)0, (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Object)"Bob123")})).select((Expression)AbstractJPATest.cat.name.indexOf("B")).fetchFirst());
    }

    @Test
    @NoOpenJPA
    public void indexOf2() {
        Assert.assertEquals((Object)1, (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Object)"Bob123")})).select((Expression)AbstractJPATest.cat.name.indexOf("o")).fetchFirst());
    }

    @Test
    public void instanceOf_cat() {
        Assert.assertEquals((long)6L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{cat.instanceOf(Cat.class)})).fetchCount());
    }

    @Test
    public void instanceOf_domesticCat() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{cat.instanceOf(DomesticCat.class)})).fetchCount());
    }

    @Test
    public void instanceOf_entity1() {
        QEntity1 entity1 = QEntity1.entity1;
        Assert.assertEquals((long)2L, (long)((JPQLQuery)this.query().from(new EntityPath[]{entity1}).where(new Predicate[]{entity1.instanceOf(Entity1.class)})).fetchCount());
    }

    @Test
    public void instanceOf_entity2() {
        QEntity1 entity1 = QEntity1.entity1;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{entity1}).where(new Predicate[]{entity1.instanceOf(Entity2.class)})).fetchCount());
    }

    @Test
    @NoHibernate
    public void isEmpty_elementCollection() {
        QEmployee employee = QEmployee.employee;
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{employee}).where(new Predicate[]{employee.jobFunctions.isEmpty()})).fetchCount());
    }

    @Test
    public void isEmpty_relation() {
        Assert.assertEquals((long)6L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.kittensSet.isEmpty()})).fetchCount());
    }

    @Test
    @NoEclipseLink
    @ExcludeIn(value={Target.ORACLE, Target.TERADATA})
    public void joinEmbeddable() {
        QBookVersion bookVersion = QBookVersion.bookVersion;
        QBookMark bookMark = QBookMark.bookMark;
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{bookVersion}).join(bookVersion.definition.bookMarks, (Path)bookMark).where(new Predicate[]{bookVersion.definition.bookMarks.size().eq((Object)1), bookMark.page.eq((Object)2357L).or((Predicate)bookMark.page.eq((Object)2356L))})).select((Expression)bookVersion).fetch());
    }

    @Test
    public void length() {
        Assert.assertEquals((long)6L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.length().gt((Number)0)})).fetchCount());
    }

    @Test
    public void like() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.like("!")})).fetchCount());
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.like("\\")})).fetchCount());
    }

    @Test
    public void limit() {
        List<String> names1 = Arrays.asList("Allen123", "Bob123");
        Assert.assertEquals(names1, (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.name.asc()})).limit(2L)).select((Expression)AbstractJPATest.cat.name).fetch());
    }

    @Test
    public void limit_and_offset() {
        List<String> names3 = Arrays.asList("Felix123", "Mary_123");
        Assert.assertEquals(names3, (Object)((JPQLQuery)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.name.asc()})).limit(2L)).offset(2L)).select((Expression)AbstractJPATest.cat.name).fetch());
    }

    @Test
    public void limit2() {
        Assert.assertEquals(Collections.singletonList("Allen123"), (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.name.asc()})).limit(1L)).select((Expression)AbstractJPATest.cat.name).fetch());
    }

    @Test
    public void limit3() {
        Assert.assertEquals((long)6L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).limit(Long.MAX_VALUE)).select((Expression)cat).fetch().size());
    }

    @Test
    public void list_elementCollection_of_enum() {
        QEmployee employee = QEmployee.employee;
        EnumPath jobFunction = Expressions.enumPath(JobFunction.class, (String)"jf");
        List jobFunctions = this.query().from(new EntityPath[]{employee}).innerJoin(employee.jobFunctions, (Path)jobFunction).select((Expression)jobFunction).fetch();
        Assert.assertEquals((long)4L, (long)jobFunctions.size());
    }

    @Test
    @NoBatooJPA
    public void list_elementCollection_of_string() {
        QFoo foo = QFoo.foo;
        StringPath str = Expressions.stringPath((String)"str");
        List strings = this.query().from(new EntityPath[]{foo}).innerJoin(foo.names, (Path)str).select((Expression)str).fetch();
        Assert.assertEquals((long)2L, (long)strings.size());
        Assert.assertTrue((boolean)strings.contains("a"));
        Assert.assertTrue((boolean)strings.contains("b"));
    }

    @Test
    @NoEclipseLink(value={Target.HSQLDB})
    public void list_order_get() {
        QCat cat = QCat.cat;
        Assert.assertEquals((long)6L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{((QCat)cat.kittens.get((int)0)).name.asc()})).fetch().size());
    }

    @Test
    @NoEclipseLink(value={Target.HSQLDB})
    public void list_order_get2() {
        QCat cat = QCat.cat;
        Assert.assertEquals((long)6L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{((QCat)cat.mate.kittens.get((int)0)).name.asc()})).fetch().size());
    }

    @Test
    public void map_get() {
        QShow show = QShow.show;
        Assert.assertEquals(Arrays.asList("A"), (Object)this.query().from(new EntityPath[]{show}).select((Expression)show.acts.get((Object)"a")).fetch());
    }

    @Test
    @NoHibernate
    public void map_get2() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{((StringPath)show.acts.get((Object)"a")).eq((Object)"A")})).fetchCount());
    }

    @Test
    @NoEclipseLink
    public void map_order_get() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).orderBy(new OrderSpecifier[]{((StringPath)show.parent.acts.get((Object)"A")).asc()})).fetch().size());
    }

    @Test
    @NoEclipseLink
    public void map_order_get2() {
        QShow show = QShow.show;
        QShow parent = new QShow("parent");
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).leftJoin((EntityPath)show.parent, (Path)parent).orderBy(new OrderSpecifier[]{((StringPath)parent.acts.get((Object)"A")).asc()})).fetch().size());
    }

    @Test
    public void map_containsKey() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.containsKey((Object)"a")})).fetchCount());
    }

    @Test
    public void map_containsKey2() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.containsKey((Object)"b")})).fetchCount());
    }

    @Test
    public void map_containsKey3() {
        QShow show = QShow.show;
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.containsKey((Object)"c")})).fetchCount());
    }

    @Test
    public void map_containsValue() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.containsValue((Object)"A")})).fetchCount());
    }

    @Test
    public void map_containsValue2() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.containsValue((Object)"B")})).fetchCount());
    }

    @Test
    public void map_containsValue3() {
        QShow show = QShow.show;
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.containsValue((Object)"C")})).fetchCount());
    }

    @Test
    public void map_contains() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.contains((Object)"a", (Object)"A")})).fetchCount());
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{show.acts.contains((Object)"X", (Object)"X")})).fetchCount());
    }

    @Test
    public void map_groupBy() {
        QShow show = QShow.show;
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).select((Expression)show.acts.get((Object)"X")).groupBy(new Expression[]{show.acts.get((Object)"a")})).fetchCount());
    }

    @Test
    @Ignore
    public void map_join() {
        QShow show = QShow.show;
        StringPath act = Expressions.stringPath((String)"act");
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.query().from(new EntityPath[]{show}).join(show.acts, (Path)act).select((Expression)act).fetch());
    }

    @Test
    public void max() {
        Assert.assertEquals((double)6.0, (double)((Double)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.bodyWeight.max()).fetchFirst()), (double)1.0E-4);
    }

    @Test
    public void min() {
        Assert.assertEquals((double)1.0, (double)((Double)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.bodyWeight.min()).fetchFirst()), (double)1.0E-4);
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void multiply() {
        QSimpleTypes entity = new QSimpleTypes("entity1");
        QSimpleTypes entity2 = new QSimpleTypes("entity2");
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{entity.ddouble.multiply(entity2.ddouble).loe((Number)2.0)})).select((Expression)entity).fetch());
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void multiply_bigDecimal() {
        QSimpleTypes entity = new QSimpleTypes("entity1");
        QSimpleTypes entity2 = new QSimpleTypes("entity2");
        NumberPath<BigDecimal> bigd1 = entity.bigDecimal;
        NumberPath<BigDecimal> bigd2 = entity2.bigDecimal;
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{bigd1.multiply(bigd2).loe((Number)new BigDecimal("1.00"))})).select((Expression)entity).fetch());
    }

    @Test
    public void nestedProjection() {
        Concatenation concat = new Concatenation(new Expression[]{AbstractJPATest.cat.name, AbstractJPATest.cat.name});
        List tuples = this.query().from(new EntityPath[]{cat}).select(new Expression[]{AbstractJPATest.cat.name, concat}).fetch();
        Assert.assertFalse((boolean)tuples.isEmpty());
        for (Tuple tuple : tuples) {
            Assert.assertEquals((Object)tuple.get((Expression)concat), (Object)((String)tuple.get((Expression)AbstractJPATest.cat.name) + (String)tuple.get((Expression)AbstractJPATest.cat.name)));
        }
    }

    @Test
    public void not_in() {
        long all = this.query().from(new EntityPath[]{cat}).fetchCount();
        Assert.assertEquals((long)(all - 3L), (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.notIn((Object[])new String[]{"Bob123", "Ruth123", "Felix123"})})).fetchCount());
        Assert.assertEquals((long)3L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.id.notIn((Object[])new Integer[]{1, 2, 3})})).fetchCount());
        Assert.assertEquals((long)6L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.notIn((Object[])new String[]{"A", "B", "C"})})).fetchCount());
    }

    @Test
    @NoBatooJPA
    public void not_in_empty() {
        long count = this.query().from(new EntityPath[]{cat}).fetchCount();
        Assert.assertEquals((long)count, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.notIn(Collections.emptyList())})).fetchCount());
    }

    @Test
    public void null_as_uniqueResult() {
        Assert.assertNull((Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Object)UUID.randomUUID().toString())})).select((Expression)cat).fetchFirst());
    }

    @Test
    @NoEclipseLink
    public void numeric() {
        QNumeric numeric = QNumeric.numeric;
        BigDecimal singleResult = (BigDecimal)this.query().from(new EntityPath[]{numeric}).select(numeric.value).fetchFirst();
        Assert.assertEquals((double)26.9, (double)singleResult.doubleValue(), (double)0.001);
    }

    @Test
    @NoOpenJPA
    @NoBatooJPA
    public void offset1() {
        List<String> names2 = Arrays.asList("Bob123", "Felix123", "Mary_123", "Ruth123", "Some");
        Assert.assertEquals(names2, (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.name.asc()})).offset(1L)).select((Expression)AbstractJPATest.cat.name).fetch());
    }

    @Test
    @NoOpenJPA
    @NoBatooJPA
    public void offset2() {
        List<String> names2 = Arrays.asList("Felix123", "Mary_123", "Ruth123", "Some");
        Assert.assertEquals(names2, (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.name.asc()})).offset(2L)).select((Expression)AbstractJPATest.cat.name).fetch());
    }

    @Test
    public void one_to_one() {
        QEmployee employee = QEmployee.employee;
        QUser user = QUser.user;
        JPQLQuery<?> query = this.query();
        query.from(new EntityPath[]{employee});
        query.innerJoin((EntityPath)employee.user, (Path)user);
        query.select((Expression)employee).fetch();
    }

    @Test
    public void order() {
        NumberPath weight = Expressions.numberPath(Double.class, (String)"weight");
        Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{weight.asc()})).select((Expression)AbstractJPATest.cat.bodyWeight.as((Path)weight)).fetch());
    }

    @Test
    public void order_by_count() {
        NumberPath count = Expressions.numberPath(Long.class, (String)"c");
        ((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{AbstractJPATest.cat.id})).orderBy(new OrderSpecifier[]{count.asc()})).select(new Expression[]{AbstractJPATest.cat.id, AbstractJPATest.cat.id.count().as((Path)count)}).fetch();
    }

    @Test
    public void order_stringValue() {
        int count = (int)this.query().from(new EntityPath[]{cat}).fetchCount();
        Assert.assertEquals((long)count, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.stringValue().asc()})).select((Expression)cat).fetch().size());
    }

    @Test
    @NoBatooJPA
    public void order_stringValue_to_integer() {
        int count = (int)this.query().from(new EntityPath[]{cat}).fetchCount();
        Assert.assertEquals((long)count, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.stringValue().castToNum(Integer.class).asc()})).select((Expression)cat).fetch().size());
    }

    @Test
    @NoBatooJPA
    public void order_stringValue_toLong() {
        int count = (int)this.query().from(new EntityPath[]{cat}).fetchCount();
        Assert.assertEquals((long)count, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.stringValue().castToNum(Long.class).asc()})).select((Expression)cat).fetch().size());
    }

    @Test
    @NoBatooJPA
    public void order_stringValue_toBigInteger() {
        int count = (int)this.query().from(new EntityPath[]{cat}).fetchCount();
        Assert.assertEquals((long)count, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.id.stringValue().castToNum(BigInteger.class).asc()})).select((Expression)cat).fetch().size());
    }

    @Test
    @NoBatooJPA
    @ExcludeIn(value={Target.SQLSERVER})
    public void order_nullsFirst() {
        Assert.assertNull((Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.dateField.asc().nullsFirst()})).select(AbstractJPATest.cat.dateField).fetchFirst());
    }

    @Test
    @NoBatooJPA
    @ExcludeIn(value={Target.SQLSERVER})
    public void order_nullsLast() {
        Assert.assertNotNull((Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).orderBy(new OrderSpecifier[]{AbstractJPATest.cat.dateField.asc().nullsLast()})).select(AbstractJPATest.cat.dateField).fetchFirst());
    }

    @Test
    public void params() {
        Param name = new Param(String.class, "name");
        Assert.assertEquals((Object)"Bob123", (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Expression)name)})).set((ParamExpression)name, (Object)"Bob123")).select((Expression)AbstractJPATest.cat.name).fetchFirst());
    }

    @Test
    public void params_anon() {
        Param name = new Param(String.class);
        Assert.assertEquals((Object)"Bob123", (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Expression)name)})).set((ParamExpression)name, (Object)"Bob123")).select((Expression)AbstractJPATest.cat.name).fetchFirst());
    }

    @Test(expected=ParamNotSetException.class)
    public void params_not_set() {
        Param name = new Param(String.class, "name");
        Assert.assertEquals((Object)"Bob123", (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Expression)name)})).select((Expression)AbstractJPATest.cat.name).fetchFirst());
    }

    @Test
    public void precedence() {
        StringPath str = AbstractJPATest.cat.name;
        BooleanExpression where = str.like("Bob%").and((Predicate)str.like("%ob123")).or((Predicate)str.like("Ruth%").and((Predicate)str.like("%uth123")));
        Assert.assertEquals((long)2L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{where})).fetchCount());
    }

    @Test
    public void precedence2() {
        StringPath str = AbstractJPATest.cat.name;
        BooleanExpression where = str.like("Bob%").and((Predicate)str.like("%ob123").or((Predicate)str.like("Ruth%"))).and((Predicate)str.like("%uth123"));
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{where})).fetchCount());
    }

    @Test
    public void precedence3() {
        BooleanExpression where = AbstractJPATest.cat.name.eq((Object)"Bob123").and((Predicate)AbstractJPATest.cat.id.eq((Object)1)).or((Predicate)AbstractJPATest.cat.name.eq((Object)"Ruth123").and((Predicate)AbstractJPATest.cat.id.eq((Object)2)));
        Assert.assertEquals((long)2L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{where})).fetchCount());
    }

    @Test
    public void factoryExpression_in_groupBy() {
        QBean catBean = Projections.bean(Cat.class, (Expression[])new Expression[]{AbstractJPATest.cat.id, AbstractJPATest.cat.name});
        Assert.assertFalse((boolean)((JPQLQuery)this.query().from(new EntityPath[]{cat}).groupBy(new Expression[]{catBean})).select((Expression)catBean).fetch().isEmpty());
    }

    @Test
    @Ignore
    public void size() {
        this.query().from(new EntityPath[]{cat}).select(new Expression[]{cat, AbstractJPATest.cat.kittens.size()}).fetch();
    }

    @Test
    public void startsWith() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.startsWith("R")})).fetchCount());
    }

    @Test
    public void startsWith_ignoreCase() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.startsWithIgnoreCase("r")})).fetchCount());
    }

    @Test
    public void startsWith2() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.startsWith("X")})).fetchCount());
    }

    @Test
    public void startsWith3() {
        Assert.assertEquals((long)1L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.startsWith("Mary_")})).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.MYSQL, Target.SQLSERVER, Target.TERADATA})
    @NoOpenJPA
    public void stringOperations() {
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.startsWith("r")})).fetchCount());
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.endsWith("H123")})).fetchCount());
        Assert.assertEquals((Object)2, (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Object)"Bob123")})).select((Expression)AbstractJPATest.cat.name.indexOf("b")).fetchFirst());
    }

    @Test
    public void subQuery() {
        QShow show = QShow.show;
        QShow show2 = new QShow("show2");
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{show}).where(new Predicate[]{((JPQLQuery)JPAExpressions.select((Expression)show2.count()).from(new EntityPath[]{show2}).where(new Predicate[]{show2.id.ne(show.id)})).gt((Object)0L)})).fetchCount());
    }

    @Test
    public void subQuery2() {
        QCat cat = QCat.cat;
        QCat other = new QCat("other");
        Assert.assertEquals(this.savedCats, (Object)((JPQLQuery)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{cat.name.in((SubQueryExpression)JPAExpressions.select((Expression)other.name).from(new EntityPath[]{other}).groupBy(new Expression[]{other.name}))})).orderBy(new OrderSpecifier[]{cat.id.asc()})).select((Expression)cat).fetch());
    }

    @Test
    public void subQuery3() {
        QCat cat = QCat.cat;
        QCat other = new QCat("other");
        Assert.assertEquals(this.savedCats.subList(0, 1), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{cat.name.eq((Expression)JPAExpressions.select((Expression)other.name).from(new EntityPath[]{other}).where(new Predicate[]{other.name.indexOf("B").eq((Object)0)}))})).select((Expression)cat).fetch());
    }

    @Test
    public void subQuery4() {
        QCat cat = QCat.cat;
        QCat other = new QCat("other");
        this.query().from(new EntityPath[]{cat}).select(new Expression[]{cat.name, (Expression)JPAExpressions.select((Expression)other.count()).from(new EntityPath[]{other}).where(new Predicate[]{other.name.eq((Expression)cat.name)})}).fetch();
    }

    @Test
    public void subQuery5() {
        QEmployee employee = QEmployee.employee;
        QEmployee employee2 = new QEmployee("e2");
        Assert.assertEquals((long)2L, (long)((JPQLQuery)this.query().from(new EntityPath[]{employee}).where(new Predicate[]{JPAExpressions.select((Expression)employee2.id.count()).from(new EntityPath[]{employee2}).gt((Object)1L)})).fetchCount());
    }

    @Test
    public void substring() {
        for (String str : this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.name.substring(1, 2)).fetch()) {
            Assert.assertEquals((long)1L, (long)str.length());
        }
    }

    @Test
    @NoBatooJPA
    @ExcludeIn(value={Target.ORACLE})
    public void substring2() {
        QCompany company = QCompany.company;
        StringPath name = company.name;
        Integer companyId = (Integer)this.query().from(new EntityPath[]{company}).select(company.id).fetchFirst();
        JPQLQuery query = (JPQLQuery)this.query().from(new EntityPath[]{company}).where(new Predicate[]{company.id.eq((Object)companyId)});
        String str = (String)query.select((Expression)company.name).fetchFirst();
        Assert.assertEquals((Object)29, (Object)query.select((Expression)name.length().subtract((Number)11)).fetchFirst());
        Assert.assertEquals((Object)str.substring(0, 7), (Object)query.select((Expression)name.substring(0, 7)).fetchFirst());
        Assert.assertEquals((Object)str.substring(15), (Object)query.select((Expression)name.substring(15)).fetchFirst());
        Assert.assertEquals((Object)str.substring(str.length()), (Object)query.select((Expression)name.substring((Expression)name.length())).fetchFirst());
        Assert.assertEquals((Object)str.substring(str.length() - 11), (Object)query.select((Expression)name.substring((Expression)name.length().subtract((Number)11))).fetchFirst());
    }

    @Test
    @Ignore
    @ExcludeIn(value={Target.DERBY})
    public void substring_from_right() {
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.substring(-1, 1).eq((Expression)AbstractJPATest.cat.name.substring(-2, 1))})).select((Expression)cat).fetch());
    }

    @Test
    @ExcludeIn(value={Target.HSQLDB, Target.DERBY})
    public void substring_from_right2() {
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.substring((Expression)AbstractJPATest.cat.name.length().subtract((Number)1), (Expression)AbstractJPATest.cat.name.length()).eq((Expression)AbstractJPATest.cat.name.substring((Expression)AbstractJPATest.cat.name.length().subtract((Number)2), (Expression)AbstractJPATest.cat.name.length().subtract((Number)1)))})).select((Expression)cat).fetch());
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void subtract_bigDecimal() {
        QSimpleTypes entity = new QSimpleTypes("entity1");
        QSimpleTypes entity2 = new QSimpleTypes("entity2");
        NumberPath<BigDecimal> bigd1 = entity.bigDecimal;
        NumberPath<BigDecimal> bigd2 = entity2.bigDecimal;
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{entity, entity2}).where(new Predicate[]{bigd1.subtract(bigd2).loe((Number)new BigDecimal("1.00"))})).select((Expression)entity).fetch());
    }

    @Test
    @Ignore
    public void sum() {
        this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.kittens.size().sum()).fetch();
    }

    @Test
    @Ignore
    public void sum_2() {
        ((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.kittens.size().sum().gt((Number)0)})).select((Expression)cat).fetch();
    }

    @Test
    public void sum_3() {
        Assert.assertEquals((double)21.0, (double)((Double)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.bodyWeight.sum()).fetchFirst()), (double)1.0E-4);
    }

    @Test
    public void sum_3_projected() {
        double val = (Double)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.bodyWeight.sum()).fetchFirst();
        DoubleProjection projection = (DoubleProjection)this.query().from(new EntityPath[]{cat}).select((Expression)new QDoubleProjection((Expression<Double>)AbstractJPATest.cat.bodyWeight.sum())).fetchFirst();
        Assert.assertEquals((double)val, (double)projection.val, (double)0.001);
    }

    @Test
    public void sum_4() {
        Double dbl = (Double)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.bodyWeight.sum().negate()).fetchFirst();
        Assert.assertNotNull((Object)dbl);
    }

    @Test
    public void sum_5() {
        QShow show = QShow.show;
        Long lng = (Long)this.query().from(new EntityPath[]{show}).select((Expression)show.id.sum()).fetchFirst();
        Assert.assertNotNull((Object)lng);
    }

    @Test
    public void sum_of_integer() {
        QCat cat2 = new QCat("cat2");
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((JPQLQuery)JPAExpressions.select((Expression)cat2.breed.sum()).from(new EntityPath[]{cat2}).where(new Predicate[]{cat2.eq((Expression)AbstractJPATest.cat.mate)})).gt((Object)0)})).select((Expression)cat).fetch());
    }

    @Test
    public void sum_of_float() {
        QCat cat2 = new QCat("cat2");
        ((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((JPQLQuery)JPAExpressions.select((Expression)cat2.floatProperty.sum()).from(new EntityPath[]{cat2}).where(new Predicate[]{cat2.eq((Expression)AbstractJPATest.cat.mate)})).gt((Object)Float.valueOf(0.0f))})).select((Expression)cat).fetch();
    }

    @Test
    public void sum_of_double() {
        QCat cat2 = new QCat("cat2");
        ((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{((JPQLQuery)JPAExpressions.select((Expression)cat2.bodyWeight.sum()).from(new EntityPath[]{cat2}).where(new Predicate[]{cat2.eq((Expression)AbstractJPATest.cat.mate)})).gt((Object)0.0)})).select((Expression)cat).fetch();
    }

    @Test
    public void sum_as_float() {
        float val = ((Float)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.floatProperty.sum()).fetchFirst()).floatValue();
        Assert.assertTrue((val > 0.0f ? 1 : 0) != 0);
    }

    @Test
    public void sum_as_float_projected() {
        float val = ((Float)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.floatProperty.sum()).fetchFirst()).floatValue();
        FloatProjection projection = (FloatProjection)this.query().from(new EntityPath[]{cat}).select((Expression)new QFloatProjection((Expression<Float>)AbstractJPATest.cat.floatProperty.sum())).fetchFirst();
        Assert.assertEquals((double)val, (double)projection.val, (double)0.001);
    }

    @Test
    public void sum_as_float2() {
        float val = ((Float)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.floatProperty.sum().negate()).fetchFirst()).floatValue();
        Assert.assertTrue((val < 0.0f ? 1 : 0) != 0);
    }

    @Test
    public void sum_coalesce() {
        int val = (Integer)this.query().from(new EntityPath[]{cat}).select((Expression)AbstractJPATest.cat.weight.sum().coalesce((Comparable[])new Integer[]{0})).fetchFirst();
        Assert.assertEquals((long)0L, (long)val);
    }

    @Test
    public void sum_noRows_double() {
        Assert.assertNull((Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Object)UUID.randomUUID().toString())})).select((Expression)AbstractJPATest.cat.bodyWeight.sum()).fetchFirst());
    }

    @Test
    public void sum_noRows_float() {
        Assert.assertNull((Object)((JPQLQuery)this.query().from(new EntityPath[]{cat}).where(new Predicate[]{AbstractJPATest.cat.name.eq((Object)UUID.randomUUID().toString())})).select((Expression)AbstractJPATest.cat.floatProperty.sum()).fetchFirst());
    }

    @Test
    @NoEclipseLink
    @NoOpenJPA
    @NoBatooJPA
    public void test() {
        Cat kitten = this.savedCats.get(0);
        Cat noKitten = this.savedCats.get(this.savedCats.size() - 1);
        ProjectionsFactory projections = new ProjectionsFactory(Module.JPA, this.getTarget()){

            public <A, Q extends SimpleExpression<A>> Collection<Expression<?>> list(ListPath<A, Q> expr, ListExpression<A, Q> other, A knownElement) {
                return Collections.singleton(expr.size());
            }
        };
        final EntityPath[] sources = new EntityPath[]{cat, otherCat};
        final Predicate[] conditions = new Predicate[]{condition};
        final Expression[] projection = new Expression[]{AbstractJPATest.cat.name, AbstractJPATest.otherCat.name};
        QueryExecution standardTest = new QueryExecution(projections, new FilterFactory(projections, Module.JPA, this.getTarget()), new MatchingFiltersFactory(Module.JPA, this.getTarget())){

            protected Fetchable<?> createQuery() {
                return (Fetchable)AbstractJPATest.this.testQuery().from(sources).where(conditions);
            }

            protected Fetchable<?> createQuery(Predicate filter) {
                return ((JPQLQuery)AbstractJPATest.this.testQuery().from(sources).where(new Predicate[]{condition, filter})).select(projection);
            }
        };
        standardTest.runBooleanTests(AbstractJPATest.cat.name.isNull(), AbstractJPATest.otherCat.kittens.isEmpty());
        standardTest.runCollectionTests(AbstractJPATest.cat.kittens, AbstractJPATest.otherCat.kittens, (Object)kitten, (Object)noKitten);
        standardTest.runDateTests(AbstractJPATest.cat.dateField, AbstractJPATest.otherCat.dateField, date);
        standardTest.runDateTimeTests(AbstractJPATest.cat.birthdate, AbstractJPATest.otherCat.birthdate, birthDate);
        standardTest.runListTests(AbstractJPATest.cat.kittens, AbstractJPATest.otherCat.kittens, (Object)kitten, (Object)noKitten);
        standardTest.runNumericCasts(AbstractJPATest.cat.id, AbstractJPATest.otherCat.id, (Number)1);
        standardTest.runNumericTests(AbstractJPATest.cat.id, AbstractJPATest.otherCat.id, (Number)1);
        standardTest.runNumericCasts(AbstractJPATest.cat.bodyWeight, AbstractJPATest.otherCat.bodyWeight, (Number)1.0);
        standardTest.runNumericTests(AbstractJPATest.cat.bodyWeight, AbstractJPATest.otherCat.bodyWeight, (Number)1.0);
        standardTest.runStringTests((StringExpression)AbstractJPATest.cat.name, (StringExpression)AbstractJPATest.otherCat.name, kitten.getName());
        standardTest.runTimeTests(AbstractJPATest.cat.timeField, AbstractJPATest.otherCat.timeField, time);
        standardTest.report();
    }

    @Test
    public void tupleProjection() {
        List tuples = this.query().from(new EntityPath[]{cat}).select(new Expression[]{AbstractJPATest.cat.name, cat}).fetch();
        Assert.assertFalse((boolean)tuples.isEmpty());
        for (Tuple tuple : tuples) {
            Assert.assertNotNull((Object)tuple.get((Expression)AbstractJPATest.cat.name));
            Assert.assertNotNull((Object)tuple.get((Expression)cat));
        }
    }

    @Test
    public void tupleProjection_as_queryResults() {
        QueryResults tuples = ((JPQLQuery)this.query().from(new EntityPath[]{cat}).limit(1L)).select(new Expression[]{AbstractJPATest.cat.name, cat}).fetchResults();
        Assert.assertEquals((long)1L, (long)tuples.getResults().size());
        Assert.assertTrue((tuples.getTotal() > 0L ? 1 : 0) != 0);
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void transform_groupBy() {
        QCat kitten = new QCat("kitten");
        Map result = (Map)this.query().from(new EntityPath[]{cat}).innerJoin(AbstractJPATest.cat.kittens, (Path)kitten).transform(GroupBy.groupBy(AbstractJPATest.cat.id).as((FactoryExpression)Projections.constructor(Cat.class, (Expression[])new Expression[]{AbstractJPATest.cat.name, AbstractJPATest.cat.id, GroupBy.list((Expression)Projections.constructor(Cat.class, (Expression[])new Expression[]{kitten.name, kitten.id}))})));
        for (Cat entry : result.values()) {
            Assert.assertEquals((long)1L, (long)entry.getKittens().size());
        }
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void transform_groupBy2() {
        QCat kitten = new QCat("kitten");
        Map result = (Map)this.query().from(new EntityPath[]{cat}).innerJoin(AbstractJPATest.cat.kittens, (Path)kitten).transform(GroupBy.groupBy((Expression[])new Expression[]{AbstractJPATest.cat.id, kitten.id}).as(new Expression[]{cat, kitten}));
        Assert.assertFalse((boolean)result.isEmpty());
        for (Tuple row : this.query().from(new EntityPath[]{cat}).innerJoin(AbstractJPATest.cat.kittens, (Path)kitten).select(new Expression[]{cat, kitten}).fetch()) {
            Assert.assertNotNull(result.get(Arrays.asList(((Cat)row.get((Expression)cat)).getId(), ((Cat)row.get((Expression)kitten)).getId())));
        }
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void transform_groupBy_alias() {
        QCat kitten = new QCat("kitten");
        SimplePath k = Expressions.path(Cat.class, (String)"k");
        Map result = (Map)this.query().from(new EntityPath[]{cat}).innerJoin(AbstractJPATest.cat.kittens, (Path)kitten).transform(GroupBy.groupBy(AbstractJPATest.cat.id).as(new Expression[]{AbstractJPATest.cat.name, AbstractJPATest.cat.id, GroupBy.list((Expression)Projections.constructor(Cat.class, (Expression[])new Expression[]{kitten.name, kitten.id}).as((Path)k))}));
        for (Group entry : result.values()) {
            Assert.assertNotNull((Object)entry.getOne(AbstractJPATest.cat.id));
            Assert.assertNotNull((Object)entry.getOne((Expression)AbstractJPATest.cat.name));
            Assert.assertFalse((boolean)entry.getList((Expression)k).isEmpty());
        }
    }

    @Test
    @NoBatooJPA
    public void treat() {
        QDomesticCat domesticCat = QDomesticCat.domesticCat;
        Assert.assertEquals((long)0L, (long)((JPQLQuery)this.query().from(new EntityPath[]{cat}).innerJoin((EntityPath)AbstractJPATest.cat.mate, (Path)domesticCat._super).where(new Predicate[]{domesticCat.name.eq((Object)"Bobby")})).fetchCount());
    }

    @Test
    @Ignore
    public void type() {
        Assert.assertEquals(Arrays.asList("C", "C", "C", "C", "C", "C", "A"), (Object)((JPQLQuery)this.query().from(new EntityPath[]{animal}).orderBy(new OrderSpecifier[]{AbstractJPATest.animal.id.asc()})).select((Expression)JPAExpressions.type((EntityPath)animal)).fetch());
    }

    @Test
    @NoOpenJPA
    public void type_order() {
        Assert.assertEquals(Arrays.asList(10, 1, 2, 3, 4, 5, 6), (Object)((JPQLQuery)this.query().from(new EntityPath[]{animal}).orderBy(new OrderSpecifier[]{JPAExpressions.type((EntityPath)animal).asc(), AbstractJPATest.animal.id.asc()})).select(AbstractJPATest.animal.id).fetch());
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void byte_array() {
        QSimpleTypes simpleTypes = QSimpleTypes.simpleTypes;
        Assert.assertEquals((Object)ImmutableList.of(), (Object)((JPQLQuery)this.query().from(new EntityPath[]{simpleTypes}).where(new Predicate[]{simpleTypes.byteArray.eq((Object)new byte[]{0, 1})})).select((Expression)simpleTypes).fetch());
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 1, 2, 3, 4);
        cal.set(13, 0);
        cal.set(14, 0);
        birthDate = cal.getTime();
        date = new java.sql.Date(cal.getTimeInMillis());
        time = new Time(cal.getTimeInMillis());
    }
}

