/*
 * Copyright © 2013. Palomino Labs (http://palominolabs.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UpsertResultType;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class UpsertResult extends AbstractCallResult {

    private final boolean created;

    UpsertResult(UpsertResultType stubResult) {
        super(stubResult.getId(), stubResult.isSuccess(), stubResult.getErrors());
        this.created = stubResult.isCreated();
    }

    public boolean isCreated() {
        return this.created;
    }
}
