/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.strategy;

import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.query.OSpatialQueryContext;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderAbstract;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class SpatialQueryBuilderNear
extends SpatialQueryBuilderAbstract {
    public static final String NAME = "near";

    public SpatialQueryBuilderNear(OLuceneSpatialIndexContainer manager, OShapeBuilder factory) {
        super(manager, factory);
    }

    @Override
    public OSpatialQueryContext build(Map<String, Object> query) throws Exception {
        Shape shape = this.parseShape(query);
        double distance = Optional.ofNullable(query.get("maxDistance")).map(Number.class::cast).map(n -> n.doubleValue()).orElse(0.0);
        Point p = (Point)shape;
        SpatialArgs args = new SpatialArgs(SpatialOperation.Intersects, (Shape)this.factory.context().makeCircle(p.getX(), p.getY(), DistanceUtils.dist2Degrees((double)distance, (double)6371.0087714)));
        Query filterQuery = this.manager.strategy().makeQuery(args);
        DoubleValuesSource valueSource = this.manager.strategy().makeDistanceValueSource(p);
        IndexSearcher searcher = this.manager.searcher();
        Sort distSort = new Sort(valueSource.getSortField(false)).rewrite(searcher);
        BooleanQuery q = new BooleanQuery.Builder().add(filterQuery, BooleanClause.Occur.MUST).add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD).build();
        return new OSpatialQueryContext(null, searcher, (Query)q, Arrays.asList(distSort.getSort())).setSpatialArgs(args);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

