/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.strategy;

import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.query.OSpatialQueryContext;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import java.util.Map;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.locationtech.spatial4j.shape.Shape;

public abstract class SpatialQueryBuilderAbstract {
    public static final String GEO_FILTER = "geo_filter";
    public static final String SHAPE = "shape";
    public static final String SHAPE_TYPE = "type";
    public static final String COORDINATES = "coordinates";
    public static final String MAX_DISTANCE = "maxDistance";
    protected OLuceneSpatialIndexContainer manager;
    protected OShapeBuilder factory;

    public SpatialQueryBuilderAbstract(OLuceneSpatialIndexContainer manager, OShapeBuilder factory) {
        this.manager = manager;
        this.factory = factory;
    }

    public abstract OSpatialQueryContext build(Map<String, Object> var1) throws Exception;

    protected Shape parseShape(Map<String, Object> query) {
        Object geometry = query.get(SHAPE);
        if (geometry == null) {
            throw new OIndexEngineException("Invalid spatial query. Missing shape field " + query, null);
        }
        return this.factory.fromObject(geometry);
    }

    protected boolean isOnlyBB(SpatialStrategy spatialStrategy) {
        return spatialStrategy instanceof BBoxStrategy;
    }

    public abstract String getName();
}

