/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class OMultiPointShapeBuilder
extends OComplexShapeBuilder<JtsGeometry> {
    @Override
    public String getName() {
        return "OMultiPoint";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.MULTIPOINT;
    }

    @Override
    public JtsGeometry fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        Coordinate[] coords = new Coordinate[coordinates.size()];
        int i = 0;
        for (List coordinate : coordinates) {
            coords[i] = new Coordinate(((Number)coordinate.get(0)).doubleValue(), ((Number)coordinate.get(1)).doubleValue());
            ++i;
        }
        return this.toShape((Geometry)GEOMETRY_FACTORY.createMultiPoint(coords));
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass multiPoint = schema.createAbstractClass(this.getName(), this.superClass(db));
        multiPoint.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
    }

    @Override
    public ODocument toDoc(JtsGeometry shape) {
        final MultiPoint geom = (MultiPoint)shape.getGeom();
        ODocument doc = new ODocument(this.getName());
        doc.field("coordinates", (Object)new ArrayList<List<Double>>(){
            {
                Coordinate[] coordinates;
                for (Coordinate coordinate : coordinates = geom.getCoordinates()) {
                    this.add(Arrays.asList(coordinate.x, coordinate.y));
                }
            }
        });
        return doc;
    }
}

