/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.engine;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.spatial.engine.OLuceneGeoSpatialIndexEngine;
import com.orientechnologies.spatial.engine.OLuceneLegacySpatialIndexEngine;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexEngineAbstract;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.spatial.SpatialStrategy;

public class OLuceneSpatialIndexEngineDelegator
implements OLuceneIndexEngine,
OLuceneSpatialIndexContainer {
    private final Boolean durableInNonTxMode;
    private final OStorage storage;
    private final int version;
    private final String indexName;
    private OLuceneSpatialIndexEngineAbstract delegate;

    public OLuceneSpatialIndexEngineDelegator(String name, Boolean durableInNonTxMode, OStorage storage, int version) {
        this.indexName = name;
        this.durableInNonTxMode = durableInNonTxMode;
        this.storage = storage;
        this.version = version;
    }

    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        if (this.delegate == null) {
            if (OClass.INDEX_TYPE.SPATIAL.name().equalsIgnoreCase(indexType)) {
                this.delegate = indexDefinition.getFields().size() > 1 ? new OLuceneLegacySpatialIndexEngine(this.storage, indexName, OShapeFactory.INSTANCE) : new OLuceneGeoSpatialIndexEngine(this.storage, indexName, OShapeFactory.INSTANCE);
            }
            this.delegate.init(indexName, indexType, indexDefinition, isAutomatic, metadata);
        }
    }

    public void flush() {
        this.delegate.flush();
    }

    public void create(OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Set<String> clustersToIndex, Map<String, String> engineProperties, ODocument metadata, OEncryption encryption) {
    }

    public void delete() {
        if (this.delegate != null) {
            this.delegate.delete();
        }
    }

    public void deleteWithoutLoad(String indexName) {
        if (this.delegate != null) {
            this.delegate.deleteWithoutLoad(indexName);
        }
    }

    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        if (this.delegate != null) {
            this.delegate.load(indexName, valueSerializer, isAutomatic, keySerializer, keyTypes, nullPointerSupport, keySize, engineProperties, encryption);
        }
    }

    public boolean contains(Object key) {
        return this.delegate.contains(key);
    }

    public boolean remove(Object key) {
        return this.delegate.remove(key);
    }

    public void clear() {
        this.delegate.clear();
    }

    public void close() {
        this.delegate.close();
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public void put(Object key, Object value) {
        this.delegate.put(key, value);
    }

    public void update(Object key, OIndexKeyUpdater<Object> updater) {
        this.delegate.update(key, updater);
    }

    public boolean validatedPut(Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) {
        return this.delegate.validatedPut(key, value, validator);
    }

    public Object getFirstKey() {
        return this.delegate.getFirstKey();
    }

    public Object getLastKey() {
        return this.delegate.getFirstKey();
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return this.delegate.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return this.delegate.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder, transformer);
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return this.delegate.iterateEntriesMinor(toKey, isInclusive, ascSortOrder, transformer);
    }

    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        return this.delegate.cursor(valuesTransformer);
    }

    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        return this.delegate.descCursor(valuesTransformer);
    }

    public OIndexKeyCursor keyCursor() {
        return this.delegate.keyCursor();
    }

    public long size(OIndexEngine.ValuesTransformer transformer) {
        return this.delegate.size(transformer);
    }

    public boolean hasRangeQuerySupport() {
        return this.delegate.hasRangeQuerySupport();
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String indexName() {
        return this.indexName;
    }

    @Override
    public void onRecordAddedToResultSet(OLuceneQueryContext queryContext, OContextualRecordId recordId, Document ret, ScoreDoc score) {
        this.delegate.onRecordAddedToResultSet(queryContext, recordId, ret, score);
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        return this.delegate.buildDocument(key, value);
    }

    @Override
    public Query buildQuery(Object query) {
        return this.delegate.buildQuery(query);
    }

    @Override
    public Analyzer indexAnalyzer() {
        return this.delegate.indexAnalyzer();
    }

    @Override
    public Analyzer queryAnalyzer() {
        return this.delegate.queryAnalyzer();
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public IndexSearcher searcher() {
        return this.delegate.searcher();
    }

    @Override
    public void release(IndexSearcher searcher) {
        this.delegate.release(searcher);
    }

    @Override
    public SpatialStrategy strategy() {
        return this.delegate.strategy();
    }

    @Override
    public boolean isLegacy() {
        return this.delegate.isLegacy();
    }

    @Override
    public Set<OIdentifiable> getInTx(Object key, OLuceneTxChanges changes) {
        return this.delegate.getInTx(key, changes);
    }

    @Override
    public long sizeInTx(OLuceneTxChanges changes) {
        return this.delegate.sizeInTx(changes);
    }

    @Override
    public OLuceneTxChanges buildTxChanges() throws IOException {
        return this.delegate.buildTxChanges();
    }

    @Override
    public Query deleteQuery(Object key, OIdentifiable value) {
        return this.delegate.deleteQuery(key, value);
    }

    @Override
    public boolean isCollectionIndex() {
        return this.delegate.isCollectionIndex();
    }

    public void freeze(boolean throwException) {
        this.delegate.freeze(throwException);
    }

    public void release() {
        this.delegate.release();
    }

    public boolean isFrozen() {
        return this.delegate.isFrozen();
    }

    public boolean acquireAtomicExclusiveLock(Object key) {
        return true;
    }

    public String getIndexNameByKey(Object key) {
        return this.delegate.getIndexNameByKey(key);
    }

    public OLuceneIndexEngine getDelegate() {
        return this.delegate;
    }
}

