/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.spatial.OLuceneMockSpatialSerializer;
import com.orientechnologies.spatial.OLuceneSpatialManager;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexEngineDelegator;
import com.orientechnologies.spatial.index.OLuceneSpatialIndex;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class OLuceneSpatialIndexFactory
implements OIndexFactory,
ODatabaseLifecycleListener {
    private static final Set<String> TYPES;
    private static final Set<String> ALGORITHMS;
    private final OLuceneSpatialManager spatialManager;

    public OLuceneSpatialIndexFactory() {
        this(false);
    }

    public OLuceneSpatialIndexFactory(boolean manual) {
        if (!manual) {
            Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
        this.spatialManager = new OLuceneSpatialManager(OShapeFactory.INSTANCE);
    }

    public int getLastVersion() {
        return 0;
    }

    public Set<String> getTypes() {
        return TYPES;
    }

    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    public OIndexInternal<?> createIndex(String name, OStorage storage, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        OAbstractPaginatedStorage pagStorage = (OAbstractPaginatedStorage)storage.getUnderlying();
        OBinarySerializer objectSerializer = storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer(OLuceneMockSpatialSerializer.INSTANCE.getId());
        if (objectSerializer == null) {
            storage.getComponentsFactory().binarySerializerFactory.registerSerializer((OBinarySerializer)OLuceneMockSpatialSerializer.INSTANCE, OType.EMBEDDED);
        }
        if (metadata == null) {
            metadata = new ODocument().field("analyzer", (Object)StandardAnalyzer.class.getName());
        }
        if (OClass.INDEX_TYPE.SPATIAL.toString().equals(indexType)) {
            return new OLuceneSpatialIndex(name, indexType, "LUCENE", version, pagStorage, valueContainerAlgorithm, metadata);
        }
        throw new OConfigurationException("Unsupported type : " + algorithm);
    }

    public OIndexEngine createIndexEngine(String algorithm, String name, Boolean durableInNonTxMode, OStorage storage, int version, Map<String, String> engineProperties) {
        return new OLuceneSpatialIndexEngineDelegator(name, durableInNonTxMode, storage, version);
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.REGULAR;
    }

    public void onCreate(ODatabaseInternal iDatabase) {
        this.spatialManager.init(iDatabase);
    }

    public void onOpen(ODatabaseInternal iDatabase) {
    }

    public void onClose(ODatabaseInternal iDatabase) {
    }

    public void onDrop(ODatabaseInternal db) {
        try {
            if (db.isClosed()) {
                return;
            }
            OLogManager.instance().debug((Object)this, "Dropping spatial indexes...", new Object[0]);
            for (OIndex idx : db.getMetadata().getIndexManager().getIndexes()) {
                if (!(idx.getInternal() instanceof OLuceneSpatialIndex)) continue;
                OLogManager.instance().debug((Object)this, "- index '%s'", new Object[]{idx.getName()});
                idx.delete();
            }
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Error on dropping spatial indexes", (Throwable)e, new Object[0]);
        }
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.SPATIAL.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add("LUCENE");
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

