/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.object.db.OCommandSQLPojoWrapper;
import com.orientechnologies.orient.object.db.OObjectNotDetachedException;
import com.orientechnologies.orient.object.db.OObjectNotManagedException;
import com.orientechnologies.orient.object.dictionary.ODictionaryWrapper;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectMethodFilter;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.entity.OObjectEntityClassHandler;
import com.orientechnologies.orient.object.iterator.OObjectIteratorClass;
import com.orientechnologies.orient.object.iterator.OObjectIteratorCluster;
import com.orientechnologies.orient.object.metadata.OMetadataObject;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

public class OObjectDatabaseTx
extends ODatabaseWrapperAbstract<ODatabaseDocumentInternal, Object>
implements ODatabaseObject {
    public static final String TYPE = "object";
    protected ODictionary<Object> dictionary;
    protected OEntityManager entityManager;
    protected boolean saveOnlyDirty;
    protected boolean lazyLoading;
    protected boolean automaticSchemaGeneration;
    protected OMetadataObject metadata;

    public OObjectDatabaseTx(String iURL) {
        super((ODatabaseInternal)new ODatabaseDocumentTx(iURL));
        ((ODatabaseDocumentInternal)this.underlying).setDatabaseOwner((ODatabaseInternal)this);
        this.init();
    }

    public OObjectDatabaseTx(ODatabaseDocumentInternal iDatabase) {
        super((ODatabaseInternal)iDatabase);
        ((ODatabaseDocumentInternal)this.underlying).setDatabaseOwner((ODatabaseInternal)this);
        this.init();
    }

    @Override
    public <T> T newInstance(Class<T> iType) {
        return (T)this.newInstance(iType.getSimpleName(), null, OCommonConst.EMPTY_OBJECT_ARRAY);
    }

    public <T> T newInstance(Class<T> iType, Object ... iArgs) {
        return (T)this.newInstance(iType.getSimpleName(), null, iArgs);
    }

    @Override
    public <RET> RET newInstance(String iClassName) {
        return this.newInstance(iClassName, null, OCommonConst.EMPTY_OBJECT_ARRAY);
    }

    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        super.open(iUserName, iUserPassword);
        this.saveOnlyDirty = this.getConfiguration().getValueAsBoolean(OGlobalConfiguration.OBJECT_SAVE_ONLY_DIRTY);
        this.entityManager.registerEntityClass(OUser.class);
        this.entityManager.registerEntityClass(ORole.class);
        this.metadata = new OMetadataObject(((ODatabaseDocumentInternal)this.underlying).getMetadata());
        this.registerFieldMappingStrategy();
        return (THISDB)this;
    }

    public <THISDB extends ODatabase> THISDB open(OToken iToken) {
        super.open(iToken);
        this.entityManager.registerEntityClass(OUser.class);
        this.entityManager.registerEntityClass(ORole.class);
        this.metadata = new OMetadataObject(((ODatabaseDocumentInternal)this.underlying).getMetadata());
        this.registerFieldMappingStrategy();
        return (THISDB)this;
    }

    public OSecurityUser getUser() {
        return ((ODatabaseDocumentInternal)this.underlying).getUser();
    }

    public void setUser(OSecurityUser user) {
        ((ODatabaseDocumentInternal)this.underlying).setUser(user);
    }

    @Override
    public OMetadataObject getMetadata() {
        this.checkOpenness();
        if (this.metadata == null) {
            this.metadata = new OMetadataObject(((ODatabaseDocumentInternal)this.underlying).getMetadata());
        }
        return this.metadata;
    }

    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        ((ODatabaseDocumentInternal)this.underlying).setInternal(attribute, iValue);
    }

    public Iterable<ODatabaseListener> getListeners() {
        return ((ODatabaseDocumentInternal)this.underlying).getListeners();
    }

    public <DBTYPE extends ODatabase<?>> DBTYPE registerHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentInternal)this.underlying).registerHook(iHookImpl);
        return (DBTYPE)this;
    }

    public <DBTYPE extends ODatabase<?>> DBTYPE registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        ((ODatabaseDocumentInternal)this.underlying).registerHook(iHookImpl, iPosition);
        return (DBTYPE)this;
    }

    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE iType, OIdentifiable iObject) {
        return ((ODatabaseDocumentInternal)this.underlying).callbackHooks(iType, iObject);
    }

    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        return ((ODatabaseDocumentInternal)this.underlying).getHooks();
    }

    public <DBTYPE extends ODatabase<?>> DBTYPE unregisterHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentInternal)this.underlying).unregisterHook(iHookImpl);
        return (DBTYPE)this;
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, Object ... iArgs) {
        ((ODatabaseDocumentInternal)this.underlying).checkIfActive();
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Class<?> entityClass = this.entityManager.getEntityClass(iClassName);
            if (entityClass != null) {
                Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, (ODocument)((ODatabaseDocumentInternal)this.underlying).newInstance(iClassName), null, iArgs);
                return (RET)enhanced;
            }
            throw new OSerializationException("Type " + iClassName + " cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        catch (Exception e) {
            String message = "Error on creating object of class " + iClassName;
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new ODatabaseException(message), (Throwable)e);
        }
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, ODocument iDocument, Object ... iArgs) {
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Class<?> entityClass = this.entityManager.getEntityClass(iClassName);
            if (entityClass != null) {
                Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, iDocument, null, iArgs);
                return (RET)enhanced;
            }
            throw new OSerializationException("Type " + iClassName + " cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        catch (Exception e) {
            String message = "Error on creating object of class " + iClassName;
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new ODatabaseException(message), (Throwable)e);
        }
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass) {
        return this.browseClass(iClusterClass, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass, boolean iPolymorphic) {
        if (iClusterClass == null) {
            return null;
        }
        return this.browseClass(iClusterClass.getSimpleName(), iPolymorphic);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName, boolean iPolymorphic) {
        this.checkOpenness();
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iClassName);
        return new OObjectIteratorClass(this, this.getUnderlying(), iClassName, iPolymorphic);
    }

    public <RET> OObjectIteratorCluster<RET> browseCluster(String iClusterName) {
        this.checkOpenness();
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new OObjectIteratorCluster(this, this.getUnderlying(), this.getClusterIdByName(iClusterName));
    }

    public <RET> RET load(Object iPojo) {
        return this.load(iPojo, null);
    }

    public <RET> RET reload(Object iPojo) {
        return this.reload(iPojo, null, true);
    }

    public <RET> RET reload(Object iPojo, boolean iIgnoreCache) {
        return this.reload(iPojo, null, iIgnoreCache);
    }

    public <RET> RET reload(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        return this.reload(iPojo, iFetchPlan, iIgnoreCache, true);
    }

    public <RET> RET reload(Object iObject, String iFetchPlan, boolean iIgnoreCache, boolean force) {
        this.checkOpenness();
        if (iObject == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iObject, true);
        ((ODatabaseDocumentInternal)this.underlying).reload((Object)record, iFetchPlan, iIgnoreCache, force);
        iObject = this.stream2pojo(record, iObject, iFetchPlan, true);
        return (RET)iObject;
    }

    public <RET> RET load(Object iPojo, String iFetchPlan) {
        return this.load(iPojo, iFetchPlan, false);
    }

    public void attach(Object iPojo) {
        OObjectEntitySerializer.attach(iPojo, this);
    }

    public <RET> RET attachAndSave(Object iPojo) {
        this.attach(iPojo);
        return this.save(iPojo);
    }

    @Override
    public <RET> RET detach(Object iPojo) {
        return (RET)OObjectEntitySerializer.detach(iPojo, this);
    }

    @Override
    public <RET> RET detach(Object iPojo, boolean returnNonProxiedInstance) {
        return (RET)OObjectEntitySerializer.detach(iPojo, this, returnNonProxiedInstance);
    }

    @Override
    public <RET> RET detachAll(Object iPojo, boolean returnNonProxiedInstance) {
        return this.detachAll(iPojo, returnNonProxiedInstance, new HashMap<Object, Object>(), new HashMap<Object, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpenness();
        if (iPojo == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            record = (ODocument)((ODatabaseDocumentInternal)this.underlying).load((Object)record, iFetchPlan, iIgnoreCache);
            Object object = this.stream2pojo(record, iPojo, iFetchPlan);
            return (RET)object;
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    public <RET> RET lock(ORID recordId) throws OLockException {
        this.checkOpenness();
        if (recordId == null) {
            return null;
        }
        ODocument record = (ODocument)((ODatabaseDocumentInternal)this.underlying).lock(recordId);
        if (record == null) {
            return null;
        }
        return (RET)OObjectEntityEnhancer.getInstance().getProxiedInstance(record.getClassName(), this.entityManager, record, null, new Object[0]);
    }

    public <RET> RET lock(ORID recordId, long timeout, TimeUnit timeoutUnit) throws OLockException {
        this.checkOpenness();
        if (recordId == null) {
            return null;
        }
        ODocument record = (ODocument)((ODatabaseDocumentInternal)this.underlying).lock(recordId, timeout, timeoutUnit);
        if (record == null) {
            return null;
        }
        return (RET)OObjectEntityEnhancer.getInstance().getProxiedInstance(record.getClassName(), this.entityManager, record, null, new Object[0]);
    }

    public void unlock(ORID recordId) throws OLockException {
        this.checkOpenness();
        ((ODatabaseDocumentInternal)this.underlying).unlock(recordId);
    }

    public <RET> RET load(ORID recordId) {
        return this.load(recordId, (String)null);
    }

    public <RET> RET load(ORID iRecordId, String iFetchPlan) {
        return this.load(iRecordId, iFetchPlan, false);
    }

    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpenness();
        if (iRecordId == null) {
            return null;
        }
        ODocument record = (ODocument)((ODatabaseDocumentInternal)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache);
        if (record == null) {
            return null;
        }
        return (RET)OObjectEntityEnhancer.getInstance().getProxiedInstance(record.getClassName(), this.entityManager, record, null, new Object[0]);
    }

    public <RET> RET save(Object iContent) {
        return this.save(iContent, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    public <RET> RET save(Object iContent, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        return this.save(iContent, null, iMode, false, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    public <RET> RET save(Object iPojo, String iClusterName) {
        return this.save(iPojo, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET> RET save(Object iPojo, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.checkOpenness();
        if (iPojo == null) {
            return (RET)iPojo;
        }
        if (OMultiValue.isMultiValue((Object)iPojo)) {
            for (Object pojo : OMultiValue.getMultiValueIterable((Object)iPojo)) {
                this.save(pojo, iClusterName);
            }
            return (RET)iPojo;
        }
        ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        Object proxiedObject = OObjectEntitySerializer.serializeObject(iPojo, this);
        ODocument record = this.getRecordByUserObject(proxiedObject, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
            if (!this.saveOnlyDirty || record.isDirty()) {
                this.deleteOrphans((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler());
                ODocument savedRecord = (ODocument)((ODatabaseDocumentInternal)this.underlying).save((Object)record, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).setDoc(savedRecord);
                ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).updateLoadedFieldMap(proxiedObject, false);
                this.registerUserObject(proxiedObject, (ORecord)record);
            }
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return (RET)proxiedObject;
    }

    public ODatabaseObject delete(Object iPojo) {
        this.checkOpenness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid == null) {
                throw new OObjectNotDetachedException("Cannot retrieve the object's ID for '" + iPojo + "' because has not been detached");
            }
            record = (ODocument)((ODatabaseDocumentInternal)this.underlying).load((ORID)rid);
        }
        this.deleteCascade(record);
        ((ODatabaseDocumentInternal)this.underlying).delete((Object)record);
        if (this.getTransaction() instanceof OTransactionNoTx) {
            this.unregisterPojo(iPojo, record);
        }
        return this;
    }

    public ODatabaseObject delete(ORID iRID) {
        this.checkOpenness();
        if (iRID == null) {
            return this;
        }
        ORecord record = iRID.getRecord();
        if (record instanceof ODocument) {
            Object iPojo = this.getUserObjectByRecord((OIdentifiable)record, null);
            this.deleteCascade((ODocument)record);
            ((ODatabaseDocumentInternal)this.underlying).delete((Object)record);
            if (this.getTransaction() instanceof OTransactionNoTx) {
                this.unregisterPojo(iPojo, (ODocument)record);
            }
        }
        return this;
    }

    public ODatabaseObject delete(ORID iRID, int iVersion) {
        this.deleteRecord(iRID, iVersion, false);
        return this;
    }

    public ODatabaseObject delete(ORecord iRecord) {
        ((ODatabaseDocumentInternal)this.underlying).delete((Object)iRecord);
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        this.checkOpenness();
        return ((ODatabaseDocumentInternal)this.underlying).countClass(iClassName);
    }

    @Override
    public long countClass(String iClassName, boolean iPolymorphic) {
        this.checkOpenness();
        return ((ODatabaseDocumentInternal)this.underlying).countClass(iClassName, iPolymorphic);
    }

    public long countClass(Class<?> iClass) {
        this.checkOpenness();
        return ((ODatabaseDocumentInternal)this.underlying).countClass(iClass.getSimpleName());
    }

    public ODictionary<Object> getDictionary() {
        this.checkOpenness();
        if (this.dictionary == null) {
            this.dictionary = new ODictionaryWrapper(this, (OIndex<OIdentifiable>)((ODatabaseDocumentInternal)this.underlying).getDictionary().getIndex());
        }
        return this.dictionary;
    }

    public OTransaction getTransaction() {
        return ((ODatabaseDocumentInternal)this.underlying).getTransaction();
    }

    public OObjectDatabaseTx begin() {
        ((ODatabaseDocumentInternal)this.underlying).begin();
        return this;
    }

    public OObjectDatabaseTx begin(OTransaction.TXTYPE iType) {
        ((ODatabaseDocumentInternal)this.underlying).begin(iType);
        return this;
    }

    public OObjectDatabaseTx begin(OTransaction iTx) {
        ((ODatabaseDocumentInternal)this.underlying).begin(iTx);
        return this;
    }

    public OObjectDatabaseTx commit() {
        return this.commit(false);
    }

    public OObjectDatabaseTx commit(boolean force) throws OTransactionException {
        ((ODatabaseDocumentInternal)this.underlying).commit(force);
        if (this.getTransaction().isActive()) {
            return this;
        }
        if (this.getTransaction().getRecordOperations() != null) {
            Object pojo = null;
            for (ORecordOperation entry : this.getTransaction().getRecordOperations()) {
                switch (entry.type) {
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        ORecord rec = entry.getRecord();
                        if (!(rec instanceof ODocument)) break;
                        this.unregisterPojo(pojo, (ODocument)rec);
                    }
                }
            }
        }
        return this;
    }

    public OObjectDatabaseTx rollback() {
        return this.rollback(false);
    }

    public OObjectDatabaseTx rollback(boolean force) throws OTransactionException {
        ((ODatabaseDocumentInternal)this.underlying).rollback(force);
        if (!((ODatabaseDocumentInternal)this.underlying).getTransaction().isActive()) {
            if (this.getTransaction().getRecordOperations() != null) {
                ArrayList<ORecordOperation> newEntries = new ArrayList<ORecordOperation>();
                for (ORecordOperation entry : this.getTransaction().getRecordOperations()) {
                    if (entry.type != 3) continue;
                    newEntries.add(entry);
                }
            } else {
                Object var2_3 = null;
            }
        }
        return this;
    }

    @Override
    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    public ODatabaseDocumentInternal getUnderlying() {
        return (ODatabaseDocumentInternal)this.underlying;
    }

    public int getVersion(Object iPojo) {
        this.checkOpenness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getVersion();
        }
        return OObjectSerializerHelper.getObjectVersion(iPojo);
    }

    public ORID getIdentity(Object iPojo) {
        this.checkOpenness();
        if (iPojo instanceof OIdentifiable) {
            return ((OIdentifiable)iPojo).getIdentity();
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getIdentity();
        }
        return OObjectSerializerHelper.getObjectID(this, iPojo);
    }

    public boolean isSaveOnlyDirty() {
        return this.saveOnlyDirty;
    }

    public void setSaveOnlyDirty(boolean saveOnlyDirty) {
        this.saveOnlyDirty = saveOnlyDirty;
    }

    public boolean isAutomaticSchemaGeneration() {
        return this.automaticSchemaGeneration;
    }

    public void setAutomaticSchemaGeneration(boolean automaticSchemaGeneration) {
        this.automaticSchemaGeneration = automaticSchemaGeneration;
    }

    public Object newInstance() {
        this.checkOpenness();
        return new ODocument();
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, byte iOperation) {
        return (DBTYPE)((ODatabaseDocumentInternal)this.underlying).checkSecurity(resourceGeneric, resourceSpecific, (int)iOperation);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric iResource, int iOperation, Object iResourceSpecific) {
        return (DBTYPE)((ODatabaseDocumentInternal)this.underlying).checkSecurity(iResource, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric iResource, int iOperation, Object ... iResourcesSpecific) {
        return (DBTYPE)((ODatabaseDocumentInternal)this.underlying).checkSecurity(iResource, iOperation, iResourcesSpecific);
    }

    @Override
    public ODocument pojo2Stream(Object iPojo, ODocument iRecord) {
        if (iPojo instanceof ProxyObject) {
            return ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).getDoc();
        }
        return OObjectSerializerHelper.toStream(iPojo, iRecord, this.getEntityManager(), this.getMetadata().getSchema().getClass(iPojo.getClass().getSimpleName()), this, this, this.saveOnlyDirty);
    }

    @Override
    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan) {
        return this.stream2pojo(iRecord, iPojo, iFetchPlan, false);
    }

    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan, boolean iReload) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iRecord = (ODocument)iRecord.load();
        }
        if (iReload) {
            if (iPojo != null) {
                if (iPojo instanceof Proxy) {
                    ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).setDoc(iRecord);
                    ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).updateLoadedFieldMap(iPojo, iReload);
                    return iPojo;
                }
                return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
            }
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iRecord.getClassName(), this.entityManager, iRecord, null, new Object[0]);
        }
        if (!(iPojo instanceof Proxy)) {
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
        }
        return iPojo;
    }

    @Override
    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    @Override
    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    public String getType() {
        return TYPE;
    }

    public ORecordConflictStrategy getConflictStrategy() {
        return ((ODatabaseDocumentInternal)this.underlying).getConflictStrategy();
    }

    public OObjectDatabaseTx setConflictStrategy(ORecordConflictStrategy iResolver) {
        ((ODatabaseDocumentInternal)this.underlying).setConflictStrategy(iResolver);
        return this;
    }

    public OObjectDatabaseTx setConflictStrategy(String iStrategyName) {
        this.getStorage().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    public ODocument getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
        if (iPojo instanceof Proxy) {
            return OObjectEntitySerializer.getDocument((Proxy)iPojo);
        }
        return OObjectEntitySerializer.getDocument((Proxy)OObjectEntitySerializer.serializeObject(iPojo, this));
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
        return this.getUserObjectByRecord(iRecord, iFetchPlan, true);
    }

    public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan, boolean iCreate) {
        ODocument document = (ODocument)iRecord.getRecord();
        return OObjectEntityEnhancer.getInstance().getProxiedInstance(document.getClassName(), this.getEntityManager(), document, null, new Object[0]);
    }

    @Override
    public void registerUserObject(Object iObject, ORecord iRecord) {
    }

    @Override
    public void registerUserObjectAfterLinkSave(ORecord iRecord) {
    }

    public void unregisterPojo(Object iObject, ODocument iRecord) {
    }

    @Override
    public boolean existsUserObjectByRID(ORID iRID) {
        return false;
    }

    public boolean isManaged(Object iEntity) {
        return false;
    }

    public void registerClassMethodFilter(Class<?> iClass, OObjectMethodFilter iMethodFilter) {
        OObjectEntityEnhancer.getInstance().registerClassMethodFilter(iClass, iMethodFilter);
    }

    public void deregisterClassMethodFilter(Class<?> iClass) {
        OObjectEntityEnhancer.getInstance().deregisterClassMethodFilter(iClass);
    }

    public String incrementalBackup(String path) {
        return ((ODatabaseDocumentInternal)this.underlying).incrementalBackup(path);
    }

    public void resetInitialization() {
        ((ODatabaseDocumentInternal)this.underlying).resetInitialization();
    }

    protected <RET> RET detachAll(Object iPojo, boolean returnNonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        return (RET)OObjectEntitySerializer.detachAll(iPojo, this, returnNonProxiedInstance, alreadyDetached, lazyObjects);
    }

    protected void deleteCascade(ODocument record) {
        if (record == null) {
            return;
        }
        List<String> toDeleteCascade = OObjectEntitySerializer.getCascadeDeleteFields(record.getClassName());
        if (toDeleteCascade != null) {
            for (String field : toDeleteCascade) {
                Object toDelete = record.field(field);
                if (toDelete instanceof OIdentifiable) {
                    if (toDelete == null) continue;
                    this.delete(((OIdentifiable)toDelete).getIdentity());
                    continue;
                }
                if (toDelete instanceof Collection) {
                    for (OIdentifiable cascadeRecord : (Collection)toDelete) {
                        if (cascadeRecord == null) continue;
                        this.delete(cascadeRecord.getIdentity());
                    }
                    continue;
                }
                if (!(toDelete instanceof Map)) continue;
                for (OIdentifiable cascadeRecord : ((Map)toDelete).values()) {
                    if (cascadeRecord == null) continue;
                    this.delete(cascadeRecord.getIdentity());
                }
            }
        }
    }

    protected void init() {
        this.entityManager = OEntityManager.getEntityManagerByDatabaseURL(this.getURL());
        this.entityManager.setClassHandler(OObjectEntityClassHandler.getInstance(this.getURL()));
        this.lazyLoading = true;
        if (!this.isClosed() && this.entityManager.getEntityClass(OUser.class.getSimpleName()) == null) {
            this.entityManager.registerEntityClass(OUser.class);
            this.entityManager.registerEntityClass(ORole.class);
        }
    }

    protected void deleteOrphans(OObjectProxyMethodHandler handler) {
        for (ORID orphan : handler.getOrphans()) {
            ODocument doc = (ODocument)orphan.getRecord();
            this.deleteCascade(doc);
            if (doc == null) continue;
            ((ODatabaseDocumentInternal)this.underlying).delete((Object)doc);
        }
        handler.getOrphans().clear();
    }

    private boolean deleteRecord(ORID iRID, int iVersion, boolean prohibitTombstones) {
        this.checkOpenness();
        if (iRID == null) {
            return true;
        }
        ODocument record = (ODocument)iRID.getRecord();
        if (record != null) {
            Object iPojo = this.getUserObjectByRecord((OIdentifiable)record, null);
            this.deleteCascade(record);
            if (prohibitTombstones) {
                ((ODatabaseDocumentInternal)this.underlying).cleanOutRecord(iRID, iVersion);
            } else {
                ((ODatabaseDocumentInternal)this.underlying).delete(iRID, iVersion);
            }
            if (this.getTransaction() instanceof OTransactionNoTx) {
                this.unregisterPojo(iPojo, record);
            }
        }
        return false;
    }

    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        return this.getUnderlying().addBlobCluster(iClusterName, iParameters);
    }

    public Set<Integer> getBlobClusterIds() {
        return this.getUnderlying().getBlobClusterIds();
    }

    public OSharedContext getSharedContext() {
        return ((ODatabaseDocumentInternal)this.underlying).getSharedContext();
    }

    private void registerFieldMappingStrategy() {
        if (!this.getConfiguration().getContextKeys().contains(OGlobalConfiguration.DOCUMENT_BINARY_MAPPING.getKey())) {
            this.getConfiguration().setValue(OGlobalConfiguration.DOCUMENT_BINARY_MAPPING, (Object)OGlobalConfiguration.DOCUMENT_BINARY_MAPPING.getValueAsInteger());
        }
    }

    public <RET extends OCommandRequest> RET command(OCommandRequest iCommand) {
        return (RET)new OCommandSQLPojoWrapper(this, ((ODatabaseDocumentInternal)this.underlying).command(iCommand));
    }

    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.checkOpenness();
        this.convertParameters(iArgs);
        List result = ((ODatabaseDocumentInternal)this.underlying).query(iCommand, iArgs);
        if (result == null) {
            return null;
        }
        ArrayList<OIdentifiable> resultPojo = new ArrayList<OIdentifiable>();
        for (OIdentifiable doc : result) {
            if (doc instanceof ODocument) {
                Object obj = ((ODocument)doc).getClassName() == null ? doc : this.getUserObjectByRecord((OIdentifiable)((ODocument)doc), iCommand.getFetchPlan(), true);
                resultPojo.add((OIdentifiable)obj);
                continue;
            }
            resultPojo.add(doc);
        }
        return (RET)resultPojo;
    }

    protected void convertParameters(Object ... iArgs) {
        if (iArgs == null) {
            return;
        }
        for (int i = 0; i < iArgs.length; ++i) {
            iArgs[i] = this.convertParameter(iArgs[i]);
        }
    }

    @Override
    public void setDirty(Object iPojo) {
        if (iPojo == null) {
            return;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            throw new OObjectNotManagedException("The object " + iPojo + " is not managed by current database");
        }
        record.setDirty();
    }

    @Override
    public void unsetDirty(Object iPojo) {
        if (iPojo == null) {
            return;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            return;
        }
        ORecordInternal.unsetDirty((ORecord)record);
    }

    protected Object convertParameter(Object iParameter) {
        if (iParameter != null) {
            ORID rid;
            if (iParameter instanceof Map) {
                Map map = (Map)iParameter;
                for (Map.Entry e : map.entrySet()) {
                    map.put(e.getKey(), this.convertParameter(e.getValue()));
                }
                return map;
            }
            if (iParameter instanceof Collection) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object object : (Collection)iParameter) {
                    result.add(this.convertParameter(object));
                }
                return result;
            }
            if (iParameter.getClass().isEnum()) {
                return ((Enum)iParameter).name();
            }
            if (!OType.isSimpleType((Object)iParameter) && (rid = this.getIdentity(iParameter)) != null && rid.isValid()) {
                return rid;
            }
        }
        return iParameter;
    }

    @Deprecated
    public boolean isMVCC() {
        return ((ODatabaseDocumentInternal)this.underlying).isMVCC();
    }

    @Deprecated
    public <DBTYPE extends ODatabase<?>> DBTYPE setMVCC(boolean iMvcc) {
        ((ODatabaseDocumentInternal)this.underlying).setMVCC(iMvcc);
        return (DBTYPE)this;
    }

    @Override
    @Deprecated
    public boolean isRetainObjects() {
        return false;
    }

    @Override
    @Deprecated
    public OObjectDatabaseTx setRetainObjects(boolean iValue) {
        return this;
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        return ((ODatabaseDocumentInternal)this.underlying).live(query, listener, args);
    }

    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        return ((ODatabaseDocumentInternal)this.underlying).live(query, listener, args);
    }

    public OResultSet query(String query, Object ... args) throws OCommandSQLParsingException, OCommandExecutionException {
        return ((ODatabaseDocumentInternal)this.underlying).query(query, args);
    }

    public OResultSet query(String query, Map args) throws OCommandSQLParsingException, OCommandExecutionException {
        return ((ODatabaseDocumentInternal)this.underlying).query(query, args);
    }

    public OResultSet command(String query, Object ... args) throws OCommandSQLParsingException, OCommandExecutionException {
        return ((ODatabaseDocumentInternal)this.underlying).command(query, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET extends List<?>> RET objectQuery(String iCommand, Object ... iArgs) {
        this.checkOpenness();
        this.convertParameters(iArgs);
        OResultSet result = ((ODatabaseDocumentInternal)this.underlying).query(iCommand, iArgs);
        if (result == null) {
            return null;
        }
        try {
            ArrayList<Object> resultPojo = new ArrayList<Object>();
            while (result.hasNext()) {
                OResult doc = result.next();
                if (doc.isElement()) {
                    OElement elem = (OElement)doc.getElement().get();
                    Object obj = elem.getSchemaType().isPresent() ? this.getUserObjectByRecord((OIdentifiable)elem, null, true) : elem;
                    resultPojo.add(obj);
                    continue;
                }
                resultPojo.add(doc);
            }
            ArrayList<Object> arrayList = resultPojo;
            return (RET)arrayList;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET extends List<?>> RET objectQuery(String iCommand, Map<String, Object> iArgs) {
        this.checkOpenness();
        this.convertParameters(iArgs);
        OResultSet result = ((ODatabaseDocumentInternal)this.underlying).query(iCommand, iArgs);
        if (result == null) {
            return null;
        }
        try {
            ArrayList<Object> resultPojo = new ArrayList<Object>();
            while (result.hasNext()) {
                OResult doc = result.next();
                if (doc.isElement()) {
                    OElement elem = (OElement)doc.getElement().get();
                    Object obj = elem.getSchemaType().isPresent() ? this.getUserObjectByRecord((OIdentifiable)elem, null, true) : elem;
                    resultPojo.add(obj);
                    continue;
                }
                resultPojo.add(doc);
            }
            ArrayList<Object> arrayList = resultPojo;
            return (RET)arrayList;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET extends List<?>> RET objectCommand(String iCommand, Object ... iArgs) {
        this.checkOpenness();
        this.convertParameters(iArgs);
        OResultSet result = ((ODatabaseDocumentInternal)this.underlying).command(iCommand, iArgs);
        if (result == null) {
            return null;
        }
        try {
            ArrayList<Object> resultPojo = new ArrayList<Object>();
            while (result.hasNext()) {
                OResult doc = result.next();
                if (doc.isElement()) {
                    OElement elem = (OElement)doc.getElement().get();
                    Object obj = elem.getSchemaType().isPresent() ? this.getUserObjectByRecord((OIdentifiable)elem, null, true) : elem;
                    resultPojo.add(obj);
                    continue;
                }
                resultPojo.add(doc);
            }
            ArrayList<Object> arrayList = resultPojo;
            return (RET)arrayList;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET extends List<?>> RET objectCommand(String iCommand, Map<String, Object> iArgs) {
        this.checkOpenness();
        this.convertParameters(iArgs);
        OResultSet result = ((ODatabaseDocumentInternal)this.underlying).command(iCommand, iArgs);
        if (result == null) {
            return null;
        }
        try {
            ArrayList<Object> resultPojo = new ArrayList<Object>();
            while (result.hasNext()) {
                OResult doc = result.next();
                if (doc.isElement()) {
                    OElement elem = (OElement)doc.getElement().get();
                    Object obj = elem.getSchemaType().isPresent() ? this.getUserObjectByRecord((OIdentifiable)elem, null, true) : elem;
                    resultPojo.add(obj);
                    continue;
                }
                resultPojo.add(doc);
            }
            ArrayList<Object> arrayList = resultPojo;
            return (RET)arrayList;
        }
        finally {
            result.close();
        }
    }

    public OResultSet command(String query, Map args) throws OCommandSQLParsingException, OCommandExecutionException {
        return ((ODatabaseDocumentInternal)this.underlying).command(query, args);
    }

    public OResultSet execute(String language, String script, Object ... args) throws OCommandExecutionException, OCommandScriptException {
        return ((ODatabaseDocumentInternal)this.underlying).execute(language, script, args);
    }

    public OResultSet execute(String language, String script, Map<String, ?> args) throws OCommandExecutionException, OCommandScriptException {
        return ((ODatabaseDocumentInternal)this.underlying).execute(language, script, args);
    }

    @Override
    public <T> T executeWithRetry(int nRetries, Function<ODatabaseSession, T> function) throws IllegalStateException, IllegalArgumentException, ONeedRetryException, UnsupportedOperationException {
        return (T)((ODatabaseDocumentInternal)this.underlying).executeWithRetry(nRetries, function);
    }
}

