/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.BinaryInterface;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.AbstractIndexAwarePredicate;
import com.hazelcast.util.SetUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@BinaryInterface
public class InPredicate
extends AbstractIndexAwarePredicate {
    Comparable[] values;
    private volatile Set<Comparable> convertedInValues;

    public InPredicate() {
    }

    public InPredicate(String attribute, Comparable ... values) {
        super(attribute);
        if (values == null) {
            throw new NullPointerException("Array can't be null");
        }
        this.values = values;
    }

    @Override
    protected boolean applyForSingleAttributeValue(Map.Entry entry, Comparable attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        Set<Comparable<Object>> set = this.convertedInValues;
        if (set == null) {
            set = SetUtil.createHashSet(this.values.length);
            for (Comparable value : this.values) {
                set.add(this.convert(entry, attributeValue, value));
            }
            this.convertedInValues = set;
        }
        return set.contains(attributeValue);
    }

    @Override
    public Set<QueryableEntry> filter(QueryContext queryContext) {
        Index index = this.getIndex(queryContext);
        if (index != null) {
            return index.getRecords(this.values);
        }
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.values.length);
        for (Comparable value : this.values) {
            out.writeObject(value);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        int len = in.readInt();
        this.values = new Comparable[len];
        for (int i = 0; i < len; ++i) {
            this.values[i] = (Comparable)in.readObject();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attributeName);
        sb.append(" IN (");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int getId() {
        return 7;
    }
}

