/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.executorservice;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.InvocationBuilder;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.concurrent.ExecutionException;

public abstract class AbstractExecutorServiceCancelMessageTask<P>
extends AbstractCallableMessageTask<P> {
    private static final int CANCEL_TRY_COUNT = 50;
    private static final int CANCEL_TRY_PAUSE_MILLIS = 250;

    public AbstractExecutorServiceCancelMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        InvocationBuilder builder = this.createInvocationBuilder();
        builder.setTryCount(50).setTryPauseMillis(250L);
        InternalCompletableFuture future = builder.invoke();
        boolean result = false;
        try {
            result = (Boolean)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logException(e);
        }
        catch (ExecutionException e) {
            this.logException(e);
        }
        return result;
    }

    protected abstract InvocationBuilder createInvocationBuilder() throws UnknownHostException;

    private void logException(Exception e) {
        ILogger logger = this.nodeEngine.getLogger(AbstractExecutorServiceCancelMessageTask.class);
        logger.warning(e);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "cancel";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

