/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.OrientDBDistributed;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedCoordinator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitContext;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OCoordinatedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ONetworkSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.ONetworkSubmitResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OOperationRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.network.OOperationResponse;
import com.orientechnologies.orient.server.distributed.impl.metadata.ODistributedContext;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;

public class OCoordinatedExecutorMessageHandler
implements OCoordinatedExecutor {
    private OrientDBDistributed distributed;

    public OCoordinatedExecutorMessageHandler(OrientDBDistributed distributed) {
        this.distributed = distributed;
    }

    private void waitOnline(String node, String database) {
        try {
            OHazelcastPlugin plugin = this.distributed.getPlugin();
            plugin.waitUntilNodeOnline(plugin.getLocalNodeName(), database);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void executeOperationRequest(OOperationRequest request) {
        this.waitOnline(request.getSenderNode(), request.getDatabase());
        ODistributedContext distributedContext = this.distributed.getDistributedContext(request.getDatabase());
        ODistributedExecutor executor = distributedContext.getExecutor();
        ODistributedMember member = executor.getMember(request.getSenderNode());
        executor.receive(member, request.getId(), request.getRequest());
    }

    @Override
    public void executeOperationResponse(OOperationResponse response) {
        this.waitOnline(response.getSenderNode(), response.getDatabase());
        ODistributedContext distributedContext = this.distributed.getDistributedContext(response.getDatabase());
        ODistributedCoordinator coordinator = distributedContext.getCoordinator();
        if (coordinator == null) {
            OLogManager.instance().error((Object)this, "Received coordinator response on a node that is not a coordinator ignoring it", null, new Object[0]);
        } else {
            ODistributedMember member = coordinator.getMember(response.getSenderNode());
            coordinator.receive(member, response.getId(), response.getResponse());
        }
    }

    @Override
    public void executeSubmitResponse(ONetworkSubmitResponse response) {
        this.waitOnline(response.getSenderNode(), response.getDatabase());
        ODistributedContext distributedContext = this.distributed.getDistributedContext(response.getDatabase());
        OSubmitContext context = distributedContext.getSubmitContext();
        context.receive(response.getOperationId(), response.getResponse());
    }

    @Override
    public void executeSubmitRequest(ONetworkSubmitRequest request) {
        this.waitOnline(request.getSenderNode(), request.getDatabase());
        ODistributedContext distributedContext = this.distributed.getDistributedContext(request.getDatabase());
        ODistributedCoordinator coordinator = distributedContext.getCoordinator();
        if (coordinator == null) {
            OLogManager.instance().error((Object)this, "Received submit request on a node that is not a coordinator ignoring it", null, new Object[0]);
        } else {
            ODistributedMember member = coordinator.getMember(request.getSenderNode());
            coordinator.submit(member, request.getOperationId(), request.getRequest());
        }
    }
}

