/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task.transaction;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OStreamable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OToLeaderTransactionTaskResponse
implements OStreamable {
    private List<OCreatedRecordResponse> created;
    private List<OUpdatedRecordResponse> updated;
    private List<ODeletedRecordResponse> deleted;

    public OToLeaderTransactionTaskResponse() {
    }

    public OToLeaderTransactionTaskResponse(Map<ORID, ORecord> createdRecords, Map<ORID, ORecord> updatedRecords, Set<ORID> deletedRecord) {
        this.created = new ArrayList<OCreatedRecordResponse>();
        for (Map.Entry<ORID, ORecord> create : createdRecords.entrySet()) {
            this.created.add(new OCreatedRecordResponse(create.getKey(), create.getValue().getIdentity(), create.getValue().getVersion()));
        }
        this.updated = new ArrayList<OUpdatedRecordResponse>();
        for (Map.Entry<ORID, ORecord> update : updatedRecords.entrySet()) {
            this.updated.add(new OUpdatedRecordResponse(update.getKey(), update.getValue().getVersion()));
        }
        this.deleted = deletedRecord.stream().map(x -> new ODeletedRecordResponse((ORID)x)).collect(Collectors.toList());
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.created.size());
        for (OCreatedRecordResponse createdRecord : this.created) {
            out.writeShort(createdRecord.currentRid.getClusterId());
            out.writeLong(createdRecord.currentRid.getClusterPosition());
            out.writeShort(createdRecord.createdRid.getClusterId());
            out.writeLong(createdRecord.createdRid.getClusterPosition());
            out.writeInt(createdRecord.version);
        }
        out.writeInt(this.updated.size());
        for (OUpdatedRecordResponse updatedRecord : this.updated) {
            out.writeShort(updatedRecord.rid.getClusterId());
            out.writeLong(updatedRecord.rid.getClusterPosition());
            out.writeInt(updatedRecord.version);
        }
        out.writeInt(this.deleted.size());
        for (ODeletedRecordResponse deleteRecord : this.deleted) {
            out.writeShort(deleteRecord.rid.getClusterId());
            out.writeLong(deleteRecord.rid.getClusterPosition());
        }
    }

    public void fromStream(DataInput in) throws IOException {
        int createdRecords = in.readInt();
        this.created = new ArrayList<OCreatedRecordResponse>(createdRecords);
        for (int i = 0; i < createdRecords; ++i) {
            ORecordId currentRid = new ORecordId();
            currentRid.fromStream(in);
            ORecordId createdRid = new ORecordId();
            createdRid.fromStream(in);
            int version = in.readInt();
            this.created.add(new OCreatedRecordResponse((ORID)currentRid, (ORID)createdRid, version));
        }
        int updatedRecords = in.readInt();
        this.updated = new ArrayList<OUpdatedRecordResponse>(updatedRecords);
        for (int i = 0; i < updatedRecords; ++i) {
            ORecordId rid = new ORecordId();
            rid.fromStream(in);
            int version = in.readInt();
            this.updated.add(new OUpdatedRecordResponse((ORID)rid, version));
        }
        int deletedRecords = in.readInt();
        this.deleted = new ArrayList<ODeletedRecordResponse>(deletedRecords);
        for (int i = 0; i < deletedRecords; ++i) {
            ORecordId rid = new ORecordId();
            rid.fromStream(in);
            this.deleted.add(new ODeletedRecordResponse((ORID)rid));
        }
    }

    public List<OCreatedRecordResponse> getCreated() {
        return this.created;
    }

    public List<OUpdatedRecordResponse> getUpdated() {
        return this.updated;
    }

    public List<ODeletedRecordResponse> getDeleted() {
        return this.deleted;
    }

    public static class ODeletedRecordResponse {
        private final ORID rid;

        public ODeletedRecordResponse(ORID rid) {
            this.rid = rid;
        }

        public ORID getRid() {
            return this.rid;
        }
    }

    public static class OUpdatedRecordResponse {
        private final ORID rid;
        private final int version;

        public OUpdatedRecordResponse(ORID rid, int version) {
            this.rid = rid;
            this.version = version;
        }

        public ORID getRid() {
            return this.rid;
        }

        public int getVersion() {
            return this.version;
        }
    }

    public static class OCreatedRecordResponse {
        private final ORID currentRid;
        private final ORID createdRid;
        private final int version;

        public OCreatedRecordResponse(ORID currentRid, ORID createdRid, int version) {
            this.currentRid = currentRid;
            this.createdRid = createdRid;
            this.version = version;
        }

        public ORID getCreatedRid() {
            return this.createdRid;
        }

        public ORID getCurrentRid() {
            return this.currentRid;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

