/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.serialization.OStreamable;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OUpdateDatabaseStatusTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 25;
    private String databaseName;
    private String status;
    private OLogSequenceNumber lsn;

    public OUpdateDatabaseStatusTask() {
    }

    public OUpdateDatabaseStatusTask(String databaseName, String status, OLogSequenceNumber lsn) {
        this.databaseName = databaseName;
        this.status = status;
        this.lsn = lsn;
    }

    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedDatabase database1 = iManager.getMessageService().getDatabase(this.databaseName);
        if (database1 != null && this.lsn != null) {
            database1.getSyncConfiguration().setLastLSN(this.getNodeSource(), this.lsn, false);
        }
        if (database != null && ((OAbstractPaginatedStorage)database.getStorage().getUnderlying()).getLSN() != null) {
            return new OUpdateResult(((OAbstractPaginatedStorage)database.getStorage().getUnderlying()).getLSN());
        }
        return null;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public boolean isUsingDatabase() {
        return false;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.databaseName);
        out.writeUTF(this.status);
        if (this.lsn == null) {
            out.writeLong(-1L);
            out.writeLong(-1L);
        } else {
            out.writeLong(this.lsn.getSegment());
            out.writeLong(this.lsn.getPosition());
        }
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.databaseName = in.readUTF();
        this.status = in.readUTF();
        long seg = in.readLong();
        long pos = in.readLong();
        this.lsn = seg == -1L && pos == -1L ? null : new OLogSequenceNumber(seg, pos);
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "upd_db_status";
    }

    public int getFactoryId() {
        return 25;
    }

    public String toString() {
        return this.getName();
    }

    public static class OUpdateResult
    implements OStreamable {
        private OLogSequenceNumber sequenceNumber;

        public OUpdateResult() {
        }

        public OUpdateResult(OLogSequenceNumber sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public void toStream(DataOutput out) throws IOException {
            this.sequenceNumber.toStream(out);
        }

        public void fromStream(DataInput in) throws IOException {
            this.sequenceNumber = new OLogSequenceNumber(in);
        }

        public OLogSequenceNumber getSequenceNumber() {
            return this.sequenceNumber;
        }
    }
}

