/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;

public class OUnreachableServerLocalTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 28;
    private String unreachableServer;

    public OUnreachableServerLocalTask(String unreachableServer) {
        this.unreachableServer = unreachableServer;
    }

    public int[] getPartitionKey() {
        return ANY;
    }

    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Freeing all the resources owned by the unreachable server '%s'...", (Object[])new Object[]{this.unreachableServer});
        ODistributedDatabase dDatabase = iManager.getMessageService().getDatabase(database.getName());
        dDatabase.unlockResourcesOfServer(database, this.unreachableServer);
        return Boolean.TRUE;
    }

    public boolean hasResponse() {
        return false;
    }

    public String getName() {
        return "unreachable-server";
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_LONG_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public int getFactoryId() {
        return 28;
    }

    public String toString() {
        return this.getName() + " server: " + this.unreachableServer;
    }
}

