/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OTransactionPhase2Task
extends OAbstractReplicatedTask {
    public static final int FACTORYID = 44;
    private ODistributedRequestId transactionId;
    private boolean success;
    private int[] involvedClusters;
    private boolean hasResponse = false;
    private volatile int retryCount = 0;

    public OTransactionPhase2Task(ODistributedRequestId transactionId, boolean success, int[] involvedClusters, OLogSequenceNumber lsn) {
        this.transactionId = transactionId;
        this.success = success;
        this.involvedClusters = involvedClusters;
        this.lastLSN = lsn;
    }

    public OTransactionPhase2Task() {
    }

    public String getName() {
        return "TxPhase2";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        int nodeId = in.readInt();
        long messageId = in.readLong();
        this.transactionId = new ODistributedRequestId(nodeId, messageId);
        int length = in.readInt();
        this.involvedClusters = new int[length];
        for (int i = 0; i < length; ++i) {
            this.involvedClusters[i] = in.readInt();
        }
        this.success = in.readBoolean();
        this.lastLSN = new OLogSequenceNumber(in);
        if (this.lastLSN.getSegment() == -1L && this.lastLSN.getSegment() == -1L) {
            this.lastLSN = null;
        }
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.transactionId.getNodeId());
        out.writeLong(this.transactionId.getMessageId());
        out.writeInt(this.involvedClusters.length);
        for (int involvedCluster : this.involvedClusters) {
            out.writeInt(involvedCluster);
        }
        out.writeBoolean(this.success);
        if (this.lastLSN == null) {
            new OLogSequenceNumber(-1L, -1L).toStream(out);
        } else {
            this.lastLSN.toStream(out);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (this.success) {
            if (((ODatabaseDocumentDistributed)database).commit2pc(this.transactionId) != null) {
                this.hasResponse = true;
                return "OK";
            }
            ++this.retryCount;
            if (this.retryCount < database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) {
                OLogManager.instance().info((Object)this, "Received second phase but not yet first phase, re-enqueue second phase", new Object[0]);
                ((ODatabaseDocumentDistributed)database).getStorageDistributed().getLocalDistributedDatabase().reEnqueue(requestId.getNodeId(), requestId.getMessageId(), database.getName(), (ORemoteTask)this, this.retryCount);
                this.hasResponse = false;
                return "OK";
            }
            Orient.instance().submit(() -> {
                OLogManager.instance().warn((Object)this, "Reached limit of retry for commit tx:%s forcing database re-install", new Object[]{this.transactionId});
                iManager.installDatabase(false, database.getName(), true, true);
            });
            this.hasResponse = true;
            return "KO";
        }
        if (((ODatabaseDocumentDistributed)database).rollback2pc(this.transactionId)) {
            this.hasResponse = true;
            return "OK";
        }
        ++this.retryCount;
        if (this.retryCount < database.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) {
            OLogManager.instance().info((Object)this, "Received second phase but not yet first phase, re-enqueue second phase", new Object[0]);
            ((ODatabaseDocumentDistributed)database).getStorageDistributed().getLocalDistributedDatabase().reEnqueue(requestId.getNodeId(), requestId.getMessageId(), database.getName(), (ORemoteTask)this, this.retryCount);
            this.hasResponse = false;
            return "OK";
        }
        this.hasResponse = true;
        return "KO";
    }

    public OLogSequenceNumber getLastLSN() {
        return super.getLastLSN();
    }

    public boolean isIdempotent() {
        return false;
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public int getFactoryId() {
        return 44;
    }

    public int[] getPartitionKey() {
        return this.involvedClusters;
    }
}

