/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.DistributedQueryContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.result.binary.OResultSerializerNetwork;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSetLifecycleDecorator;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.sql.executor.ODistributedResultSet;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ORunQueryExecutionPlanTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 40;
    private String nodeName;
    private OExecutionPlan plan;
    private Map<Object, Object> inputParams;

    public ORunQueryExecutionPlanTask(OExecutionPlan executionPlan, Map<Object, Object> inputParameters, String nodeName) {
        this.plan = executionPlan;
        this.inputParams = inputParameters;
        this.nodeName = nodeName;
    }

    public ORunQueryExecutionPlanTask() {
    }

    public String getName() {
        return "RunQueryExecutionPlan";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODatabaseDocumentInternal prev = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentInternal db = database.copy();
            db.activateOnCurrentThread();
            OLocalResultSetLifecycleDecorator result = ((ODatabaseDocumentEmbedded)db).query(this.plan, this.inputParams);
            DistributedQueryContext context = new DistributedQueryContext();
            context.setDb((ODatabase)db);
            context.setResultSet((OResultSet)result);
            context.setQueryId(String.valueOf(UUID.randomUUID()));
            ((OSharedContextEmbedded)db.getSharedContext()).getActiveDistributedQueries().put(context.getQueryId(), context);
            OResultInternal serialized = new OResultInternal();
            serialized.setProperty("queryId", (Object)context.getQueryId());
            ArrayList<OResult> firstPage = new ArrayList<OResult>();
            for (int i = 0; i < 100 && result.hasNext(); ++i) {
                firstPage.add(result.next());
            }
            serialized.setProperty("data", firstPage);
            OResultInternal oResultInternal = serialized;
            return oResultInternal;
        }
        finally {
            if (prev == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(prev);
            }
        }
    }

    public OResultSet getResult(ODistributedResponse resp, ODatabaseDocumentDistributed db) {
        OResult payload = (OResult)resp.getPayload();
        ODistributedResultSet result = new ODistributedResultSet();
        result.setQueryId((String)payload.getProperty("queryId"));
        result.setData((List)payload.getProperty("data"));
        result.setDatabase(db);
        result.setNodeName(this.nodeName);
        return result;
    }

    public void toStream(DataOutput out) throws IOException {
        OResultSerializerNetwork serializerNetwork = new OResultSerializerNetwork();
        BytesContainer container = new BytesContainer();
        serializerNetwork.serialize(this.serializePlan(this.plan), container);
        OResultInternal params = new OResultInternal();
        params.setProperty("params", this.convertParams(this.inputParams));
        serializerNetwork.serialize((OResult)params, container);
        OResultInternal metadata = new OResultInternal();
        params.setProperty("nodeName", (Object)this.nodeName);
        serializerNetwork.serialize((OResult)metadata, container);
        container.fitBytes();
        out.write(container.bytes.length);
        out.write(container.bytes);
    }

    private Map<String, Object> convertParams(Map<Object, Object> inputParams) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : inputParams.entrySet()) {
            result.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        OResultSerializerNetwork serializerNetwork = new OResultSerializerNetwork();
        int length = in.readInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = in.readByte();
        }
        BytesContainer container = new BytesContainer(bytes);
        OResultInternal serializedExecutionPlan = serializerNetwork.deserialize(container);
        this.inputParams = (Map)serializerNetwork.deserialize(container).getProperty("params");
        OResultInternal metadata = serializerNetwork.deserialize(container);
        this.nodeName = (String)metadata.getProperty("nodeName");
        this.plan = this.deserializePlan((OResult)serializedExecutionPlan);
    }

    private OExecutionPlan deserializePlan(OResult serializedExecutionPlan) {
        String className = (String)serializedExecutionPlan.getProperty("javaType");
        OInternalExecutionPlan internalPlan = null;
        try {
            internalPlan = (OInternalExecutionPlan)Class.forName(className).newInstance();
            internalPlan.deserialize(serializedExecutionPlan);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new ODistributedException("Cannot create execution plan: " + className), (Throwable)e);
        }
        return internalPlan;
    }

    private OResult serializePlan(OExecutionPlan plan) {
        return ((OInternalExecutionPlan)plan).serialize();
    }

    public int getFactoryId() {
        return 40;
    }
}

