/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class OBackgroundBackup
implements Runnable {
    private OSyncDatabaseTask oSyncDatabaseTask;
    private final ODistributedServerManager iManager;
    private final ODatabaseDocumentInternal database;
    private final File resultedBackupFile;
    private final String finalBackupPath;
    private final AtomicBoolean incremental = new AtomicBoolean(false);
    private final AtomicReference<ODistributedMomentum> momentum;
    private final ODistributedDatabase dDatabase;
    private final ODistributedRequestId requestId;
    private final File completedFile;

    public OBackgroundBackup(OSyncDatabaseTask oSyncDatabaseTask, ODistributedServerManager iManager, ODatabaseDocumentInternal database, File resultedBackupFile, String finalBackupPath, OModifiableBoolean incremental, AtomicReference<ODistributedMomentum> momentum, ODistributedDatabase dDatabase, ODistributedRequestId requestId, File completedFile) {
        this.oSyncDatabaseTask = oSyncDatabaseTask;
        this.iManager = iManager;
        this.database = database;
        this.resultedBackupFile = resultedBackupFile;
        this.finalBackupPath = finalBackupPath;
        this.momentum = momentum;
        this.dDatabase = dDatabase;
        this.requestId = requestId;
        this.completedFile = completedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread.currentThread().setName("OrientDB SyncDatabase node=" + this.iManager.getLocalNodeName() + " db=" + this.database.getName());
        try {
            try {
                this.database.activateOnCurrentThread();
                ODistributedServerLog.info((Object)this, (String)this.iManager.getLocalNodeName(), (String)this.oSyncDatabaseTask.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Compressing database '%s' %d clusters %s...", (Object[])new Object[]{this.database.getName(), this.database.getClusterNames().size(), this.database.getClusterNames()});
                try {
                    OWriteAheadLog wal = ((OAbstractPaginatedStorage)this.database.getStorage().getUnderlying()).getWALInstance();
                    OLogSequenceNumber lsn = wal.end();
                    if (lsn == null) {
                        lsn = new OLogSequenceNumber(-1L, -1L);
                    }
                    wal.addCutTillLimit(lsn);
                    this.resultedBackupFile.delete();
                    try {
                        this.database.incrementalBackup(this.finalBackupPath);
                    }
                    finally {
                        wal.removeCutTillLimit(lsn);
                    }
                    File dir = new File(this.finalBackupPath);
                    File file = new File(this.finalBackupPath, dir.listFiles()[0].getName() + ".completed");
                    file.createNewFile();
                    this.incremental.set(true);
                    OLogManager.instance().info((Object)this, "Sending Enterprise backup (" + this.database.getName() + ") for node sync", new Object[0]);
                }
                catch (UnsupportedOperationException e) {
                    if (this.resultedBackupFile.exists()) {
                        this.resultedBackupFile.delete();
                    } else {
                        this.resultedBackupFile.getParentFile().mkdirs();
                    }
                    this.resultedBackupFile.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(this.resultedBackupFile);
                    try {
                        this.database.backup((OutputStream)fileOutputStream, null, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                OBackgroundBackup.this.momentum.set(OBackgroundBackup.this.dDatabase.getSyncConfiguration().getMomentum().copy());
                                return null;
                            }
                        }, ODistributedServerLog.isDebugEnabled() ? new OCommandOutputListener(){

                            public void onMessage(String iText) {
                                if (iText.startsWith("\n")) {
                                    iText = iText.substring(1);
                                }
                                OLogManager.instance().debug((Object)this, iText, new Object[0]);
                            }
                        } : null, OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger(), 0x800000);
                    }
                    finally {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            OLogManager.instance().debug((Object)this, "Error performing backup ", (Throwable)e2, new Object[0]);
                        }
                    }
                }
                ODistributedServerLog.info((Object)this, (String)this.iManager.getLocalNodeName(), (String)this.oSyncDatabaseTask.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Backup of database '%s' completed. lastOperationId=%s...", (Object[])new Object[]{this.database.getName(), this.requestId});
            }
            catch (Exception e) {
                try {
                    OLogManager.instance().error((Object)this, "Cannot execute backup of database '%s' for deploy database", (Throwable)e, new Object[]{this.database.getName()});
                    throw e;
                }
                catch (Throwable throwable) {
                    try {
                        this.completedFile.createNewFile();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e2, new Object[]{this.completedFile});
                    }
                    throw throwable;
                }
            }
            try {
                this.completedFile.createNewFile();
                return;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot create file of backup completed: %s", (Throwable)e, new Object[]{this.completedFile});
                return;
            }
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb((Object)this, "Error during backup processing, file %s will be deleted\n", (Throwable)e, new Object[]{this.resultedBackupFile});
            try {
                Files.deleteIfExists(Paths.get(this.resultedBackupFile.getAbsolutePath(), new String[0]));
                return;
            }
            catch (IOException ioe) {
                OLogManager.instance().errorNoDb((Object)this, "Can not delete file %s\n", (Throwable)ioe, new Object[]{this.resultedBackupFile});
            }
        }
    }

    public AtomicBoolean getIncremental() {
        return this.incremental;
    }

    public File getResultedBackupFile() {
        return this.resultedBackupFile;
    }

    public String getFinalBackupPath() {
        return this.finalBackupPath;
    }
}

