/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.orient.core.cache.OCommandCacheSoftRefs;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBDistributed;
import com.orientechnologies.orient.core.db.viewmanager.ViewManager;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryImpl;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.schedule.OSchedulerImpl;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.sql.executor.OQueryStats;
import com.orientechnologies.orient.core.sql.parser.OExecutionPlanCache;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.impl.ViewManagerDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.ODistributedContext;
import com.orientechnologies.orient.server.distributed.impl.metadata.OIndexManagerDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.OSchemaDistributed;

public class OSharedContextDistributed
extends OSharedContext {
    private ViewManager viewManager;
    private ODistributedContext distributedContext;

    public OSharedContextDistributed(OStorage storage, OrientDBDistributed orientDB) {
        this.orientDB = orientDB;
        this.storage = storage;
        this.schema = new OSchemaDistributed(this);
        this.security = OSecurityManager.instance().newSecurity();
        this.indexManager = new OIndexManagerDistributed(storage);
        this.functionLibrary = new OFunctionLibraryImpl();
        this.scheduler = new OSchedulerImpl();
        this.sequenceLibrary = new OSequenceLibraryImpl();
        this.liveQueryOps = new OLiveQueryHook.OLiveQueryOps();
        this.liveQueryOpsV2 = new OLiveQueryHookV2.OLiveQueryOps();
        this.commandCache = new OCommandCacheSoftRefs(storage.getUnderlying());
        this.statementCache = new OStatementCache(storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.STATEMENT_CACHE_SIZE));
        this.executionPlanCache = new OExecutionPlanCache(storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.STATEMENT_CACHE_SIZE));
        this.registerListener(this.executionPlanCache);
        this.queryStats = new OQueryStats();
        this.distributedContext = new ODistributedContext(storage, orientDB);
        this.viewManager = new ViewManagerDistributed(orientDB, storage.getName());
    }

    public synchronized void load(ODatabaseDocumentInternal database) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            long timer = PROFILER.startChrono();
            try {
                if (!this.loaded) {
                    this.schema.load(database);
                    this.indexManager.load(database);
                    this.schema.forceSnapshot(database);
                    this.security.load();
                    this.functionLibrary.load(database);
                    this.scheduler.load(database);
                    this.sequenceLibrary.load(database);
                    this.schema.onPostIndexManagement();
                    this.viewManager.load();
                    this.loaded = true;
                }
            }
            finally {
                PROFILER.stopChrono(PROFILER.getDatabaseMetric(database.getStorage().getName(), "metadata.load"), "Loading of database metadata", timer, "db.*.metadata.load");
            }
            return null;
        });
    }

    public synchronized void close() {
        this.viewManager.close();
        this.schema.close();
        this.security.close(false);
        this.indexManager.close();
        this.functionLibrary.close();
        this.scheduler.close();
        this.sequenceLibrary.close();
        this.commandCache.shutdown();
        this.statementCache.clear();
        this.executionPlanCache.invalidate();
        this.liveQueryOps.close();
        this.liveQueryOpsV2.close();
        this.distributedContext.close();
    }

    public synchronized void reload(ODatabaseDocumentInternal database) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            this.schema.reload(database);
            this.indexManager.reload();
            this.schema.forceSnapshot(database);
            this.security.load();
            this.functionLibrary.load(database);
            this.sequenceLibrary.load(database);
            this.commandCache.clear();
            this.scheduler.load(database);
            return null;
        });
    }

    public synchronized void create(ODatabaseDocumentInternal database) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            this.schema.create(database);
            this.indexManager.create(database);
            this.security.create();
            this.functionLibrary.create(database);
            this.sequenceLibrary.create(database);
            this.security.createClassTrigger();
            this.scheduler.create(database);
            this.schema.createClass(database, "V");
            this.schema.createClass(database, "E");
            try {
                OIndexFactory factory = OIndexes.getFactory((String)OClass.INDEX_TYPE.SPATIAL.toString(), (String)"LUCENE");
                if (factory != null && factory instanceof ODatabaseLifecycleListener) {
                    ((ODatabaseLifecycleListener)factory).onCreate((ODatabaseInternal)database);
                }
            }
            catch (OIndexException oIndexException) {
                // empty catch block
            }
            this.schema.forceSnapshot(database);
            this.loaded = true;
            return null;
        });
    }

    public ViewManager getViewManager() {
        return this.viewManager;
    }

    public ODistributedContext getDistributedContext() {
        return this.distributedContext;
    }
}

