/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.impl.metadata.OClassDistributed;
import java.util.List;

public class OSchemaDistributed
extends OSchemaEmbedded {
    public OSchemaDistributed(OSharedContext sharedContext) {
        super(sharedContext);
    }

    protected OClassImpl createClassInstance(String className, int[] clusterIds) {
        return new OClassDistributed((OSchemaShared)this, className, clusterIds);
    }

    protected OClassImpl createClassInstance(ODocument c) {
        return new OClassDistributed((OSchemaShared)this, c, (String)c.field("name"));
    }

    public void acquireSchemaWriteLock(ODatabaseDocumentInternal database) {
        if (this.executeThroughDistributedStorage(database)) {
            ((OAutoshardedStorage)database.getStorage()).acquireDistributedExclusiveLock(0L);
        }
        super.acquireSchemaWriteLock(database);
    }

    public void releaseSchemaWriteLock(ODatabaseDocumentInternal database, boolean iSave) {
        try {
            super.releaseSchemaWriteLock(database, iSave);
        }
        finally {
            if (this.executeThroughDistributedStorage(database)) {
                ((OAutoshardedStorage)database.getStorage()).releaseDistributedExclusiveLock();
            }
        }
    }

    protected void doDropClass(ODatabaseDocumentInternal database, String className) {
        if (this.executeThroughDistributedStorage(database)) {
            OStorage storage = database.getStorage();
            StringBuilder cmd = new StringBuilder("drop class ");
            cmd.append(className);
            cmd.append(" unsafe");
            OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)storage;
            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
            commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
            database.command((OCommandRequest)commandSQL).execute(new Object[0]);
            this.dropClassInternal(database, className);
        } else {
            this.dropClassInternal(database, className);
        }
    }

    protected void doDropView(ODatabaseDocumentInternal database, String name) {
        OStorage storage = database.getStorage();
        if (this.executeThroughDistributedStorage(database)) {
            StringBuilder cmd = new StringBuilder("drop view ");
            cmd.append(name);
            cmd.append(" unsafe");
            OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)storage;
            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
            commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
            database.command((OCommandRequest)commandSQL).execute(new Object[0]);
        }
        this.dropViewInternal(database, name);
    }

    protected void doRealCreateView(ODatabaseDocumentInternal database, OViewConfig config, int[] clusterIds) throws OSchemaShared.ClusterIdsAreEmptyException {
        if (this.executeThroughDistributedStorage(database)) {
            OStorage storage = database.getStorage();
            StringBuilder cmd = new StringBuilder("create view ");
            cmd.append('`');
            cmd.append(config.getName());
            cmd.append('`');
            this.createViewInternal(database, config, clusterIds);
            cmd.append(" cluster ");
            for (int i = 0; i < clusterIds.length; ++i) {
                if (i > 0) {
                    cmd.append(',');
                } else {
                    cmd.append(' ');
                }
                cmd.append(clusterIds[i]);
            }
            OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)storage;
            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
            commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
            Object object = database.command((OCommandRequest)commandSQL).execute(new Object[0]);
        } else {
            this.createViewInternal(database, config, clusterIds);
        }
    }

    protected void doRealCreateClass(ODatabaseDocumentInternal database, String className, List<OClass> superClassesList, int[] clusterIds) throws OSchemaShared.ClusterIdsAreEmptyException {
        if (this.executeThroughDistributedStorage(database)) {
            OStorage storage = database.getStorage();
            StringBuilder cmd = new StringBuilder("create class ");
            cmd.append('`');
            cmd.append(className);
            cmd.append('`');
            boolean first = true;
            for (OClass superClass : superClassesList) {
                if (first) {
                    cmd.append(" extends ");
                } else {
                    cmd.append(", ");
                }
                cmd.append(superClass.getName());
                first = false;
            }
            if (clusterIds != null) {
                if (clusterIds.length == 1 && clusterIds[0] == -1) {
                    cmd.append(" abstract");
                } else {
                    cmd.append(" cluster ");
                    for (int i = 0; i < clusterIds.length; ++i) {
                        if (i > 0) {
                            cmd.append(',');
                        } else {
                            cmd.append(' ');
                        }
                        cmd.append(clusterIds[i]);
                    }
                }
            }
            this.createClassInternal(database, className, clusterIds, superClassesList);
            OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)storage;
            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
            commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
            Object object = database.command((OCommandRequest)commandSQL).execute(new Object[0]);
        } else {
            this.createClassInternal(database, className, clusterIds, superClassesList);
        }
    }
}

