/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.metadata;

import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBDistributed;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.impl.OClusterPositionAllocatorDatabase;
import com.orientechnologies.orient.server.distributed.impl.OIncrementOperationalLog;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedCoordinator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedLockManagerImpl;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLoopBackDistributeMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OOperationLog;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitContext;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitContextImpl;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import com.orientechnologies.orient.server.distributed.impl.metadata.OTransactionContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;

public class ODistributedContext {
    private Map<OSessionOperationId, OTransactionContext> transactions = new ConcurrentHashMap<OSessionOperationId, OTransactionContext>();
    private ODistributedExecutor executor;
    private OSubmitContext submitContext;
    private ODistributedCoordinator coordinator;
    private OrientDBInternal context;
    private String databaseName;
    private OOperationLog opLog;

    public ODistributedContext(OStorage storage, OrientDBDistributed context) {
        this.executor = new ODistributedExecutor(Executors.newSingleThreadExecutor(), this.opLog, (OrientDBInternal)context, storage.getName());
        this.submitContext = new OSubmitContextImpl();
        this.coordinator = null;
        this.context = context;
        this.databaseName = storage.getName();
        this.initOpLog();
    }

    private void initOpLog() {
        this.opLog = new OIncrementOperationalLog();
    }

    public void registerTransaction(OSessionOperationId requestId, OTransactionInternal tx) {
        this.transactions.put(requestId, new OTransactionContext(tx));
    }

    public OTransactionContext getTransaction(OSessionOperationId operationId) {
        return this.transactions.get(operationId);
    }

    public void closeTransaction(OSessionOperationId operationId) {
        this.transactions.remove(operationId);
    }

    public ODistributedExecutor getExecutor() {
        return this.executor;
    }

    public OSubmitContext getSubmitContext() {
        return this.submitContext;
    }

    public synchronized ODistributedCoordinator getCoordinator() {
        return this.coordinator;
    }

    public synchronized void makeCoordinator(String nodeName, OSharedContext context) {
        if (this.coordinator == null) {
            this.coordinator = new ODistributedCoordinator(Executors.newSingleThreadExecutor(), this.opLog, new ODistributedLockManagerImpl(0), new OClusterPositionAllocatorDatabase(context));
            OLoopBackDistributeMember loopBack = new OLoopBackDistributeMember(nodeName, this.databaseName, this.submitContext, this.coordinator, this.executor);
            this.coordinator.join(loopBack);
            this.submitContext.setCoordinator(loopBack);
            this.executor.join(loopBack);
        }
    }

    public synchronized void setExternalCoordinator(ODistributedMember lockManager) {
        if (this.coordinator != null) {
            this.coordinator.close();
            this.coordinator = null;
        }
        this.submitContext.setCoordinator(lockManager);
        this.executor.join(lockManager);
    }

    public synchronized void close() {
        if (this.coordinator != null) {
            this.coordinator.close();
        }
        this.executor.close();
    }
}

