/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedCoordinator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLockGuard;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OSubmitRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexKeyChange;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexKeyOperation;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexOperationRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionFirstPhaseOperation;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionFirstPhaseResponseHandler;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class OTransactionSubmit
implements OSubmitRequest {
    private List<ORecordOperationRequest> operations;
    private List<OIndexOperationRequest> indexes;

    public OTransactionSubmit(Collection<ORecordOperation> ops, List<OIndexOperationRequest> indexes, boolean useDeltas) {
        this.operations = OTransactionSubmit.genOps(ops, useDeltas);
        this.indexes = indexes;
    }

    public OTransactionSubmit() {
    }

    public static List<ORecordOperationRequest> genOps(Collection<ORecordOperation> ops, boolean useDeltas) {
        ArrayList<ORecordOperationRequest> operations = new ArrayList<ORecordOperationRequest>();
        for (ORecordOperation txEntry : ops) {
            if (txEntry.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(txEntry.type);
            request.setVersion(txEntry.getRecord().getVersion());
            request.setId(txEntry.getRecord().getIdentity());
            request.setRecordType(ORecordInternal.getRecordType((ORecord)txEntry.getRecord()));
            switch (txEntry.type) {
                case 3: {
                    request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(txEntry.getRecord(), false));
                    request.setContentChanged(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                    break;
                }
                case 1: {
                    request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(txEntry.getRecord(), useDeltas));
                    request.setContentChanged(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                    break;
                }
            }
            operations.add(request);
        }
        return operations;
    }

    public static List<OIndexOperationRequest> genIndexes(Map<String, OTransactionIndexChanges> indexOperations, OTransactionInternal tx) {
        ArrayList<OIndexOperationRequest> idx = new ArrayList<OIndexOperationRequest>();
        for (Map.Entry<String, OTransactionIndexChanges> index : indexOperations.entrySet()) {
            OTransactionIndexChanges changes = index.getValue();
            ArrayList<OIndexKeyChange> keys = new ArrayList<OIndexKeyChange>();
            for (Map.Entry entry : changes.changesPerKey.entrySet()) {
                ArrayList<OIndexKeyOperation> oper = new ArrayList<OIndexKeyOperation>();
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry operat : ((OTransactionIndexChangesPerKey)entry.getValue()).entries) {
                    ORID identity = operat.value.getIdentity();
                    if (!identity.isPersistent()) {
                        identity = tx.getRecordEntry(identity).getRID();
                    }
                    if (operat.operation == OTransactionIndexChanges.OPERATION.PUT) {
                        oper.add(new OIndexKeyOperation(1, identity));
                        continue;
                    }
                    oper.add(new OIndexKeyOperation(2, identity));
                }
                keys.add(new OIndexKeyChange(entry.getKey(), oper));
            }
            if (index.getValue().nullKeyChanges != null) {
                ArrayList<OIndexKeyOperation> oper = new ArrayList<OIndexKeyOperation>();
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry operat : index.getValue().nullKeyChanges.entries) {
                    ORID identity = operat.value.getIdentity();
                    if (!identity.isPersistent()) {
                        identity = tx.getRecordEntry(identity).getRID();
                    }
                    if (operat.operation == OTransactionIndexChanges.OPERATION.PUT) {
                        oper.add(new OIndexKeyOperation(1, identity));
                        continue;
                    }
                    oper.add(new OIndexKeyOperation(2, identity));
                }
                keys.add(new OIndexKeyChange(null, oper));
            }
            idx.add(new OIndexOperationRequest(index.getKey(), changes.cleared, keys));
        }
        return idx;
    }

    @Override
    public void begin(ODistributedMember member, OSessionOperationId operationId, ODistributedCoordinator coordinator) {
        ODistributedLockManager lockManager = coordinator.getLockManager();
        TreeSet<OPair> keys = new TreeSet<OPair>();
        for (OIndexOperationRequest oIndexOperationRequest : this.indexes) {
            for (OIndexKeyChange keyChange : oIndexOperationRequest.getIndexKeyChanges()) {
                if (keyChange.getKey() == null) {
                    keys.add(new OPair((Comparable)((Object)oIndexOperationRequest.getIndexName()), (Object)"null"));
                    continue;
                }
                keys.add(new OPair((Comparable)((Object)oIndexOperationRequest.getIndexName()), (Object)keyChange.getKey().toString()));
            }
        }
        ArrayList<OLockGuard> guards = new ArrayList<OLockGuard>();
        for (OPair oPair : keys) {
            guards.add(lockManager.lockIndexKey((String)((Object)oPair.getKey()), oPair.getValue()));
        }
        TreeSet<ORID> treeSet = new TreeSet<ORID>();
        for (ORecordOperationRequest entry : this.operations) {
            if (3 == entry.getType()) {
                int clusterId = entry.getId().getClusterId();
                long pos = coordinator.getAllocator().allocate(clusterId);
                ORecordId value = new ORecordId(clusterId, pos);
                entry.setOldId(entry.getId());
                entry.setId((ORID)value);
                continue;
            }
            treeSet.add(entry.getId());
        }
        for (ORID rid : treeSet) {
            guards.add(lockManager.lockRecord(rid));
        }
        OTransactionFirstPhaseResponseHandler oTransactionFirstPhaseResponseHandler = new OTransactionFirstPhaseResponseHandler(operationId, this, member, guards);
        OTransactionFirstPhaseOperation request = new OTransactionFirstPhaseOperation(operationId, this.operations, this.indexes);
        coordinator.sendOperation(this, request, oTransactionFirstPhaseResponseHandler);
    }

    @Override
    public void deserialize(DataInput input) throws IOException {
        int size = input.readInt();
        this.operations = new ArrayList<ORecordOperationRequest>(size);
        while (size-- > 0) {
            ORecordOperationRequest op = new ORecordOperationRequest();
            op.deserialize(input);
            this.operations.add(op);
        }
        size = input.readInt();
        this.indexes = new ArrayList<OIndexOperationRequest>(size);
        while (size-- > 0) {
            OIndexOperationRequest change = new OIndexOperationRequest();
            change.deserialize(input);
            this.indexes.add(change);
        }
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        output.writeInt(this.operations.size());
        for (ORecordOperationRequest operation : this.operations) {
            operation.serialize(output);
        }
        output.writeInt(this.indexes.size());
        for (OIndexOperationRequest change : this.indexes) {
            change.serialize(output);
        }
    }

    @Override
    public int getRequestType() {
        return 1;
    }
}

