/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedCoordinator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLockGuard;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ORequestContext;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OResponseHandler;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionSecondPhaseResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionSubmit;
import java.util.List;

public class OTransactionSecondPhaseResponseHandler
implements OResponseHandler {
    private OTransactionSubmit request;
    private ODistributedMember requester;
    private final boolean success;
    private int responseCount = 0;
    private final List<OLockGuard> guards;
    private OSessionOperationId operationId;
    private boolean replySent = false;

    public OTransactionSecondPhaseResponseHandler(boolean success, OTransactionSubmit request, ODistributedMember requester, List<OLockGuard> guards, OSessionOperationId operationId) {
        this.success = success;
        this.request = request;
        this.requester = requester;
        this.guards = guards;
        this.operationId = operationId;
    }

    @Override
    public boolean receive(ODistributedCoordinator coordinator, ORequestContext context, ODistributedMember member, ONodeResponse response) {
        ++this.responseCount;
        if (this.responseCount >= context.getQuorum()) {
            OTransactionSecondPhaseResponse values = (OTransactionSecondPhaseResponse)response;
            if (this.success) {
                if (this.guards != null) {
                    for (OLockGuard guard : this.guards) {
                        guard.release();
                    }
                    this.guards.clear();
                }
                if (!this.replySent) {
                    coordinator.reply(this.requester, this.operationId, new OTransactionResponse(true, values.getCreatedRecords(), values.getUpdatedRecords(), values.getDeletedRecords()));
                    this.replySent = true;
                }
            }
        }
        return this.responseCount == context.getInvolvedMembers().size();
    }

    @Override
    public boolean timeout(ODistributedCoordinator coordinator, ORequestContext context) {
        return false;
    }
}

