/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OCreatedRecordResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.ODeletedRecordResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OUpdatedRecordResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OTransactionSecondPhaseResponse
implements ONodeResponse {
    private boolean success;
    private List<OCreatedRecordResponse> createdRecords;
    private List<OUpdatedRecordResponse> updatedRecords;
    private List<ODeletedRecordResponse> deletedRecords;

    public OTransactionSecondPhaseResponse() {
    }

    public OTransactionSecondPhaseResponse(boolean success, List<OCreatedRecordResponse> createdRecords, List<OUpdatedRecordResponse> updatedRecords, List<ODeletedRecordResponse> deletedRecords) {
        this.success = success;
        this.createdRecords = createdRecords;
        this.updatedRecords = updatedRecords;
        this.deletedRecords = deletedRecords;
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        output.writeBoolean(this.success);
        output.writeInt(this.createdRecords.size());
        for (OCreatedRecordResponse createdRecord : this.createdRecords) {
            createdRecord.serialize(output);
        }
        output.writeInt(this.updatedRecords.size());
        for (OUpdatedRecordResponse updatedRecord : this.updatedRecords) {
            updatedRecord.serialize(output);
        }
        output.writeInt(this.deletedRecords.size());
        for (ODeletedRecordResponse deletedRecord : this.deletedRecords) {
            deletedRecord.serialize(output);
        }
    }

    @Override
    public void deserialize(DataInput input) throws IOException {
        this.success = input.readBoolean();
        int createSize = input.readInt();
        this.createdRecords = new ArrayList<OCreatedRecordResponse>(createSize);
        while (createSize-- > 0) {
            OCreatedRecordResponse createResponse = new OCreatedRecordResponse();
            createResponse.deserialize(input);
            this.createdRecords.add(createResponse);
        }
        int updateSize = input.readInt();
        this.updatedRecords = new ArrayList<OUpdatedRecordResponse>(updateSize);
        while (updateSize-- > 0) {
            OUpdatedRecordResponse updateRecord = new OUpdatedRecordResponse();
            updateRecord.deserialize(input);
            this.updatedRecords.add(updateRecord);
        }
        int deleteSize = input.readInt();
        this.deletedRecords = new ArrayList<ODeletedRecordResponse>(deleteSize);
        while (deleteSize-- > 0) {
            ODeletedRecordResponse deletedResponse = new ODeletedRecordResponse();
            deletedResponse.deserialize(input);
            this.deletedRecords.add(deletedResponse);
        }
    }

    @Override
    public int getResponseType() {
        return 2;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<OCreatedRecordResponse> getCreatedRecords() {
        return this.createdRecords;
    }

    public List<ODeletedRecordResponse> getDeletedRecords() {
        return this.deletedRecords;
    }

    public List<OUpdatedRecordResponse> getUpdatedRecords() {
        return this.updatedRecords;
    }
}

