/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.OTransactionOptimisticDistributed;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OCreatedRecordResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.ODeletedRecordResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionSecondPhaseResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OUpdatedRecordResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class OTransactionSecondPhaseOperation
implements ONodeRequest {
    private OSessionOperationId operationId;
    private boolean success;

    public OTransactionSecondPhaseOperation(OSessionOperationId operationId, boolean success) {
        this.operationId = operationId;
        this.success = success;
    }

    public OTransactionSecondPhaseOperation() {
    }

    @Override
    public ONodeResponse execute(ODistributedMember nodeFrom, OLogId opId, ODistributedExecutor executor, ODatabaseDocumentInternal session) {
        OTransactionOptimisticDistributed tx = ((ODatabaseDocumentDistributed)session).txSecondPhase(this.operationId, this.success);
        ArrayList<OCreatedRecordResponse> createdRecords = new ArrayList<OCreatedRecordResponse>(tx.getCreatedRecords().size());
        ArrayList<OUpdatedRecordResponse> updatedRecords = new ArrayList<OUpdatedRecordResponse>(tx.getUpdatedRecords().size());
        ArrayList<ODeletedRecordResponse> deletedRecords = new ArrayList<ODeletedRecordResponse>(tx.getDeletedRecord().size());
        if (tx != null) {
            for (Map.Entry<ORID, ORecord> entry : tx.getCreatedRecords().entrySet()) {
                ORecord record = entry.getValue();
                createdRecords.add(new OCreatedRecordResponse(entry.getKey(), record.getIdentity(), record.getVersion()));
            }
            for (Map.Entry<ORID, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
                updatedRecords.add(new OUpdatedRecordResponse(entry.getKey(), entry.getValue().getVersion()));
            }
            for (ORID id : tx.getDeletedRecord()) {
                deletedRecords.add(new ODeletedRecordResponse(id));
            }
        }
        return new OTransactionSecondPhaseResponse(true, createdRecords, updatedRecords, deletedRecords);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTransactionSecondPhaseOperation that = (OTransactionSecondPhaseOperation)o;
        return this.success == that.success;
    }

    public int hashCode() {
        return Objects.hash(this.success);
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        this.operationId.serialize(output);
        output.writeBoolean(this.success);
    }

    @Override
    public void deserialize(DataInput input) throws IOException {
        this.operationId = new OSessionOperationId();
        this.operationId.deserialize(input);
        this.success = input.readBoolean();
    }

    @Override
    public int getRequestType() {
        return 2;
    }

    public OSessionOperationId getOperationId() {
        return this.operationId;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

