/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OConcurrentModificationResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OExceptionResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OTransactionResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OUniqueKeyViolationResult;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OTransactionFirstPhaseResult
implements ONodeResponse {
    private Type type;
    private OTransactionResult resultMetadata;

    public OTransactionFirstPhaseResult() {
    }

    public OTransactionFirstPhaseResult(Type type, OTransactionResult resultMetadata) {
        this.type = type;
        this.resultMetadata = resultMetadata;
    }

    public Type getType() {
        return this.type;
    }

    public OTransactionResult getResultMetadata() {
        return this.resultMetadata;
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        switch (this.type) {
            case SUCCESS: {
                output.writeByte(1);
                break;
            }
            case UNIQUE_KEY_VIOLATION: {
                output.writeByte(2);
                break;
            }
            case CONCURRENT_MODIFICATION_EXCEPTION: {
                output.writeByte(3);
                break;
            }
            case EXCEPTION: {
                output.writeByte(4);
            }
        }
        if (this.type != Type.SUCCESS) {
            this.resultMetadata.serialize(output);
        }
    }

    @Override
    public void deserialize(DataInput input) throws IOException {
        byte t = input.readByte();
        switch (t) {
            case 1: {
                this.type = Type.SUCCESS;
                break;
            }
            case 2: {
                this.type = Type.UNIQUE_KEY_VIOLATION;
                this.resultMetadata = new OUniqueKeyViolationResult();
                break;
            }
            case 3: {
                this.type = Type.CONCURRENT_MODIFICATION_EXCEPTION;
                this.resultMetadata = new OConcurrentModificationResult();
                break;
            }
            case 4: {
                this.type = Type.EXCEPTION;
                this.resultMetadata = new OExceptionResult();
            }
        }
        if (this.type != Type.SUCCESS) {
            this.resultMetadata.deserialize(input);
        }
    }

    @Override
    public int getResponseType() {
        return 1;
    }

    public static enum Type {
        SUCCESS,
        CONCURRENT_MODIFICATION_EXCEPTION,
        UNIQUE_KEY_VIOLATION,
        EXCEPTION;

    }
}

