/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedCoordinator;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLockGuard;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ORequestContext;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OResponseHandler;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OCreatedRecordResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.ODeletedRecordResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionFirstPhaseResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionSecondPhaseOperation;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionSecondPhaseResponseHandler;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionSubmit;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OUpdatedRecordResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OConcurrentModificationResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OUniqueKeyViolationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OTransactionFirstPhaseResponseHandler
implements OResponseHandler {
    private final OSessionOperationId operationId;
    private final OTransactionSubmit request;
    private final ODistributedMember requester;
    private int responseCount = 0;
    private final Set<ODistributedMember> success = new HashSet<ODistributedMember>();
    private final Map<ORID, List<ODistributedMember>> cme = new HashMap<ORID, List<ODistributedMember>>();
    private final Map<String, List<ODistributedMember>> unique = new HashMap<String, List<ODistributedMember>>();
    private final List<ODistributedMember> exceptions = new ArrayList<ODistributedMember>();
    private boolean secondPhaseSent = false;
    private boolean replySent = false;
    private final List<OLockGuard> guards;

    public OTransactionFirstPhaseResponseHandler(OSessionOperationId operationId, OTransactionSubmit request, ODistributedMember requester, List<OLockGuard> guards) {
        this.operationId = operationId;
        this.request = request;
        this.requester = requester;
        this.guards = guards;
    }

    @Override
    public boolean receive(ODistributedCoordinator coordinator, ORequestContext context, ODistributedMember member, ONodeResponse response) {
        ++this.responseCount;
        OTransactionFirstPhaseResult result = (OTransactionFirstPhaseResult)response;
        switch (result.getType()) {
            case SUCCESS: {
                this.success.add(member);
                break;
            }
            case CONCURRENT_MODIFICATION_EXCEPTION: {
                OConcurrentModificationResult concurrentModification = (OConcurrentModificationResult)result.getResultMetadata();
                List<ODistributedMember> members = this.cme.get(concurrentModification.getRecordId());
                if (members == null) {
                    members = new ArrayList<ODistributedMember>();
                    this.cme.put((ORID)concurrentModification.getRecordId(), members);
                }
                members.add(member);
                break;
            }
            case UNIQUE_KEY_VIOLATION: {
                OUniqueKeyViolationResult uniqueKeyViolation = (OUniqueKeyViolationResult)result.getResultMetadata();
                List<ODistributedMember> members = this.unique.get(uniqueKeyViolation.getKeyStringified());
                if (members == null) {
                    members = new ArrayList<ODistributedMember>();
                    this.unique.put(uniqueKeyViolation.getKeyStringified(), members);
                }
                members.add(member);
                break;
            }
            case EXCEPTION: {
                this.exceptions.add(member);
            }
        }
        int quorum = context.getQuorum();
        if (this.responseCount >= quorum && !this.secondPhaseSent) {
            if (this.success.size() >= quorum) {
                this.sendSecondPhaseSuccess(coordinator);
            }
            for (Map.Entry<ORID, List<ODistributedMember>> entry : this.cme.entrySet()) {
                if (entry.getValue().size() < quorum) continue;
                this.sendSecondPhaseError(coordinator);
                break;
            }
            for (Map.Entry<Object, List<ODistributedMember>> entry : this.unique.entrySet()) {
                if (entry.getValue().size() < quorum) continue;
                this.sendSecondPhaseError(coordinator);
                break;
            }
            if (this.responseCount == context.getInvolvedMembers().size()) {
                this.sendSecondPhaseError(coordinator);
            }
        }
        return this.responseCount == context.getInvolvedMembers().size();
    }

    private void sendSecondPhaseError(ODistributedCoordinator coordinator) {
        if (this.secondPhaseSent) {
            return;
        }
        OTransactionSecondPhaseResponseHandler responseHandler = new OTransactionSecondPhaseResponseHandler(false, this.request, this.requester, null, this.operationId);
        coordinator.sendOperation(null, new OTransactionSecondPhaseOperation(this.operationId, false), responseHandler);
        if (this.guards != null) {
            for (OLockGuard guard : this.guards) {
                guard.release();
            }
        }
        if (!this.replySent) {
            coordinator.reply(this.requester, this.operationId, new OTransactionResponse(false, new ArrayList<OCreatedRecordResponse>(), new ArrayList<OUpdatedRecordResponse>(), new ArrayList<ODeletedRecordResponse>()));
            this.replySent = true;
        }
        this.secondPhaseSent = true;
    }

    private void sendSecondPhaseSuccess(ODistributedCoordinator coordinator) {
        if (this.secondPhaseSent) {
            return;
        }
        OTransactionSecondPhaseResponseHandler responseHandler = new OTransactionSecondPhaseResponseHandler(true, this.request, this.requester, this.guards, this.operationId);
        coordinator.sendOperation(null, new OTransactionSecondPhaseOperation(this.operationId, true), responseHandler);
        this.secondPhaseSent = true;
    }

    @Override
    public boolean timeout(ODistributedCoordinator coordinator, ORequestContext context) {
        return false;
    }
}

