/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedExecutor;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ODistributedMember;
import com.orientechnologies.orient.server.distributed.impl.coordinator.OLogId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.ONodeResponse;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexOperationRequest;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OSessionOperationId;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OTransactionFirstPhaseResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OConcurrentModificationResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OExceptionResult;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.results.OUniqueKeyViolationResult;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OTransactionFirstPhaseOperation
implements ONodeRequest {
    private OSessionOperationId operationId;
    private List<ORecordOperationRequest> operations;
    private List<OIndexOperationRequest> indexes;
    protected static final boolean useDeltas = false;

    public OTransactionFirstPhaseOperation(OSessionOperationId operationId, List<ORecordOperationRequest> operations, List<OIndexOperationRequest> indexes) {
        this.operationId = operationId;
        this.operations = operations;
        this.indexes = indexes;
    }

    public OTransactionFirstPhaseOperation() {
    }

    @Override
    public ONodeResponse execute(ODistributedMember nodeFrom, OLogId opId, ODistributedExecutor executor, ODatabaseDocumentInternal session) {
        OTransactionFirstPhaseResult response;
        try {
            ((ODatabaseDocumentDistributed)session).txFirstPhase(this.operationId, this.operations, this.indexes, false);
            response = new OTransactionFirstPhaseResult(OTransactionFirstPhaseResult.Type.SUCCESS, null);
        }
        catch (OConcurrentModificationException ex) {
            OConcurrentModificationResult metadata = new OConcurrentModificationResult((ORecordId)ex.getRid().getIdentity(), ex.getEnhancedRecordVersion(), ex.getEnhancedDatabaseVersion());
            response = new OTransactionFirstPhaseResult(OTransactionFirstPhaseResult.Type.CONCURRENT_MODIFICATION_EXCEPTION, metadata);
        }
        catch (ORecordDuplicatedException ex) {
            OUniqueKeyViolationResult metadata = new OUniqueKeyViolationResult(ex.getKey().toString(), null, (ORecordId)ex.getRid().getIdentity(), ex.getIndexName());
            response = new OTransactionFirstPhaseResult(OTransactionFirstPhaseResult.Type.UNIQUE_KEY_VIOLATION, metadata);
        }
        catch (RuntimeException ex) {
            response = new OTransactionFirstPhaseResult(OTransactionFirstPhaseResult.Type.EXCEPTION, new OExceptionResult(ex));
        }
        return response;
    }

    public static List<ORecordOperation> convert(ODatabaseDocumentInternal database, List<ORecordOperationRequest> operations) {
        ArrayList<ORecordOperation> ops = new ArrayList<ORecordOperation>();
        for (ORecordOperationRequest req : operations) {
            byte type = req.getType();
            if (type == 0) continue;
            ORecord record = null;
            switch (type) {
                case 3: {
                    record = ORecordSerializerNetworkV37.INSTANCE.fromStream(req.getRecord(), null, null);
                    ORecordInternal.setRecordSerializer((ORecord)record, (ORecordSerializer)database.getSerializer());
                    break;
                }
                case 1: {
                    record = ORecordSerializerNetworkV37.INSTANCE.fromStream(req.getRecord(), null, null);
                    ORecordInternal.setRecordSerializer((ORecord)record, (ORecordSerializer)database.getSerializer());
                    break;
                }
                case 2: {
                    record = database.getRecord((OIdentifiable)req.getId());
                    if (record != null) break;
                    record = Orient.instance().getRecordFactoryManager().newInstance(req.getRecordType(), req.getId().getClusterId(), database);
                }
            }
            if (type != 3 && type != 2 && type != 1) continue;
            ORecordInternal.setIdentity((ORecord)record, (ORecordId)((ORecordId)req.getId()));
            ORecordInternal.setVersion((ORecord)record, (int)req.getVersion());
            ORecordOperation op = new ORecordOperation((OIdentifiable)record, type);
            ops.add(op);
        }
        return ops;
    }

    @Override
    public void serialize(DataOutput output) throws IOException {
        this.operationId.serialize(output);
        output.writeInt(this.operations.size());
        for (ORecordOperationRequest operation : this.operations) {
            operation.serialize(output);
        }
        output.writeInt(this.indexes.size());
        for (OIndexOperationRequest change : this.indexes) {
            change.serialize(output);
        }
    }

    @Override
    public void deserialize(DataInput input) throws IOException {
        this.operationId = new OSessionOperationId();
        this.operationId.deserialize(input);
        int size = input.readInt();
        this.operations = new ArrayList<ORecordOperationRequest>(size);
        while (size-- > 0) {
            ORecordOperationRequest op = new ORecordOperationRequest();
            op.deserialize(input);
            this.operations.add(op);
        }
        size = input.readInt();
        this.indexes = new ArrayList<OIndexOperationRequest>(size);
        while (size-- > 0) {
            OIndexOperationRequest change = new OIndexOperationRequest();
            change.deserialize(input);
            this.indexes.add(change);
        }
    }

    @Override
    public int getRequestType() {
        return 1;
    }

    public List<OIndexOperationRequest> getIndexes() {
        return this.indexes;
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public OSessionOperationId getOperationId() {
        return this.operationId;
    }
}

