/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public class OSessionOperationId {
    private UUID uuid;

    public OSessionOperationId() {
        this.init();
    }

    public void init() {
        this.uuid = UUID.randomUUID();
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeLong(this.uuid.getMostSignificantBits());
        output.writeLong(this.uuid.getLeastSignificantBits());
    }

    public void deserialize(DataInput input) throws IOException {
        long most = input.readLong();
        long least = input.readLong();
        this.uuid = new UUID(most, least);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSessionOperationId that = (OSessionOperationId)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

