/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexKeyChange;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OIndexOperationRequest {
    private String indexName;
    private boolean cleanIndexValues;
    private List<OIndexKeyChange> indexKeyChanges;

    public OIndexOperationRequest() {
    }

    public OIndexOperationRequest(String indexName, boolean cleanIndexValues, List<OIndexKeyChange> indexKeyChanges) {
        this.indexName = indexName;
        this.cleanIndexValues = cleanIndexValues;
        this.indexKeyChanges = indexKeyChanges;
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeUTF(this.indexName);
        output.writeBoolean(this.cleanIndexValues);
        output.writeInt(this.indexKeyChanges.size());
        for (OIndexKeyChange change : this.indexKeyChanges) {
            change.serialize(output);
        }
    }

    public void deserialize(DataInput input) throws IOException {
        this.indexName = input.readUTF();
        this.cleanIndexValues = input.readBoolean();
        int size = input.readInt();
        this.indexKeyChanges = new ArrayList<OIndexKeyChange>(size);
        while (size-- > 0) {
            OIndexKeyChange change = new OIndexKeyChange();
            change.deserialize(input);
            this.indexKeyChanges.add(change);
        }
    }

    public List<OIndexKeyChange> getIndexKeyChanges() {
        return this.indexKeyChanges;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isCleanIndexValues() {
        return this.cleanIndexValues;
    }
}

