/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.coordinator.transaction;

import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetwork;
import com.orientechnologies.orient.server.distributed.impl.coordinator.transaction.OIndexKeyOperation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OIndexKeyChange {
    private static final int SIMPLE = 1;
    private static final int COMPOSITE = 2;
    private Object key;
    private List<OIndexKeyOperation> operations;

    public OIndexKeyChange(Object key, List<OIndexKeyOperation> operations) {
        this.key = key;
        this.operations = operations;
    }

    public OIndexKeyChange() {
    }

    public Object getKey() {
        return this.key;
    }

    public void serialize(DataOutput output) throws IOException {
        this.serializeKey(this.key, output);
        output.writeInt(this.operations.size());
        for (OIndexKeyOperation operation : this.operations) {
            operation.serialize(output);
        }
    }

    private void serializeKey(Object key, DataOutput output) throws IOException {
        if (key instanceof OCompositeKey) {
            output.writeBoolean(true);
            List keys = ((OCompositeKey)key).getKeys();
            output.writeInt(keys.size());
            for (Object o : keys) {
                this.serializeKey(o, output);
            }
        } else {
            output.writeBoolean(false);
            if (key == null) {
                output.writeBoolean(true);
            } else {
                output.writeBoolean(false);
                OType valType = OType.getTypeByValue((Object)key);
                output.writeByte(valType.getId());
                byte[] bytes = ORecordSerializerNetwork.INSTANCE.serializeValue(key, valType);
                output.writeInt(bytes.length);
                output.write(bytes);
            }
        }
    }

    public void deserialize(DataInput input) throws IOException {
        this.key = this.deserializeKey(input);
        int operations = input.readInt();
        this.operations = new ArrayList<OIndexKeyOperation>(operations);
        while (operations-- > 0) {
            OIndexKeyOperation operation = new OIndexKeyOperation();
            operation.deserialize(input);
            this.operations.add(operation);
        }
    }

    private Object deserializeKey(DataInput input) throws IOException {
        boolean composite = input.readBoolean();
        if (composite) {
            int size = input.readInt();
            ArrayList<Object> keys = new ArrayList<Object>(size);
            while (size-- > 0) {
                keys.add(this.deserializeKey(input));
            }
            return new OCompositeKey(keys);
        }
        boolean isNull = input.readBoolean();
        if (isNull) {
            return null;
        }
        OType keyType = OType.getById((byte)input.readByte());
        int keySize = input.readInt();
        byte[] bytes = new byte[keySize];
        input.readFully(bytes);
        return ORecordSerializerNetwork.INSTANCE.deserializeValue(bytes, keyType);
    }

    public List<OIndexKeyOperation> getOperations() {
        return this.operations;
    }
}

